/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.launchwizard.model.LaunchWizardResponse;
import software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternDataSummary;
import software.amazon.awssdk.services.launchwizard.model.WorkloadDeploymentPatternDataSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkloadDeploymentPatternsResponse
extends LaunchWizardResponse
implements ToCopyableBuilder<Builder, ListWorkloadDeploymentPatternsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkloadDeploymentPatternsResponse.getter(ListWorkloadDeploymentPatternsResponse::nextToken)).setter(ListWorkloadDeploymentPatternsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<WorkloadDeploymentPatternDataSummary>> WORKLOAD_DEPLOYMENT_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workloadDeploymentPatterns").getter(ListWorkloadDeploymentPatternsResponse.getter(ListWorkloadDeploymentPatternsResponse::workloadDeploymentPatterns)).setter(ListWorkloadDeploymentPatternsResponse.setter(Builder::workloadDeploymentPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadDeploymentPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadDeploymentPatternDataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKLOAD_DEPLOYMENT_PATTERNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListWorkloadDeploymentPatternsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns;

    private ListWorkloadDeploymentPatternsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workloadDeploymentPatterns = builder.workloadDeploymentPatterns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkloadDeploymentPatterns() {
        return this.workloadDeploymentPatterns != null && !(this.workloadDeploymentPatterns instanceof SdkAutoConstructList);
    }

    public final List<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns() {
        return this.workloadDeploymentPatterns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkloadDeploymentPatterns() ? this.workloadDeploymentPatterns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkloadDeploymentPatternsResponse)) {
            return false;
        }
        ListWorkloadDeploymentPatternsResponse other = (ListWorkloadDeploymentPatternsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkloadDeploymentPatterns() == other.hasWorkloadDeploymentPatterns() && Objects.equals(this.workloadDeploymentPatterns(), other.workloadDeploymentPatterns());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkloadDeploymentPatternsResponse").add("NextToken", (Object)this.nextToken()).add("WorkloadDeploymentPatterns", this.hasWorkloadDeploymentPatterns() ? this.workloadDeploymentPatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workloadDeploymentPatterns": {
                return Optional.ofNullable(clazz.cast(this.workloadDeploymentPatterns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("workloadDeploymentPatterns", WORKLOAD_DEPLOYMENT_PATTERNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkloadDeploymentPatternsResponse, T> g) {
        return obj -> g.apply((ListWorkloadDeploymentPatternsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LaunchWizardResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkloadDeploymentPatternsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workloadDeploymentPatterns(model.workloadDeploymentPatterns);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkloadDeploymentPatternDataSummary.Builder> getWorkloadDeploymentPatterns() {
            List<WorkloadDeploymentPatternDataSummary.Builder> result = WorkloadDeploymentPatternDataSummaryListCopier.copyToBuilder(this.workloadDeploymentPatterns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkloadDeploymentPatterns(Collection<WorkloadDeploymentPatternDataSummary.BuilderImpl> workloadDeploymentPatterns) {
            this.workloadDeploymentPatterns = WorkloadDeploymentPatternDataSummaryListCopier.copyFromBuilder(workloadDeploymentPatterns);
        }

        @Override
        public final Builder workloadDeploymentPatterns(Collection<WorkloadDeploymentPatternDataSummary> workloadDeploymentPatterns) {
            this.workloadDeploymentPatterns = WorkloadDeploymentPatternDataSummaryListCopier.copy(workloadDeploymentPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadDeploymentPatterns(WorkloadDeploymentPatternDataSummary ... workloadDeploymentPatterns) {
            this.workloadDeploymentPatterns(Arrays.asList(workloadDeploymentPatterns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workloadDeploymentPatterns(Consumer<WorkloadDeploymentPatternDataSummary.Builder> ... workloadDeploymentPatterns) {
            this.workloadDeploymentPatterns(Stream.of(workloadDeploymentPatterns).map(c -> (WorkloadDeploymentPatternDataSummary)((WorkloadDeploymentPatternDataSummary.Builder)WorkloadDeploymentPatternDataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkloadDeploymentPatternsResponse build() {
            return new ListWorkloadDeploymentPatternsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LaunchWizardResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkloadDeploymentPatternsResponse> {
        public Builder nextToken(String var1);

        public Builder workloadDeploymentPatterns(Collection<WorkloadDeploymentPatternDataSummary> var1);

        public Builder workloadDeploymentPatterns(WorkloadDeploymentPatternDataSummary ... var1);

        public Builder workloadDeploymentPatterns(Consumer<WorkloadDeploymentPatternDataSummary.Builder> ... var1);
    }
}

