/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.FunctionVersionsByCapacityProviderListCopier;
import software.amazon.awssdk.services.lambda.model.FunctionVersionsByCapacityProviderListItem;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFunctionVersionsByCapacityProviderResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, ListFunctionVersionsByCapacityProviderResponse> {
    private static final SdkField<String> CAPACITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityProviderArn").getter(ListFunctionVersionsByCapacityProviderResponse.getter(ListFunctionVersionsByCapacityProviderResponse::capacityProviderArn)).setter(ListFunctionVersionsByCapacityProviderResponse.setter(Builder::capacityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderArn").build()}).build();
    private static final SdkField<List<FunctionVersionsByCapacityProviderListItem>> FUNCTION_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FunctionVersions").getter(ListFunctionVersionsByCapacityProviderResponse.getter(ListFunctionVersionsByCapacityProviderResponse::functionVersions)).setter(ListFunctionVersionsByCapacityProviderResponse.setter(Builder::functionVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FunctionVersionsByCapacityProviderListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListFunctionVersionsByCapacityProviderResponse.getter(ListFunctionVersionsByCapacityProviderResponse::nextMarker)).setter(ListFunctionVersionsByCapacityProviderResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_PROVIDER_ARN_FIELD, FUNCTION_VERSIONS_FIELD, NEXT_MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFunctionVersionsByCapacityProviderResponse.memberNameToFieldInitializer();
    private final String capacityProviderArn;
    private final List<FunctionVersionsByCapacityProviderListItem> functionVersions;
    private final String nextMarker;

    private ListFunctionVersionsByCapacityProviderResponse(BuilderImpl builder) {
        super(builder);
        this.capacityProviderArn = builder.capacityProviderArn;
        this.functionVersions = builder.functionVersions;
        this.nextMarker = builder.nextMarker;
    }

    public final String capacityProviderArn() {
        return this.capacityProviderArn;
    }

    public final boolean hasFunctionVersions() {
        return this.functionVersions != null && !(this.functionVersions instanceof SdkAutoConstructList);
    }

    public final List<FunctionVersionsByCapacityProviderListItem> functionVersions() {
        return this.functionVersions;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFunctionVersions() ? this.functionVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFunctionVersionsByCapacityProviderResponse)) {
            return false;
        }
        ListFunctionVersionsByCapacityProviderResponse other = (ListFunctionVersionsByCapacityProviderResponse)((Object)obj);
        return Objects.equals(this.capacityProviderArn(), other.capacityProviderArn()) && this.hasFunctionVersions() == other.hasFunctionVersions() && Objects.equals(this.functionVersions(), other.functionVersions()) && Objects.equals(this.nextMarker(), other.nextMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListFunctionVersionsByCapacityProviderResponse").add("CapacityProviderArn", (Object)this.capacityProviderArn()).add("FunctionVersions", this.hasFunctionVersions() ? this.functionVersions() : null).add("NextMarker", (Object)this.nextMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.capacityProviderArn()));
            }
            case "FunctionVersions": {
                return Optional.ofNullable(clazz.cast(this.functionVersions()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityProviderArn", CAPACITY_PROVIDER_ARN_FIELD);
        map.put("FunctionVersions", FUNCTION_VERSIONS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFunctionVersionsByCapacityProviderResponse, T> g) {
        return obj -> g.apply((ListFunctionVersionsByCapacityProviderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String capacityProviderArn;
        private List<FunctionVersionsByCapacityProviderListItem> functionVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFunctionVersionsByCapacityProviderResponse model) {
            super(model);
            this.capacityProviderArn(model.capacityProviderArn);
            this.functionVersions(model.functionVersions);
            this.nextMarker(model.nextMarker);
        }

        public final String getCapacityProviderArn() {
            return this.capacityProviderArn;
        }

        public final void setCapacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
        }

        @Override
        public final Builder capacityProviderArn(String capacityProviderArn) {
            this.capacityProviderArn = capacityProviderArn;
            return this;
        }

        public final List<FunctionVersionsByCapacityProviderListItem.Builder> getFunctionVersions() {
            List<FunctionVersionsByCapacityProviderListItem.Builder> result = FunctionVersionsByCapacityProviderListCopier.copyToBuilder(this.functionVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFunctionVersions(Collection<FunctionVersionsByCapacityProviderListItem.BuilderImpl> functionVersions) {
            this.functionVersions = FunctionVersionsByCapacityProviderListCopier.copyFromBuilder(functionVersions);
        }

        @Override
        public final Builder functionVersions(Collection<FunctionVersionsByCapacityProviderListItem> functionVersions) {
            this.functionVersions = FunctionVersionsByCapacityProviderListCopier.copy(functionVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionVersions(FunctionVersionsByCapacityProviderListItem ... functionVersions) {
            this.functionVersions(Arrays.asList(functionVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder functionVersions(Consumer<FunctionVersionsByCapacityProviderListItem.Builder> ... functionVersions) {
            this.functionVersions(Stream.of(functionVersions).map(c -> (FunctionVersionsByCapacityProviderListItem)((FunctionVersionsByCapacityProviderListItem.Builder)FunctionVersionsByCapacityProviderListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        @Override
        public ListFunctionVersionsByCapacityProviderResponse build() {
            return new ListFunctionVersionsByCapacityProviderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFunctionVersionsByCapacityProviderResponse> {
        public Builder capacityProviderArn(String var1);

        public Builder functionVersions(Collection<FunctionVersionsByCapacityProviderListItem> var1);

        public Builder functionVersions(FunctionVersionsByCapacityProviderListItem ... var1);

        public Builder functionVersions(Consumer<FunctionVersionsByCapacityProviderListItem.Builder> ... var1);

        public Builder nextMarker(String var1);
    }
}

