/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.services.lambda.model.State;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutFunctionScalingConfigResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, PutFunctionScalingConfigResponse> {
    private static final SdkField<String> FUNCTION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionState").getter(PutFunctionScalingConfigResponse.getter(PutFunctionScalingConfigResponse::functionStateAsString)).setter(PutFunctionScalingConfigResponse.setter(Builder::functionState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutFunctionScalingConfigResponse.memberNameToFieldInitializer();
    private final String functionState;

    private PutFunctionScalingConfigResponse(BuilderImpl builder) {
        super(builder);
        this.functionState = builder.functionState;
    }

    public final State functionState() {
        return State.fromValue(this.functionState);
    }

    public final String functionStateAsString() {
        return this.functionState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutFunctionScalingConfigResponse)) {
            return false;
        }
        PutFunctionScalingConfigResponse other = (PutFunctionScalingConfigResponse)((Object)obj);
        return Objects.equals(this.functionStateAsString(), other.functionStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PutFunctionScalingConfigResponse").add("FunctionState", (Object)this.functionStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionState": {
                return Optional.ofNullable(clazz.cast(this.functionStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FunctionState", FUNCTION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutFunctionScalingConfigResponse, T> g) {
        return obj -> g.apply((PutFunctionScalingConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private String functionState;

        private BuilderImpl() {
        }

        private BuilderImpl(PutFunctionScalingConfigResponse model) {
            super(model);
            this.functionState(model.functionState);
        }

        public final String getFunctionState() {
            return this.functionState;
        }

        public final void setFunctionState(String functionState) {
            this.functionState = functionState;
        }

        @Override
        public final Builder functionState(String functionState) {
            this.functionState = functionState;
            return this;
        }

        @Override
        public final Builder functionState(State functionState) {
            this.functionState(functionState == null ? null : functionState.toString());
            return this;
        }

        @Override
        public PutFunctionScalingConfigResponse build() {
            return new PutFunctionScalingConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutFunctionScalingConfigResponse> {
        public Builder functionState(String var1);

        public Builder functionState(State var1);
    }
}

