/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.FunctionEventInvokeConfig;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsRequest;
import software.amazon.awssdk.services.lambda.model.ListFunctionEventInvokeConfigsResponse;

public class ListFunctionEventInvokeConfigsPublisher
implements SdkPublisher<ListFunctionEventInvokeConfigsResponse> {
    private final LambdaAsyncClient client;
    private final ListFunctionEventInvokeConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFunctionEventInvokeConfigsPublisher(LambdaAsyncClient client, ListFunctionEventInvokeConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFunctionEventInvokeConfigsPublisher(LambdaAsyncClient client, ListFunctionEventInvokeConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFunctionEventInvokeConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFunctionEventInvokeConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FunctionEventInvokeConfig> functionEventInvokeConfigs() {
        Function<ListFunctionEventInvokeConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.functionEventInvokeConfigs() != null) {
                return response.functionEventInvokeConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFunctionEventInvokeConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFunctionEventInvokeConfigsResponseFetcher
    implements AsyncPageFetcher<ListFunctionEventInvokeConfigsResponse> {
        private ListFunctionEventInvokeConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListFunctionEventInvokeConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListFunctionEventInvokeConfigsResponse> nextPage(ListFunctionEventInvokeConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListFunctionEventInvokeConfigsPublisher.this.client.listFunctionEventInvokeConfigs(ListFunctionEventInvokeConfigsPublisher.this.firstRequest);
            }
            return ListFunctionEventInvokeConfigsPublisher.this.client.listFunctionEventInvokeConfigs((ListFunctionEventInvokeConfigsRequest)((Object)ListFunctionEventInvokeConfigsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

