/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaRequest;
import software.amazon.awssdk.services.lambda.model.UpdateRuntimeOn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRuntimeManagementConfigRequest
extends LambdaRequest
implements ToCopyableBuilder<Builder, PutRuntimeManagementConfigRequest> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionName").getter(PutRuntimeManagementConfigRequest.getter(PutRuntimeManagementConfigRequest::functionName)).setter(PutRuntimeManagementConfigRequest.setter(Builder::functionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("FunctionName").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Qualifier").getter(PutRuntimeManagementConfigRequest.getter(PutRuntimeManagementConfigRequest::qualifier)).setter(PutRuntimeManagementConfigRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Qualifier").build()}).build();
    private static final SdkField<String> UPDATE_RUNTIME_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateRuntimeOn").getter(PutRuntimeManagementConfigRequest.getter(PutRuntimeManagementConfigRequest::updateRuntimeOnAsString)).setter(PutRuntimeManagementConfigRequest.setter(Builder::updateRuntimeOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateRuntimeOn").build()}).build();
    private static final SdkField<String> RUNTIME_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuntimeVersionArn").getter(PutRuntimeManagementConfigRequest.getter(PutRuntimeManagementConfigRequest::runtimeVersionArn)).setter(PutRuntimeManagementConfigRequest.setter(Builder::runtimeVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD, QUALIFIER_FIELD, UPDATE_RUNTIME_ON_FIELD, RUNTIME_VERSION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRuntimeManagementConfigRequest.memberNameToFieldInitializer();
    private final String functionName;
    private final String qualifier;
    private final String updateRuntimeOn;
    private final String runtimeVersionArn;

    private PutRuntimeManagementConfigRequest(BuilderImpl builder) {
        super(builder);
        this.functionName = builder.functionName;
        this.qualifier = builder.qualifier;
        this.updateRuntimeOn = builder.updateRuntimeOn;
        this.runtimeVersionArn = builder.runtimeVersionArn;
    }

    public final String functionName() {
        return this.functionName;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final UpdateRuntimeOn updateRuntimeOn() {
        return UpdateRuntimeOn.fromValue(this.updateRuntimeOn);
    }

    public final String updateRuntimeOnAsString() {
        return this.updateRuntimeOn;
    }

    public final String runtimeVersionArn() {
        return this.runtimeVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.functionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateRuntimeOnAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeVersionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRuntimeManagementConfigRequest)) {
            return false;
        }
        PutRuntimeManagementConfigRequest other = (PutRuntimeManagementConfigRequest)((Object)obj);
        return Objects.equals(this.functionName(), other.functionName()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.updateRuntimeOnAsString(), other.updateRuntimeOnAsString()) && Objects.equals(this.runtimeVersionArn(), other.runtimeVersionArn());
    }

    public final String toString() {
        return ToString.builder((String)"PutRuntimeManagementConfigRequest").add("FunctionName", (Object)this.functionName()).add("Qualifier", (Object)this.qualifier()).add("UpdateRuntimeOn", (Object)this.updateRuntimeOnAsString()).add("RuntimeVersionArn", (Object)this.runtimeVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FunctionName": {
                return Optional.ofNullable(clazz.cast(this.functionName()));
            }
            case "Qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "UpdateRuntimeOn": {
                return Optional.ofNullable(clazz.cast(this.updateRuntimeOnAsString()));
            }
            case "RuntimeVersionArn": {
                return Optional.ofNullable(clazz.cast(this.runtimeVersionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FunctionName", FUNCTION_NAME_FIELD);
        map.put("Qualifier", QUALIFIER_FIELD);
        map.put("UpdateRuntimeOn", UPDATE_RUNTIME_ON_FIELD);
        map.put("RuntimeVersionArn", RUNTIME_VERSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRuntimeManagementConfigRequest, T> g) {
        return obj -> g.apply((PutRuntimeManagementConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaRequest.BuilderImpl
    implements Builder {
        private String functionName;
        private String qualifier;
        private String updateRuntimeOn;
        private String runtimeVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRuntimeManagementConfigRequest model) {
            super(model);
            this.functionName(model.functionName);
            this.qualifier(model.qualifier);
            this.updateRuntimeOn(model.updateRuntimeOn);
            this.runtimeVersionArn(model.runtimeVersionArn);
        }

        public final String getFunctionName() {
            return this.functionName;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final String getUpdateRuntimeOn() {
            return this.updateRuntimeOn;
        }

        public final void setUpdateRuntimeOn(String updateRuntimeOn) {
            this.updateRuntimeOn = updateRuntimeOn;
        }

        @Override
        public final Builder updateRuntimeOn(String updateRuntimeOn) {
            this.updateRuntimeOn = updateRuntimeOn;
            return this;
        }

        @Override
        public final Builder updateRuntimeOn(UpdateRuntimeOn updateRuntimeOn) {
            this.updateRuntimeOn(updateRuntimeOn == null ? null : updateRuntimeOn.toString());
            return this;
        }

        public final String getRuntimeVersionArn() {
            return this.runtimeVersionArn;
        }

        public final void setRuntimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
        }

        @Override
        public final Builder runtimeVersionArn(String runtimeVersionArn) {
            this.runtimeVersionArn = runtimeVersionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRuntimeManagementConfigRequest build() {
            return new PutRuntimeManagementConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LambdaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRuntimeManagementConfigRequest> {
        public Builder functionName(String var1);

        public Builder qualifier(String var1);

        public Builder updateRuntimeOn(String var1);

        public Builder updateRuntimeOn(UpdateRuntimeOn var1);

        public Builder runtimeVersionArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

