/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.AllowedPublishers;
import software.amazon.awssdk.services.lambda.model.CodeSigningPolicies;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeSigningConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeSigningConfig> {
    private static final SdkField<String> CODE_SIGNING_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSigningConfigId").getter(CodeSigningConfig.getter(CodeSigningConfig::codeSigningConfigId)).setter(CodeSigningConfig.setter(Builder::codeSigningConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigId").build()}).build();
    private static final SdkField<String> CODE_SIGNING_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeSigningConfigArn").getter(CodeSigningConfig.getter(CodeSigningConfig::codeSigningConfigArn)).setter(CodeSigningConfig.setter(Builder::codeSigningConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningConfigArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CodeSigningConfig.getter(CodeSigningConfig::description)).setter(CodeSigningConfig.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<AllowedPublishers> ALLOWED_PUBLISHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AllowedPublishers").getter(CodeSigningConfig.getter(CodeSigningConfig::allowedPublishers)).setter(CodeSigningConfig.setter(Builder::allowedPublishers)).constructor(AllowedPublishers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedPublishers").build()}).build();
    private static final SdkField<CodeSigningPolicies> CODE_SIGNING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CodeSigningPolicies").getter(CodeSigningConfig.getter(CodeSigningConfig::codeSigningPolicies)).setter(CodeSigningConfig.setter(Builder::codeSigningPolicies)).constructor(CodeSigningPolicies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeSigningPolicies").build()}).build();
    private static final SdkField<String> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastModified").getter(CodeSigningConfig.getter(CodeSigningConfig::lastModified)).setter(CodeSigningConfig.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_SIGNING_CONFIG_ID_FIELD, CODE_SIGNING_CONFIG_ARN_FIELD, DESCRIPTION_FIELD, ALLOWED_PUBLISHERS_FIELD, CODE_SIGNING_POLICIES_FIELD, LAST_MODIFIED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CodeSigningConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String codeSigningConfigId;
    private final String codeSigningConfigArn;
    private final String description;
    private final AllowedPublishers allowedPublishers;
    private final CodeSigningPolicies codeSigningPolicies;
    private final String lastModified;

    private CodeSigningConfig(BuilderImpl builder) {
        this.codeSigningConfigId = builder.codeSigningConfigId;
        this.codeSigningConfigArn = builder.codeSigningConfigArn;
        this.description = builder.description;
        this.allowedPublishers = builder.allowedPublishers;
        this.codeSigningPolicies = builder.codeSigningPolicies;
        this.lastModified = builder.lastModified;
    }

    public final String codeSigningConfigId() {
        return this.codeSigningConfigId;
    }

    public final String codeSigningConfigArn() {
        return this.codeSigningConfigArn;
    }

    public final String description() {
        return this.description;
    }

    public final AllowedPublishers allowedPublishers() {
        return this.allowedPublishers;
    }

    public final CodeSigningPolicies codeSigningPolicies() {
        return this.codeSigningPolicies;
    }

    public final String lastModified() {
        return this.lastModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedPublishers());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigningPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeSigningConfig)) {
            return false;
        }
        CodeSigningConfig other = (CodeSigningConfig)obj;
        return Objects.equals(this.codeSigningConfigId(), other.codeSigningConfigId()) && Objects.equals(this.codeSigningConfigArn(), other.codeSigningConfigArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.allowedPublishers(), other.allowedPublishers()) && Objects.equals(this.codeSigningPolicies(), other.codeSigningPolicies()) && Objects.equals(this.lastModified(), other.lastModified());
    }

    public final String toString() {
        return ToString.builder((String)"CodeSigningConfig").add("CodeSigningConfigId", (Object)this.codeSigningConfigId()).add("CodeSigningConfigArn", (Object)this.codeSigningConfigArn()).add("Description", (Object)this.description()).add("AllowedPublishers", (Object)this.allowedPublishers()).add("CodeSigningPolicies", (Object)this.codeSigningPolicies()).add("LastModified", (Object)this.lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CodeSigningConfigId": {
                return Optional.ofNullable(clazz.cast(this.codeSigningConfigId()));
            }
            case "CodeSigningConfigArn": {
                return Optional.ofNullable(clazz.cast(this.codeSigningConfigArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "AllowedPublishers": {
                return Optional.ofNullable(clazz.cast(this.allowedPublishers()));
            }
            case "CodeSigningPolicies": {
                return Optional.ofNullable(clazz.cast(this.codeSigningPolicies()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CodeSigningConfigId", CODE_SIGNING_CONFIG_ID_FIELD);
        map.put("CodeSigningConfigArn", CODE_SIGNING_CONFIG_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("AllowedPublishers", ALLOWED_PUBLISHERS_FIELD);
        map.put("CodeSigningPolicies", CODE_SIGNING_POLICIES_FIELD);
        map.put("LastModified", LAST_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CodeSigningConfig, T> g) {
        return obj -> g.apply((CodeSigningConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codeSigningConfigId;
        private String codeSigningConfigArn;
        private String description;
        private AllowedPublishers allowedPublishers;
        private CodeSigningPolicies codeSigningPolicies;
        private String lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeSigningConfig model) {
            this.codeSigningConfigId(model.codeSigningConfigId);
            this.codeSigningConfigArn(model.codeSigningConfigArn);
            this.description(model.description);
            this.allowedPublishers(model.allowedPublishers);
            this.codeSigningPolicies(model.codeSigningPolicies);
            this.lastModified(model.lastModified);
        }

        public final String getCodeSigningConfigId() {
            return this.codeSigningConfigId;
        }

        public final void setCodeSigningConfigId(String codeSigningConfigId) {
            this.codeSigningConfigId = codeSigningConfigId;
        }

        @Override
        public final Builder codeSigningConfigId(String codeSigningConfigId) {
            this.codeSigningConfigId = codeSigningConfigId;
            return this;
        }

        public final String getCodeSigningConfigArn() {
            return this.codeSigningConfigArn;
        }

        public final void setCodeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
        }

        @Override
        public final Builder codeSigningConfigArn(String codeSigningConfigArn) {
            this.codeSigningConfigArn = codeSigningConfigArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final AllowedPublishers.Builder getAllowedPublishers() {
            return this.allowedPublishers != null ? this.allowedPublishers.toBuilder() : null;
        }

        public final void setAllowedPublishers(AllowedPublishers.BuilderImpl allowedPublishers) {
            this.allowedPublishers = allowedPublishers != null ? allowedPublishers.build() : null;
        }

        @Override
        public final Builder allowedPublishers(AllowedPublishers allowedPublishers) {
            this.allowedPublishers = allowedPublishers;
            return this;
        }

        public final CodeSigningPolicies.Builder getCodeSigningPolicies() {
            return this.codeSigningPolicies != null ? this.codeSigningPolicies.toBuilder() : null;
        }

        public final void setCodeSigningPolicies(CodeSigningPolicies.BuilderImpl codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies != null ? codeSigningPolicies.build() : null;
        }

        @Override
        public final Builder codeSigningPolicies(CodeSigningPolicies codeSigningPolicies) {
            this.codeSigningPolicies = codeSigningPolicies;
            return this;
        }

        public final String getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(String lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public CodeSigningConfig build() {
            return new CodeSigningConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeSigningConfig> {
        public Builder codeSigningConfigId(String var1);

        public Builder codeSigningConfigArn(String var1);

        public Builder description(String var1);

        public Builder allowedPublishers(AllowedPublishers var1);

        default public Builder allowedPublishers(Consumer<AllowedPublishers.Builder> allowedPublishers) {
            return this.allowedPublishers((AllowedPublishers)((AllowedPublishers.Builder)AllowedPublishers.builder().applyMutation(allowedPublishers)).build());
        }

        public Builder codeSigningPolicies(CodeSigningPolicies var1);

        default public Builder codeSigningPolicies(Consumer<CodeSigningPolicies.Builder> codeSigningPolicies) {
            return this.codeSigningPolicies((CodeSigningPolicies)((CodeSigningPolicies.Builder)CodeSigningPolicies.builder().applyMutation(codeSigningPolicies)).build());
        }

        public Builder lastModified(String var1);
    }
}

