/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingMetric;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingMetricListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventSourceMappingMetricsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventSourceMappingMetricsConfig> {
    private static final SdkField<List<String>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(EventSourceMappingMetricsConfig.getter(EventSourceMappingMetricsConfig::metricsAsStrings)).setter(EventSourceMappingMetricsConfig.setter(Builder::metricsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Metrics", METRICS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> metrics;

    private EventSourceMappingMetricsConfig(BuilderImpl builder) {
        this.metrics = builder.metrics;
    }

    public final List<EventSourceMappingMetric> metrics() {
        return EventSourceMappingMetricListCopier.copyStringToEnum(this.metrics);
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<String> metricsAsStrings() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metricsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSourceMappingMetricsConfig)) {
            return false;
        }
        EventSourceMappingMetricsConfig other = (EventSourceMappingMetricsConfig)obj;
        return this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metricsAsStrings(), other.metricsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EventSourceMappingMetricsConfig").add("Metrics", this.hasMetrics() ? this.metricsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metricsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EventSourceMappingMetricsConfig, T> g) {
        return obj -> g.apply((EventSourceMappingMetricsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventSourceMappingMetricsConfig model) {
            this.metricsWithStrings(model.metrics);
        }

        public final Collection<String> getMetrics() {
            if (this.metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = EventSourceMappingMetricListCopier.copy(metrics);
        }

        @Override
        public final Builder metricsWithStrings(Collection<String> metrics) {
            this.metrics = EventSourceMappingMetricListCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsWithStrings(String ... metrics) {
            this.metricsWithStrings(Arrays.asList(metrics));
            return this;
        }

        @Override
        public final Builder metrics(Collection<EventSourceMappingMetric> metrics) {
            this.metrics = EventSourceMappingMetricListCopier.copyEnumToString(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(EventSourceMappingMetric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        public EventSourceMappingMetricsConfig build() {
            return new EventSourceMappingMetricsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventSourceMappingMetricsConfig> {
        public Builder metricsWithStrings(Collection<String> var1);

        public Builder metricsWithStrings(String ... var1);

        public Builder metrics(Collection<EventSourceMappingMetric> var1);

        public Builder metrics(EventSourceMappingMetric ... var1);
    }
}

