/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lambda.LambdaClient;
import software.amazon.awssdk.services.lambda.internal.UserAgentUtils;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsRequest;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;

public class ListEventSourceMappingsIterable
implements SdkIterable<ListEventSourceMappingsResponse> {
    private final LambdaClient client;
    private final ListEventSourceMappingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventSourceMappingsIterable(LambdaClient client, ListEventSourceMappingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventSourceMappingsResponseFetcher();
    }

    public Iterator<ListEventSourceMappingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventSourceMappingConfiguration> eventSourceMappings() {
        Function<ListEventSourceMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventSourceMappings() != null) {
                return response.eventSourceMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventSourceMappingsResponseFetcher
    implements SyncPageFetcher<ListEventSourceMappingsResponse> {
        private ListEventSourceMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventSourceMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListEventSourceMappingsResponse nextPage(ListEventSourceMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListEventSourceMappingsIterable.this.client.listEventSourceMappings(ListEventSourceMappingsIterable.this.firstRequest);
            }
            return ListEventSourceMappingsIterable.this.client.listEventSourceMappings((ListEventSourceMappingsRequest)((Object)ListEventSourceMappingsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

