/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lambda.model.LambdaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeResponse
extends LambdaResponse
implements ToCopyableBuilder<Builder, InvokeResponse> {
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusCode").getter(InvokeResponse.getter(InvokeResponse::statusCode)).setter(InvokeResponse.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()}).build();
    private static final SdkField<String> FUNCTION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FunctionError").getter(InvokeResponse.getter(InvokeResponse::functionError)).setter(InvokeResponse.setter(Builder::functionError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Function-Error").build()}).build();
    private static final SdkField<String> LOG_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogResult").getter(InvokeResponse.getter(InvokeResponse::logResult)).setter(InvokeResponse.setter(Builder::logResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Log-Result").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Payload").getter(InvokeResponse.getter(InvokeResponse::payload)).setter(InvokeResponse.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build(), PayloadTrait.create()}).build();
    private static final SdkField<String> EXECUTED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutedVersion").getter(InvokeResponse.getter(InvokeResponse::executedVersion)).setter(InvokeResponse.setter(Builder::executedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Executed-Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD, FUNCTION_ERROR_FIELD, LOG_RESULT_FIELD, PAYLOAD_FIELD, EXECUTED_VERSION_FIELD));
    private final Integer statusCode;
    private final String functionError;
    private final String logResult;
    private final SdkBytes payload;
    private final String executedVersion;

    private InvokeResponse(BuilderImpl builder) {
        super(builder);
        this.statusCode = builder.statusCode;
        this.functionError = builder.functionError;
        this.logResult = builder.logResult;
        this.payload = builder.payload;
        this.executedVersion = builder.executedVersion;
    }

    public final Integer statusCode() {
        return this.statusCode;
    }

    public final String functionError() {
        return this.functionError;
    }

    public final String logResult() {
        return this.logResult;
    }

    public final SdkBytes payload() {
        return this.payload;
    }

    public final String executedVersion() {
        return this.executedVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.functionError());
        hashCode = 31 * hashCode + Objects.hashCode(this.logResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.executedVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeResponse)) {
            return false;
        }
        InvokeResponse other = (InvokeResponse)((Object)obj);
        return Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.functionError(), other.functionError()) && Objects.equals(this.logResult(), other.logResult()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.executedVersion(), other.executedVersion());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeResponse").add("StatusCode", (Object)this.statusCode()).add("FunctionError", (Object)this.functionError()).add("LogResult", (Object)this.logResult()).add("Payload", (Object)(this.payload() == null ? null : "*** Sensitive Data Redacted ***")).add("ExecutedVersion", (Object)this.executedVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "FunctionError": {
                return Optional.ofNullable(clazz.cast(this.functionError()));
            }
            case "LogResult": {
                return Optional.ofNullable(clazz.cast(this.logResult()));
            }
            case "Payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "ExecutedVersion": {
                return Optional.ofNullable(clazz.cast(this.executedVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeResponse, T> g) {
        return obj -> g.apply((InvokeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LambdaResponse.BuilderImpl
    implements Builder {
        private Integer statusCode;
        private String functionError;
        private String logResult;
        private SdkBytes payload;
        private String executedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeResponse model) {
            super(model);
            this.statusCode(model.statusCode);
            this.functionError(model.functionError);
            this.logResult(model.logResult);
            this.payload(model.payload);
            this.executedVersion(model.executedVersion);
        }

        public final Integer getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        @Transient
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getFunctionError() {
            return this.functionError;
        }

        public final void setFunctionError(String functionError) {
            this.functionError = functionError;
        }

        @Override
        @Transient
        public final Builder functionError(String functionError) {
            this.functionError = functionError;
            return this;
        }

        public final String getLogResult() {
            return this.logResult;
        }

        public final void setLogResult(String logResult) {
            this.logResult = logResult;
        }

        @Override
        @Transient
        public final Builder logResult(String logResult) {
            this.logResult = logResult;
            return this;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        @Transient
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final String getExecutedVersion() {
            return this.executedVersion;
        }

        public final void setExecutedVersion(String executedVersion) {
            this.executedVersion = executedVersion;
        }

        @Override
        @Transient
        public final Builder executedVersion(String executedVersion) {
            this.executedVersion = executedVersion;
            return this;
        }

        @Override
        public InvokeResponse build() {
            return new InvokeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LambdaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeResponse> {
        public Builder statusCode(Integer var1);

        public Builder functionError(String var1);

        public Builder logResult(String var1);

        public Builder payload(SdkBytes var1);

        public Builder executedVersion(String var1);
    }
}

