/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lambda.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lambda.model.EnvironmentError;
import software.amazon.awssdk.services.lambda.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentResponse> {
    private static final SdkField<Map<String, String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Variables").getter(EnvironmentResponse.getter(EnvironmentResponse::variables)).setter(EnvironmentResponse.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Variables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<EnvironmentError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(EnvironmentResponse.getter(EnvironmentResponse::error)).setter(EnvironmentResponse.setter(Builder::error)).constructor(EnvironmentError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLES_FIELD, ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> variables;
    private final EnvironmentError error;

    private EnvironmentResponse(BuilderImpl builder) {
        this.variables = builder.variables;
        this.error = builder.error;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> variables() {
        return this.variables;
    }

    public final EnvironmentError error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentResponse)) {
            return false;
        }
        EnvironmentResponse other = (EnvironmentResponse)obj;
        return this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.error(), other.error());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentResponse").add("Variables", (Object)(this.variables() == null ? null : "*** Sensitive Data Redacted ***")).add("Error", (Object)this.error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentResponse, T> g) {
        return obj -> g.apply((EnvironmentResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> variables = DefaultSdkAutoConstructMap.getInstance();
        private EnvironmentError error;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentResponse model) {
            this.variables(model.variables);
            this.error(model.error);
        }

        public final Map<String, String> getVariables() {
            if (this.variables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
        }

        @Override
        @Transient
        public final Builder variables(Map<String, String> variables) {
            this.variables = EnvironmentVariablesCopier.copy(variables);
            return this;
        }

        public final EnvironmentError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(EnvironmentError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        @Transient
        public final Builder error(EnvironmentError error) {
            this.error = error;
            return this;
        }

        public EnvironmentResponse build() {
            return new EnvironmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentResponse> {
        public Builder variables(Map<String, String> var1);

        public Builder error(EnvironmentError var1);

        default public Builder error(Consumer<EnvironmentError.Builder> error) {
            return this.error((EnvironmentError)((EnvironmentError.Builder)EnvironmentError.builder().applyMutation(error)).build());
        }
    }
}

