/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lambda.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the connection between a Lambda function and an Amazon EFS file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileSystemConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<FileSystemConfig.Builder, FileSystemConfig> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(FileSystemConfig::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> LOCAL_MOUNT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalMountPath").getter(getter(FileSystemConfig::localMountPath))
            .setter(setter(Builder::localMountPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalMountPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            LOCAL_MOUNT_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String localMountPath;

    private FileSystemConfig(BuilderImpl builder) {
        this.arn = builder.arn;
        this.localMountPath = builder.localMountPath;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The path where the function can access the file system, starting with <code>/mnt/</code>.
     * </p>
     * 
     * @return The path where the function can access the file system, starting with <code>/mnt/</code>.
     */
    public final String localMountPath() {
        return localMountPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(localMountPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSystemConfig)) {
            return false;
        }
        FileSystemConfig other = (FileSystemConfig) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(localMountPath(), other.localMountPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileSystemConfig").add("Arn", arn()).add("LocalMountPath", localMountPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "LocalMountPath":
            return Optional.ofNullable(clazz.cast(localMountPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileSystemConfig, T> g) {
        return obj -> g.apply((FileSystemConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileSystemConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Amazon EFS access point that provides access to the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The path where the function can access the file system, starting with <code>/mnt/</code>.
         * </p>
         * 
         * @param localMountPath
         *        The path where the function can access the file system, starting with <code>/mnt/</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localMountPath(String localMountPath);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String localMountPath;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSystemConfig model) {
            arn(model.arn);
            localMountPath(model.localMountPath);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getLocalMountPath() {
            return localMountPath;
        }

        @Override
        public final Builder localMountPath(String localMountPath) {
            this.localMountPath = localMountPath;
            return this;
        }

        public final void setLocalMountPath(String localMountPath) {
            this.localMountPath = localMountPath;
        }

        @Override
        public FileSystemConfig build() {
            return new FileSystemConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
