/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lakeformation.model.ExecutionStatistics;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.PlanningStatistics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryStatisticsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, GetQueryStatisticsResponse> {
    private static final SdkField<ExecutionStatistics> EXECUTION_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExecutionStatistics").getter(GetQueryStatisticsResponse.getter(GetQueryStatisticsResponse::executionStatistics)).setter(GetQueryStatisticsResponse.setter(Builder::executionStatistics)).constructor(ExecutionStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStatistics").build()}).build();
    private static final SdkField<PlanningStatistics> PLANNING_STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlanningStatistics").getter(GetQueryStatisticsResponse.getter(GetQueryStatisticsResponse::planningStatistics)).setter(GetQueryStatisticsResponse.setter(Builder::planningStatistics)).constructor(PlanningStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlanningStatistics").build()}).build();
    private static final SdkField<Instant> QUERY_SUBMISSION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("QuerySubmissionTime").getter(GetQueryStatisticsResponse.getter(GetQueryStatisticsResponse::querySubmissionTime)).setter(GetQueryStatisticsResponse.setter(Builder::querySubmissionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySubmissionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_STATISTICS_FIELD, PLANNING_STATISTICS_FIELD, QUERY_SUBMISSION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQueryStatisticsResponse.memberNameToFieldInitializer();
    private final ExecutionStatistics executionStatistics;
    private final PlanningStatistics planningStatistics;
    private final Instant querySubmissionTime;

    private GetQueryStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.executionStatistics = builder.executionStatistics;
        this.planningStatistics = builder.planningStatistics;
        this.querySubmissionTime = builder.querySubmissionTime;
    }

    public final ExecutionStatistics executionStatistics() {
        return this.executionStatistics;
    }

    public final PlanningStatistics planningStatistics() {
        return this.planningStatistics;
    }

    public final Instant querySubmissionTime() {
        return this.querySubmissionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.planningStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.querySubmissionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryStatisticsResponse)) {
            return false;
        }
        GetQueryStatisticsResponse other = (GetQueryStatisticsResponse)((Object)obj);
        return Objects.equals(this.executionStatistics(), other.executionStatistics()) && Objects.equals(this.planningStatistics(), other.planningStatistics()) && Objects.equals(this.querySubmissionTime(), other.querySubmissionTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryStatisticsResponse").add("ExecutionStatistics", (Object)this.executionStatistics()).add("PlanningStatistics", (Object)this.planningStatistics()).add("QuerySubmissionTime", (Object)this.querySubmissionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionStatistics": {
                return Optional.ofNullable(clazz.cast(this.executionStatistics()));
            }
            case "PlanningStatistics": {
                return Optional.ofNullable(clazz.cast(this.planningStatistics()));
            }
            case "QuerySubmissionTime": {
                return Optional.ofNullable(clazz.cast(this.querySubmissionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionStatistics", EXECUTION_STATISTICS_FIELD);
        map.put("PlanningStatistics", PLANNING_STATISTICS_FIELD);
        map.put("QuerySubmissionTime", QUERY_SUBMISSION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQueryStatisticsResponse, T> g) {
        return obj -> g.apply((GetQueryStatisticsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private ExecutionStatistics executionStatistics;
        private PlanningStatistics planningStatistics;
        private Instant querySubmissionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryStatisticsResponse model) {
            super(model);
            this.executionStatistics(model.executionStatistics);
            this.planningStatistics(model.planningStatistics);
            this.querySubmissionTime(model.querySubmissionTime);
        }

        public final ExecutionStatistics.Builder getExecutionStatistics() {
            return this.executionStatistics != null ? this.executionStatistics.toBuilder() : null;
        }

        public final void setExecutionStatistics(ExecutionStatistics.BuilderImpl executionStatistics) {
            this.executionStatistics = executionStatistics != null ? executionStatistics.build() : null;
        }

        @Override
        public final Builder executionStatistics(ExecutionStatistics executionStatistics) {
            this.executionStatistics = executionStatistics;
            return this;
        }

        public final PlanningStatistics.Builder getPlanningStatistics() {
            return this.planningStatistics != null ? this.planningStatistics.toBuilder() : null;
        }

        public final void setPlanningStatistics(PlanningStatistics.BuilderImpl planningStatistics) {
            this.planningStatistics = planningStatistics != null ? planningStatistics.build() : null;
        }

        @Override
        public final Builder planningStatistics(PlanningStatistics planningStatistics) {
            this.planningStatistics = planningStatistics;
            return this;
        }

        public final Instant getQuerySubmissionTime() {
            return this.querySubmissionTime;
        }

        public final void setQuerySubmissionTime(Instant querySubmissionTime) {
            this.querySubmissionTime = querySubmissionTime;
        }

        @Override
        public final Builder querySubmissionTime(Instant querySubmissionTime) {
            this.querySubmissionTime = querySubmissionTime;
            return this;
        }

        @Override
        public GetQueryStatisticsResponse build() {
            return new GetQueryStatisticsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryStatisticsResponse> {
        public Builder executionStatistics(ExecutionStatistics var1);

        default public Builder executionStatistics(Consumer<ExecutionStatistics.Builder> executionStatistics) {
            return this.executionStatistics((ExecutionStatistics)((ExecutionStatistics.Builder)ExecutionStatistics.builder().applyMutation(executionStatistics)).build());
        }

        public Builder planningStatistics(PlanningStatistics var1);

        default public Builder planningStatistics(Consumer<PlanningStatistics.Builder> planningStatistics) {
            return this.planningStatistics((PlanningStatistics)((PlanningStatistics.Builder)PlanningStatistics.builder().applyMutation(planningStatistics)).build());
        }

        public Builder querySubmissionTime(Instant var1);
    }
}

