/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.ColumnNamesCopier;
import software.amazon.awssdk.services.lakeformation.model.ColumnWildcard;
import software.amazon.awssdk.services.lakeformation.model.RowFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataCellsFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataCellsFilter> {
    private static final SdkField<String> TABLE_CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableCatalogId").getter(DataCellsFilter.getter(DataCellsFilter::tableCatalogId)).setter(DataCellsFilter.setter(Builder::tableCatalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(DataCellsFilter.getter(DataCellsFilter::databaseName)).setter(DataCellsFilter.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(DataCellsFilter.getter(DataCellsFilter::tableName)).setter(DataCellsFilter.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataCellsFilter.getter(DataCellsFilter::name)).setter(DataCellsFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<RowFilter> ROW_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowFilter").getter(DataCellsFilter.getter(DataCellsFilter::rowFilter)).setter(DataCellsFilter.setter(Builder::rowFilter)).constructor(RowFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowFilter").build()}).build();
    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnNames").getter(DataCellsFilter.getter(DataCellsFilter::columnNames)).setter(DataCellsFilter.setter(Builder::columnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ColumnWildcard> COLUMN_WILDCARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColumnWildcard").getter(DataCellsFilter.getter(DataCellsFilter::columnWildcard)).setter(DataCellsFilter.setter(Builder::columnWildcard)).constructor(ColumnWildcard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnWildcard").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(DataCellsFilter.getter(DataCellsFilter::versionId)).setter(DataCellsFilter.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, NAME_FIELD, ROW_FILTER_FIELD, COLUMN_NAMES_FIELD, COLUMN_WILDCARD_FIELD, VERSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataCellsFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tableCatalogId;
    private final String databaseName;
    private final String tableName;
    private final String name;
    private final RowFilter rowFilter;
    private final List<String> columnNames;
    private final ColumnWildcard columnWildcard;
    private final String versionId;

    private DataCellsFilter(BuilderImpl builder) {
        this.tableCatalogId = builder.tableCatalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.name = builder.name;
        this.rowFilter = builder.rowFilter;
        this.columnNames = builder.columnNames;
        this.columnWildcard = builder.columnWildcard;
        this.versionId = builder.versionId;
    }

    public final String tableCatalogId() {
        return this.tableCatalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String name() {
        return this.name;
    }

    public final RowFilter rowFilter() {
        return this.rowFilter;
    }

    public final boolean hasColumnNames() {
        return this.columnNames != null && !(this.columnNames instanceof SdkAutoConstructList);
    }

    public final List<String> columnNames() {
        return this.columnNames;
    }

    public final ColumnWildcard columnWildcard() {
        return this.columnWildcard;
    }

    public final String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableCatalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnNames() ? this.columnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.columnWildcard());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCellsFilter)) {
            return false;
        }
        DataCellsFilter other = (DataCellsFilter)obj;
        return Objects.equals(this.tableCatalogId(), other.tableCatalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.rowFilter(), other.rowFilter()) && this.hasColumnNames() == other.hasColumnNames() && Objects.equals(this.columnNames(), other.columnNames()) && Objects.equals(this.columnWildcard(), other.columnWildcard()) && Objects.equals(this.versionId(), other.versionId());
    }

    public final String toString() {
        return ToString.builder((String)"DataCellsFilter").add("TableCatalogId", (Object)this.tableCatalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("Name", (Object)this.name()).add("RowFilter", (Object)this.rowFilter()).add("ColumnNames", this.hasColumnNames() ? this.columnNames() : null).add("ColumnWildcard", (Object)this.columnWildcard()).add("VersionId", (Object)this.versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableCatalogId": {
                return Optional.ofNullable(clazz.cast(this.tableCatalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "RowFilter": {
                return Optional.ofNullable(clazz.cast(this.rowFilter()));
            }
            case "ColumnNames": {
                return Optional.ofNullable(clazz.cast(this.columnNames()));
            }
            case "ColumnWildcard": {
                return Optional.ofNullable(clazz.cast(this.columnWildcard()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TableCatalogId", TABLE_CATALOG_ID_FIELD);
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("RowFilter", ROW_FILTER_FIELD);
        map.put("ColumnNames", COLUMN_NAMES_FIELD);
        map.put("ColumnWildcard", COLUMN_WILDCARD_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataCellsFilter, T> g) {
        return obj -> g.apply((DataCellsFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableCatalogId;
        private String databaseName;
        private String tableName;
        private String name;
        private RowFilter rowFilter;
        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();
        private ColumnWildcard columnWildcard;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCellsFilter model) {
            this.tableCatalogId(model.tableCatalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.name(model.name);
            this.rowFilter(model.rowFilter);
            this.columnNames(model.columnNames);
            this.columnWildcard(model.columnWildcard);
            this.versionId(model.versionId);
        }

        public final String getTableCatalogId() {
            return this.tableCatalogId;
        }

        public final void setTableCatalogId(String tableCatalogId) {
            this.tableCatalogId = tableCatalogId;
        }

        @Override
        public final Builder tableCatalogId(String tableCatalogId) {
            this.tableCatalogId = tableCatalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RowFilter.Builder getRowFilter() {
            return this.rowFilter != null ? this.rowFilter.toBuilder() : null;
        }

        public final void setRowFilter(RowFilter.BuilderImpl rowFilter) {
            this.rowFilter = rowFilter != null ? rowFilter.build() : null;
        }

        @Override
        public final Builder rowFilter(RowFilter rowFilter) {
            this.rowFilter = rowFilter;
            return this;
        }

        public final Collection<String> getColumnNames() {
            if (this.columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnNames;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
        }

        @Override
        public final Builder columnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNames(String ... columnNames) {
            this.columnNames(Arrays.asList(columnNames));
            return this;
        }

        public final ColumnWildcard.Builder getColumnWildcard() {
            return this.columnWildcard != null ? this.columnWildcard.toBuilder() : null;
        }

        public final void setColumnWildcard(ColumnWildcard.BuilderImpl columnWildcard) {
            this.columnWildcard = columnWildcard != null ? columnWildcard.build() : null;
        }

        @Override
        public final Builder columnWildcard(ColumnWildcard columnWildcard) {
            this.columnWildcard = columnWildcard;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public DataCellsFilter build() {
            return new DataCellsFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataCellsFilter> {
        public Builder tableCatalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder name(String var1);

        public Builder rowFilter(RowFilter var1);

        default public Builder rowFilter(Consumer<RowFilter.Builder> rowFilter) {
            return this.rowFilter((RowFilter)((RowFilter.Builder)RowFilter.builder().applyMutation(rowFilter)).build());
        }

        public Builder columnNames(Collection<String> var1);

        public Builder columnNames(String ... var1);

        public Builder columnWildcard(ColumnWildcard var1);

        default public Builder columnWildcard(Consumer<ColumnWildcard.Builder> columnWildcard) {
            return this.columnWildcard((ColumnWildcard)((ColumnWildcard.Builder)ColumnWildcard.builder().applyMutation(columnWildcard)).build());
        }

        public Builder versionId(String var1);
    }
}

