/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.LakeFormationResponse;
import software.amazon.awssdk.services.lakeformation.model.TableLFTagsListCopier;
import software.amazon.awssdk.services.lakeformation.model.TaggedTable;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTablesByLfTagsResponse
extends LakeFormationResponse
implements ToCopyableBuilder<Builder, SearchTablesByLfTagsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchTablesByLfTagsResponse.getter(SearchTablesByLfTagsResponse::nextToken)).setter(SearchTablesByLfTagsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TaggedTable>> TABLE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableList").getter(SearchTablesByLfTagsResponse.getter(SearchTablesByLfTagsResponse::tableList)).setter(SearchTablesByLfTagsResponse.setter(Builder::tableList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaggedTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TABLE_LIST_FIELD));
    private final String nextToken;
    private final List<TaggedTable> tableList;

    private SearchTablesByLfTagsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.tableList = builder.tableList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTableList() {
        return this.tableList != null && !(this.tableList instanceof SdkAutoConstructList);
    }

    public final List<TaggedTable> tableList() {
        return this.tableList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableList() ? this.tableList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTablesByLfTagsResponse)) {
            return false;
        }
        SearchTablesByLfTagsResponse other = (SearchTablesByLfTagsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTableList() == other.hasTableList() && Objects.equals(this.tableList(), other.tableList());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTablesByLfTagsResponse").add("NextToken", (Object)this.nextToken()).add("TableList", this.hasTableList() ? this.tableList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TableList": {
                return Optional.ofNullable(clazz.cast(this.tableList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchTablesByLfTagsResponse, T> g) {
        return obj -> g.apply((SearchTablesByLfTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LakeFormationResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TaggedTable> tableList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTablesByLfTagsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.tableList(model.tableList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TaggedTable.Builder> getTableList() {
            List<TaggedTable.Builder> result = TableLFTagsListCopier.copyToBuilder(this.tableList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableList(Collection<TaggedTable.BuilderImpl> tableList) {
            this.tableList = TableLFTagsListCopier.copyFromBuilder(tableList);
        }

        @Override
        @Transient
        public final Builder tableList(Collection<TaggedTable> tableList) {
            this.tableList = TableLFTagsListCopier.copy(tableList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tableList(TaggedTable ... tableList) {
            this.tableList(Arrays.asList(tableList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tableList(Consumer<TaggedTable.Builder> ... tableList) {
            this.tableList(Stream.of(tableList).map(c -> (TaggedTable)((TaggedTable.Builder)TaggedTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchTablesByLfTagsResponse build() {
            return new SearchTablesByLfTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LakeFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTablesByLfTagsResponse> {
        public Builder nextToken(String var1);

        public Builder tableList(Collection<TaggedTable> var1);

        public Builder tableList(TaggedTable ... var1);

        public Builder tableList(Consumer<TaggedTable.Builder> ... var1);
    }
}

