/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that describes certain columns on certain rows.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataCellsFilter implements SdkPojo, Serializable, ToCopyableBuilder<DataCellsFilter.Builder, DataCellsFilter> {
    private static final SdkField<String> TABLE_CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableCatalogId").getter(getter(DataCellsFilter::tableCatalogId)).setter(setter(Builder::tableCatalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DataCellsFilter::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DataCellsFilter::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DataCellsFilter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<RowFilter> ROW_FILTER_FIELD = SdkField.<RowFilter> builder(MarshallingType.SDK_POJO)
            .memberName("RowFilter").getter(getter(DataCellsFilter::rowFilter)).setter(setter(Builder::rowFilter))
            .constructor(RowFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowFilter").build()).build();

    private static final SdkField<List<String>> COLUMN_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ColumnNames")
            .getter(getter(DataCellsFilter::columnNames))
            .setter(setter(Builder::columnNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ColumnWildcard> COLUMN_WILDCARD_FIELD = SdkField
            .<ColumnWildcard> builder(MarshallingType.SDK_POJO).memberName("ColumnWildcard")
            .getter(getter(DataCellsFilter::columnWildcard)).setter(setter(Builder::columnWildcard))
            .constructor(ColumnWildcard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnWildcard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, NAME_FIELD, ROW_FILTER_FIELD, COLUMN_NAMES_FIELD, COLUMN_WILDCARD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tableCatalogId;

    private final String databaseName;

    private final String tableName;

    private final String name;

    private final RowFilter rowFilter;

    private final List<String> columnNames;

    private final ColumnWildcard columnWildcard;

    private DataCellsFilter(BuilderImpl builder) {
        this.tableCatalogId = builder.tableCatalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.name = builder.name;
        this.rowFilter = builder.rowFilter;
        this.columnNames = builder.columnNames;
        this.columnWildcard = builder.columnWildcard;
    }

    /**
     * <p>
     * The ID of the catalog to which the table belongs.
     * </p>
     * 
     * @return The ID of the catalog to which the table belongs.
     */
    public final String tableCatalogId() {
        return tableCatalogId;
    }

    /**
     * <p>
     * A database in the Glue Data Catalog.
     * </p>
     * 
     * @return A database in the Glue Data Catalog.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * A table in the database.
     * </p>
     * 
     * @return A table in the database.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The name given by the user to the data filter cell.
     * </p>
     * 
     * @return The name given by the user to the data filter cell.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A PartiQL predicate.
     * </p>
     * 
     * @return A PartiQL predicate.
     */
    public final RowFilter rowFilter() {
        return rowFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnNames() {
        return columnNames != null && !(columnNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of column names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnNames} method.
     * </p>
     * 
     * @return A list of column names.
     */
    public final List<String> columnNames() {
        return columnNames;
    }

    /**
     * <p>
     * A wildcard with exclusions.
     * </p>
     * <p>
     * You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code>.
     * </p>
     * 
     * @return A wildcard with exclusions.</p>
     *         <p>
     *         You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code>.
     */
    public final ColumnWildcard columnWildcard() {
        return columnWildcard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tableCatalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(rowFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnNames() ? columnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(columnWildcard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataCellsFilter)) {
            return false;
        }
        DataCellsFilter other = (DataCellsFilter) obj;
        return Objects.equals(tableCatalogId(), other.tableCatalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(name(), other.name())
                && Objects.equals(rowFilter(), other.rowFilter()) && hasColumnNames() == other.hasColumnNames()
                && Objects.equals(columnNames(), other.columnNames()) && Objects.equals(columnWildcard(), other.columnWildcard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataCellsFilter").add("TableCatalogId", tableCatalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("Name", name()).add("RowFilter", rowFilter())
                .add("ColumnNames", hasColumnNames() ? columnNames() : null).add("ColumnWildcard", columnWildcard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableCatalogId":
            return Optional.ofNullable(clazz.cast(tableCatalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RowFilter":
            return Optional.ofNullable(clazz.cast(rowFilter()));
        case "ColumnNames":
            return Optional.ofNullable(clazz.cast(columnNames()));
        case "ColumnWildcard":
            return Optional.ofNullable(clazz.cast(columnWildcard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataCellsFilter, T> g) {
        return obj -> g.apply((DataCellsFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataCellsFilter> {
        /**
         * <p>
         * The ID of the catalog to which the table belongs.
         * </p>
         * 
         * @param tableCatalogId
         *        The ID of the catalog to which the table belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableCatalogId(String tableCatalogId);

        /**
         * <p>
         * A database in the Glue Data Catalog.
         * </p>
         * 
         * @param databaseName
         *        A database in the Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * A table in the database.
         * </p>
         * 
         * @param tableName
         *        A table in the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The name given by the user to the data filter cell.
         * </p>
         * 
         * @param name
         *        The name given by the user to the data filter cell.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A PartiQL predicate.
         * </p>
         * 
         * @param rowFilter
         *        A PartiQL predicate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowFilter(RowFilter rowFilter);

        /**
         * <p>
         * A PartiQL predicate.
         * </p>
         * This is a convenience that creates an instance of the {@link RowFilter.Builder} avoiding the need to create
         * one manually via {@link RowFilter#builder()}.
         *
         * When the {@link Consumer} completes, {@link RowFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #rowFilter(RowFilter)}.
         * 
         * @param rowFilter
         *        a consumer that will call methods on {@link RowFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowFilter(RowFilter)
         */
        default Builder rowFilter(Consumer<RowFilter.Builder> rowFilter) {
            return rowFilter(RowFilter.builder().applyMutation(rowFilter).build());
        }

        /**
         * <p>
         * A list of column names.
         * </p>
         * 
         * @param columnNames
         *        A list of column names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNames(Collection<String> columnNames);

        /**
         * <p>
         * A list of column names.
         * </p>
         * 
         * @param columnNames
         *        A list of column names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnNames(String... columnNames);

        /**
         * <p>
         * A wildcard with exclusions.
         * </p>
         * <p>
         * You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code>.
         * </p>
         * 
         * @param columnWildcard
         *        A wildcard with exclusions.</p>
         *        <p>
         *        You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnWildcard(ColumnWildcard columnWildcard);

        /**
         * <p>
         * A wildcard with exclusions.
         * </p>
         * <p>
         * You must specify either a <code>ColumnNames</code> list or the <code>ColumnWildCard</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link ColumnWildcard.Builder} avoiding the need to
         * create one manually via {@link ColumnWildcard#builder()}.
         *
         * When the {@link Consumer} completes, {@link ColumnWildcard.Builder#build()} is called immediately and its
         * result is passed to {@link #columnWildcard(ColumnWildcard)}.
         * 
         * @param columnWildcard
         *        a consumer that will call methods on {@link ColumnWildcard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnWildcard(ColumnWildcard)
         */
        default Builder columnWildcard(Consumer<ColumnWildcard.Builder> columnWildcard) {
            return columnWildcard(ColumnWildcard.builder().applyMutation(columnWildcard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String tableCatalogId;

        private String databaseName;

        private String tableName;

        private String name;

        private RowFilter rowFilter;

        private List<String> columnNames = DefaultSdkAutoConstructList.getInstance();

        private ColumnWildcard columnWildcard;

        private BuilderImpl() {
        }

        private BuilderImpl(DataCellsFilter model) {
            tableCatalogId(model.tableCatalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            name(model.name);
            rowFilter(model.rowFilter);
            columnNames(model.columnNames);
            columnWildcard(model.columnWildcard);
        }

        public final String getTableCatalogId() {
            return tableCatalogId;
        }

        public final void setTableCatalogId(String tableCatalogId) {
            this.tableCatalogId = tableCatalogId;
        }

        @Override
        @Transient
        public final Builder tableCatalogId(String tableCatalogId) {
            this.tableCatalogId = tableCatalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RowFilter.Builder getRowFilter() {
            return rowFilter != null ? rowFilter.toBuilder() : null;
        }

        public final void setRowFilter(RowFilter.BuilderImpl rowFilter) {
            this.rowFilter = rowFilter != null ? rowFilter.build() : null;
        }

        @Override
        @Transient
        public final Builder rowFilter(RowFilter rowFilter) {
            this.rowFilter = rowFilter;
            return this;
        }

        public final Collection<String> getColumnNames() {
            if (columnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return columnNames;
        }

        public final void setColumnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
        }

        @Override
        @Transient
        public final Builder columnNames(Collection<String> columnNames) {
            this.columnNames = ColumnNamesCopier.copy(columnNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columnNames(String... columnNames) {
            columnNames(Arrays.asList(columnNames));
            return this;
        }

        public final ColumnWildcard.Builder getColumnWildcard() {
            return columnWildcard != null ? columnWildcard.toBuilder() : null;
        }

        public final void setColumnWildcard(ColumnWildcard.BuilderImpl columnWildcard) {
            this.columnWildcard = columnWildcard != null ? columnWildcard.build() : null;
        }

        @Override
        @Transient
        public final Builder columnWildcard(ColumnWildcard columnWildcard) {
            this.columnWildcard = columnWildcard;
            return this;
        }

        @Override
        public DataCellsFilter build() {
            return new DataCellsFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
