/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum OriginType {
    AWS_KMS("AWS_KMS"),
    EXTERNAL("EXTERNAL"),
    AWS_CLOUDHSM("AWS_CLOUDHSM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private OriginType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OriginType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(OriginType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OriginType> knownValues() {
        return Stream.of(OriginType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

