/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyEncryptionMechanism {
    RSAES_OAEP_SHA_256("RSAES_OAEP_SHA_256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyEncryptionMechanism> VALUE_MAP;
    private final String value;

    private KeyEncryptionMechanism(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyEncryptionMechanism fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyEncryptionMechanism> knownValues() {
        EnumSet<KeyEncryptionMechanism> knownValues = EnumSet.allOf(KeyEncryptionMechanism.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyEncryptionMechanism.class, KeyEncryptionMechanism::toString);
    }
}

