/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyMaterialState {
    NON_CURRENT("NON_CURRENT"),
    CURRENT("CURRENT"),
    PENDING_ROTATION("PENDING_ROTATION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyMaterialState> VALUE_MAP;
    private final String value;

    private KeyMaterialState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyMaterialState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyMaterialState> knownValues() {
        EnumSet<KeyMaterialState> knownValues = EnumSet.allOf(KeyMaterialState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyMaterialState.class, KeyMaterialState::toString);
    }
}

