/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kms.model.KmsResponse;
import software.amazon.awssdk.services.kms.model.RotationsListCopier;
import software.amazon.awssdk.services.kms.model.RotationsListEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListKeyRotationsResponse
extends KmsResponse
implements ToCopyableBuilder<Builder, ListKeyRotationsResponse> {
    private static final SdkField<List<RotationsListEntry>> ROTATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rotations").getter(ListKeyRotationsResponse.getter(ListKeyRotationsResponse::rotations)).setter(ListKeyRotationsResponse.setter(Builder::rotations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rotations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RotationsListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextMarker").getter(ListKeyRotationsResponse.getter(ListKeyRotationsResponse::nextMarker)).setter(ListKeyRotationsResponse.setter(Builder::nextMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker").build()}).build();
    private static final SdkField<Boolean> TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Truncated").getter(ListKeyRotationsResponse.getter(ListKeyRotationsResponse::truncated)).setter(ListKeyRotationsResponse.setter(Builder::truncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truncated").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATIONS_FIELD, NEXT_MARKER_FIELD, TRUNCATED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListKeyRotationsResponse.memberNameToFieldInitializer();
    private final List<RotationsListEntry> rotations;
    private final String nextMarker;
    private final Boolean truncated;

    private ListKeyRotationsResponse(BuilderImpl builder) {
        super(builder);
        this.rotations = builder.rotations;
        this.nextMarker = builder.nextMarker;
        this.truncated = builder.truncated;
    }

    public final boolean hasRotations() {
        return this.rotations != null && !(this.rotations instanceof SdkAutoConstructList);
    }

    public final List<RotationsListEntry> rotations() {
        return this.rotations;
    }

    public final String nextMarker() {
        return this.nextMarker;
    }

    public final Boolean truncated() {
        return this.truncated;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRotations() ? this.rotations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.truncated());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListKeyRotationsResponse)) {
            return false;
        }
        ListKeyRotationsResponse other = (ListKeyRotationsResponse)((Object)obj);
        return this.hasRotations() == other.hasRotations() && Objects.equals(this.rotations(), other.rotations()) && Objects.equals(this.nextMarker(), other.nextMarker()) && Objects.equals(this.truncated(), other.truncated());
    }

    public final String toString() {
        return ToString.builder((String)"ListKeyRotationsResponse").add("Rotations", this.hasRotations() ? this.rotations() : null).add("NextMarker", (Object)this.nextMarker()).add("Truncated", (Object)this.truncated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rotations": {
                return Optional.ofNullable(clazz.cast(this.rotations()));
            }
            case "NextMarker": {
                return Optional.ofNullable(clazz.cast(this.nextMarker()));
            }
            case "Truncated": {
                return Optional.ofNullable(clazz.cast(this.truncated()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Rotations", ROTATIONS_FIELD);
        map.put("NextMarker", NEXT_MARKER_FIELD);
        map.put("Truncated", TRUNCATED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListKeyRotationsResponse, T> g) {
        return obj -> g.apply((ListKeyRotationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KmsResponse.BuilderImpl
    implements Builder {
        private List<RotationsListEntry> rotations = DefaultSdkAutoConstructList.getInstance();
        private String nextMarker;
        private Boolean truncated;

        private BuilderImpl() {
        }

        private BuilderImpl(ListKeyRotationsResponse model) {
            super(model);
            this.rotations(model.rotations);
            this.nextMarker(model.nextMarker);
            this.truncated(model.truncated);
        }

        public final List<RotationsListEntry.Builder> getRotations() {
            List<RotationsListEntry.Builder> result = RotationsListCopier.copyToBuilder(this.rotations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRotations(Collection<RotationsListEntry.BuilderImpl> rotations) {
            this.rotations = RotationsListCopier.copyFromBuilder(rotations);
        }

        @Override
        public final Builder rotations(Collection<RotationsListEntry> rotations) {
            this.rotations = RotationsListCopier.copy(rotations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rotations(RotationsListEntry ... rotations) {
            this.rotations(Arrays.asList(rotations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rotations(Consumer<RotationsListEntry.Builder> ... rotations) {
            this.rotations(Stream.of(rotations).map(c -> (RotationsListEntry)((RotationsListEntry.Builder)RotationsListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextMarker() {
            return this.nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Boolean getTruncated() {
            return this.truncated;
        }

        public final void setTruncated(Boolean truncated) {
            this.truncated = truncated;
        }

        @Override
        public final Builder truncated(Boolean truncated) {
            this.truncated = truncated;
            return this;
        }

        @Override
        public ListKeyRotationsResponse build() {
            return new ListKeyRotationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KmsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListKeyRotationsResponse> {
        public Builder rotations(Collection<RotationsListEntry> var1);

        public Builder rotations(RotationsListEntry ... var1);

        public Builder rotations(Consumer<RotationsListEntry.Builder> ... var1);

        public Builder nextMarker(String var1);

        public Builder truncated(Boolean var1);
    }
}

