/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.GrantListEntry;
import software.amazon.awssdk.services.kms.model.ListGrantsRequest;
import software.amazon.awssdk.services.kms.model.ListGrantsResponse;

public class ListGrantsIterable
implements SdkIterable<ListGrantsResponse> {
    private final KmsClient client;
    private final ListGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGrantsIterable(KmsClient client, ListGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGrantsResponseFetcher();
    }

    public Iterator<ListGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GrantListEntry> grants() {
        Function<ListGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grants() != null) {
                return response.grants().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGrantsResponseFetcher
    implements SyncPageFetcher<ListGrantsResponse> {
        private ListGrantsResponseFetcher() {
        }

        public boolean hasNextPage(ListGrantsResponse previousPage) {
            return previousPage.truncated();
        }

        public ListGrantsResponse nextPage(ListGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListGrantsIterable.this.client.listGrants(ListGrantsIterable.this.firstRequest);
            }
            return ListGrantsIterable.this.client.listGrants((ListGrantsRequest)((Object)ListGrantsIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

