/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.kms.KmsAsyncClient;
import software.amazon.awssdk.services.kms.model.KeyListEntry;
import software.amazon.awssdk.services.kms.model.ListKeysRequest;
import software.amazon.awssdk.services.kms.model.ListKeysResponse;

public class ListKeysPublisher
implements SdkPublisher<ListKeysResponse> {
    private final KmsAsyncClient client;
    private final ListKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListKeysPublisher(KmsAsyncClient client, ListKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListKeysPublisher(KmsAsyncClient client, ListKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<KeyListEntry> keys() {
        Function<ListKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.keys() != null) {
                return response.keys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListKeysResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListKeysResponseFetcher
    implements AsyncPageFetcher<ListKeysResponse> {
        private ListKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListKeysResponse previousPage) {
            return previousPage.truncated();
        }

        public CompletableFuture<ListKeysResponse> nextPage(ListKeysResponse previousPage) {
            if (previousPage == null) {
                return ListKeysPublisher.this.client.listKeys(ListKeysPublisher.this.firstRequest);
            }
            return ListKeysPublisher.this.client.listKeys((ListKeysRequest)((Object)ListKeysPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

