/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideosignaling;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kinesisvideosignaling.KinesisVideoSignalingClient;
import software.amazon.awssdk.services.kinesisvideosignaling.KinesisVideoSignalingServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideosignaling.internal.KinesisVideoSignalingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kinesisvideosignaling.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideosignaling.model.GetIceServerConfigRequest;
import software.amazon.awssdk.services.kinesisvideosignaling.model.GetIceServerConfigResponse;
import software.amazon.awssdk.services.kinesisvideosignaling.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideosignaling.model.InvalidClientException;
import software.amazon.awssdk.services.kinesisvideosignaling.model.KinesisVideoSignalingException;
import software.amazon.awssdk.services.kinesisvideosignaling.model.NotAuthorizedException;
import software.amazon.awssdk.services.kinesisvideosignaling.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisvideosignaling.model.SendAlexaOfferToMasterRequest;
import software.amazon.awssdk.services.kinesisvideosignaling.model.SendAlexaOfferToMasterResponse;
import software.amazon.awssdk.services.kinesisvideosignaling.model.SessionExpiredException;
import software.amazon.awssdk.services.kinesisvideosignaling.transform.GetIceServerConfigRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideosignaling.transform.SendAlexaOfferToMasterRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKinesisVideoSignalingClient
implements KinesisVideoSignalingClient {
    private static final Logger log = Logger.loggerFor(DefaultKinesisVideoSignalingClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisVideoSignalingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Kinesis_Video_Signaling#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetIceServerConfigResponse getIceServerConfig(GetIceServerConfigRequest getIceServerConfigRequest) throws InvalidClientException, SessionExpiredException, ClientLimitExceededException, ResourceNotFoundException, InvalidArgumentException, NotAuthorizedException, AwsServiceException, SdkClientException, KinesisVideoSignalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetIceServerConfigResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "InvalidClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientException::builder).build());
                }
                case "SessionExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionExpiredException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getIceServerConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoSignalingClient.resolveMetricPublishers(clientConfiguration, getIceServerConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Signaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetIceServerConfig");
            GetIceServerConfigResponse getIceServerConfigResponse = (GetIceServerConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetIceServerConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getIceServerConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetIceServerConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getIceServerConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoSignalingClient.lambda$getIceServerConfig$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendAlexaOfferToMasterResponse sendAlexaOfferToMaster(SendAlexaOfferToMasterRequest sendAlexaOfferToMasterRequest) throws ClientLimitExceededException, ResourceNotFoundException, InvalidArgumentException, NotAuthorizedException, AwsServiceException, SdkClientException, KinesisVideoSignalingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendAlexaOfferToMasterResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "InvalidClientException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidClientException::builder).build());
                }
                case "SessionExpiredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("SessionExpiredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(SessionExpiredException::builder).build());
                }
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendAlexaOfferToMasterRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoSignalingClient.resolveMetricPublishers(clientConfiguration, sendAlexaOfferToMasterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Signaling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendAlexaOfferToMaster");
            SendAlexaOfferToMasterResponse sendAlexaOfferToMasterResponse = (SendAlexaOfferToMasterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendAlexaOfferToMaster").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendAlexaOfferToMasterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendAlexaOfferToMasterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendAlexaOfferToMasterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoSignalingClient.lambda$sendAlexaOfferToMaster$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "kinesisvideo";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KinesisVideoSignalingServiceClientConfigurationBuilder serviceConfigBuilder = new KinesisVideoSignalingServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisVideoSignalingException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final KinesisVideoSignalingServiceClientConfiguration serviceClientConfiguration() {
        return new KinesisVideoSignalingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$sendAlexaOfferToMaster$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getIceServerConfig$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

