/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ImageError;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<Instant> TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TimeStamp").getter(Image.getter(Image::timeStamp)).setter(Image.setter(Builder::timeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeStamp").build()}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Error").getter(Image.getter(Image::errorAsString)).setter(Image.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final SdkField<String> IMAGE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageContent").getter(Image.getter(Image::imageContent)).setter(Image.setter(Builder::imageContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageContent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_STAMP_FIELD, ERROR_FIELD, IMAGE_CONTENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Image.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant timeStamp;
    private final String error;
    private final String imageContent;

    private Image(BuilderImpl builder) {
        this.timeStamp = builder.timeStamp;
        this.error = builder.error;
        this.imageContent = builder.imageContent;
    }

    public final Instant timeStamp() {
        return this.timeStamp;
    }

    public final ImageError error() {
        return ImageError.fromValue(this.error);
    }

    public final String errorAsString() {
        return this.error;
    }

    public final String imageContent() {
        return this.imageContent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageContent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.timeStamp(), other.timeStamp()) && Objects.equals(this.errorAsString(), other.errorAsString()) && Objects.equals(this.imageContent(), other.imageContent());
    }

    public final String toString() {
        return ToString.builder((String)"Image").add("TimeStamp", (Object)this.timeStamp()).add("Error", (Object)this.errorAsString()).add("ImageContent", (Object)this.imageContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeStamp": {
                return Optional.ofNullable(clazz.cast(this.timeStamp()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.errorAsString()));
            }
            case "ImageContent": {
                return Optional.ofNullable(clazz.cast(this.imageContent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TimeStamp", TIME_STAMP_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("ImageContent", IMAGE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timeStamp;
        private String error;
        private String imageContent;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.timeStamp(model.timeStamp);
            this.error(model.error);
            this.imageContent(model.imageContent);
        }

        public final Instant getTimeStamp() {
            return this.timeStamp;
        }

        public final void setTimeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Override
        public final Builder timeStamp(Instant timeStamp) {
            this.timeStamp = timeStamp;
            return this;
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(ImageError error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public final String getImageContent() {
            return this.imageContent;
        }

        public final void setImageContent(String imageContent) {
            this.imageContent = imageContent;
        }

        @Override
        public final Builder imageContent(String imageContent) {
            this.imageContent = imageContent;
            return this;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder timeStamp(Instant var1);

        public Builder error(String var1);

        public Builder error(ImageError var1);

        public Builder imageContent(String var1);
    }
}

