/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHDisplayFragmentNumber;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHDisplayFragmentTimestamp;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHFragmentSelector;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.DASHPlaybackMode;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDashStreamingSessionUrlRequest
extends KinesisVideoArchivedMediaRequest
implements ToCopyableBuilder<Builder, GetDashStreamingSessionUrlRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(GetDashStreamingSessionUrlRequest.getter(GetDashStreamingSessionUrlRequest::streamName)).setter(GetDashStreamingSessionUrlRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(GetDashStreamingSessionUrlRequest.getter(GetDashStreamingSessionUrlRequest::streamARN)).setter(GetDashStreamingSessionUrlRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> PLAYBACK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackMode").getter(GetDashStreamingSessionUrlRequest.getter(GetDashStreamingSessionUrlRequest::playbackModeAsString)).setter(GetDashStreamingSessionUrlRequest.setter(Builder::playbackMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackMode").build()}).build();
    private static final SdkField<String> DISPLAY_FRAGMENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayFragmentTimestamp").getter(GetDashStreamingSessionUrlRequest.getter(GetDashStreamingSessionUrlRequest::displayFragmentTimestampAsString)).setter(GetDashStreamingSessionUrlRequest.setter(Builder::displayFragmentTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFragmentTimestamp").build()}).build();
    private static final SdkField<String> DISPLAY_FRAGMENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayFragmentNumber").getter(GetDashStreamingSessionUrlRequest.getter(GetDashStreamingSessionUrlRequest::displayFragmentNumberAsString)).setter(GetDashStreamingSessionUrlRequest.setter(Builder::displayFragmentNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFragmentNumber").build()}).build();
    private static final SdkField<DASHFragmentSelector> DASH_FRAGMENT_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DASHFragmentSelector").getter(GetDashStreamingSessionUrlRequest.getter(GetDashStreamingSessionUrlRequest::dashFragmentSelector)).setter(GetDashStreamingSessionUrlRequest.setter(Builder::dashFragmentSelector)).constructor(DASHFragmentSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DASHFragmentSelector").build()}).build();
    private static final SdkField<Integer> EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Expires").getter(GetDashStreamingSessionUrlRequest.getter(GetDashStreamingSessionUrlRequest::expires)).setter(GetDashStreamingSessionUrlRequest.setter(Builder::expires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expires").build()}).build();
    private static final SdkField<Long> MAX_MANIFEST_FRAGMENT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxManifestFragmentResults").getter(GetDashStreamingSessionUrlRequest.getter(GetDashStreamingSessionUrlRequest::maxManifestFragmentResults)).setter(GetDashStreamingSessionUrlRequest.setter(Builder::maxManifestFragmentResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxManifestFragmentResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, PLAYBACK_MODE_FIELD, DISPLAY_FRAGMENT_TIMESTAMP_FIELD, DISPLAY_FRAGMENT_NUMBER_FIELD, DASH_FRAGMENT_SELECTOR_FIELD, EXPIRES_FIELD, MAX_MANIFEST_FRAGMENT_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDashStreamingSessionUrlRequest.memberNameToFieldInitializer();
    private final String streamName;
    private final String streamARN;
    private final String playbackMode;
    private final String displayFragmentTimestamp;
    private final String displayFragmentNumber;
    private final DASHFragmentSelector dashFragmentSelector;
    private final Integer expires;
    private final Long maxManifestFragmentResults;

    private GetDashStreamingSessionUrlRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.playbackMode = builder.playbackMode;
        this.displayFragmentTimestamp = builder.displayFragmentTimestamp;
        this.displayFragmentNumber = builder.displayFragmentNumber;
        this.dashFragmentSelector = builder.dashFragmentSelector;
        this.expires = builder.expires;
        this.maxManifestFragmentResults = builder.maxManifestFragmentResults;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final DASHPlaybackMode playbackMode() {
        return DASHPlaybackMode.fromValue(this.playbackMode);
    }

    public final String playbackModeAsString() {
        return this.playbackMode;
    }

    public final DASHDisplayFragmentTimestamp displayFragmentTimestamp() {
        return DASHDisplayFragmentTimestamp.fromValue(this.displayFragmentTimestamp);
    }

    public final String displayFragmentTimestampAsString() {
        return this.displayFragmentTimestamp;
    }

    public final DASHDisplayFragmentNumber displayFragmentNumber() {
        return DASHDisplayFragmentNumber.fromValue(this.displayFragmentNumber);
    }

    public final String displayFragmentNumberAsString() {
        return this.displayFragmentNumber;
    }

    public final DASHFragmentSelector dashFragmentSelector() {
        return this.dashFragmentSelector;
    }

    public final Integer expires() {
        return this.expires;
    }

    public final Long maxManifestFragmentResults() {
        return this.maxManifestFragmentResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayFragmentTimestampAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayFragmentNumberAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashFragmentSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxManifestFragmentResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDashStreamingSessionUrlRequest)) {
            return false;
        }
        GetDashStreamingSessionUrlRequest other = (GetDashStreamingSessionUrlRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.playbackModeAsString(), other.playbackModeAsString()) && Objects.equals(this.displayFragmentTimestampAsString(), other.displayFragmentTimestampAsString()) && Objects.equals(this.displayFragmentNumberAsString(), other.displayFragmentNumberAsString()) && Objects.equals(this.dashFragmentSelector(), other.dashFragmentSelector()) && Objects.equals(this.expires(), other.expires()) && Objects.equals(this.maxManifestFragmentResults(), other.maxManifestFragmentResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetDashStreamingSessionUrlRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("PlaybackMode", (Object)this.playbackModeAsString()).add("DisplayFragmentTimestamp", (Object)this.displayFragmentTimestampAsString()).add("DisplayFragmentNumber", (Object)this.displayFragmentNumberAsString()).add("DASHFragmentSelector", (Object)this.dashFragmentSelector()).add("Expires", (Object)this.expires()).add("MaxManifestFragmentResults", (Object)this.maxManifestFragmentResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "PlaybackMode": {
                return Optional.ofNullable(clazz.cast(this.playbackModeAsString()));
            }
            case "DisplayFragmentTimestamp": {
                return Optional.ofNullable(clazz.cast(this.displayFragmentTimestampAsString()));
            }
            case "DisplayFragmentNumber": {
                return Optional.ofNullable(clazz.cast(this.displayFragmentNumberAsString()));
            }
            case "DASHFragmentSelector": {
                return Optional.ofNullable(clazz.cast(this.dashFragmentSelector()));
            }
            case "Expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
            case "MaxManifestFragmentResults": {
                return Optional.ofNullable(clazz.cast(this.maxManifestFragmentResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("PlaybackMode", PLAYBACK_MODE_FIELD);
        map.put("DisplayFragmentTimestamp", DISPLAY_FRAGMENT_TIMESTAMP_FIELD);
        map.put("DisplayFragmentNumber", DISPLAY_FRAGMENT_NUMBER_FIELD);
        map.put("DASHFragmentSelector", DASH_FRAGMENT_SELECTOR_FIELD);
        map.put("Expires", EXPIRES_FIELD);
        map.put("MaxManifestFragmentResults", MAX_MANIFEST_FRAGMENT_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDashStreamingSessionUrlRequest, T> g) {
        return obj -> g.apply((GetDashStreamingSessionUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoArchivedMediaRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String playbackMode;
        private String displayFragmentTimestamp;
        private String displayFragmentNumber;
        private DASHFragmentSelector dashFragmentSelector;
        private Integer expires;
        private Long maxManifestFragmentResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDashStreamingSessionUrlRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.playbackMode(model.playbackMode);
            this.displayFragmentTimestamp(model.displayFragmentTimestamp);
            this.displayFragmentNumber(model.displayFragmentNumber);
            this.dashFragmentSelector(model.dashFragmentSelector);
            this.expires(model.expires);
            this.maxManifestFragmentResults(model.maxManifestFragmentResults);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getPlaybackMode() {
            return this.playbackMode;
        }

        public final void setPlaybackMode(String playbackMode) {
            this.playbackMode = playbackMode;
        }

        @Override
        public final Builder playbackMode(String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        @Override
        public final Builder playbackMode(DASHPlaybackMode playbackMode) {
            this.playbackMode(playbackMode == null ? null : playbackMode.toString());
            return this;
        }

        public final String getDisplayFragmentTimestamp() {
            return this.displayFragmentTimestamp;
        }

        public final void setDisplayFragmentTimestamp(String displayFragmentTimestamp) {
            this.displayFragmentTimestamp = displayFragmentTimestamp;
        }

        @Override
        public final Builder displayFragmentTimestamp(String displayFragmentTimestamp) {
            this.displayFragmentTimestamp = displayFragmentTimestamp;
            return this;
        }

        @Override
        public final Builder displayFragmentTimestamp(DASHDisplayFragmentTimestamp displayFragmentTimestamp) {
            this.displayFragmentTimestamp(displayFragmentTimestamp == null ? null : displayFragmentTimestamp.toString());
            return this;
        }

        public final String getDisplayFragmentNumber() {
            return this.displayFragmentNumber;
        }

        public final void setDisplayFragmentNumber(String displayFragmentNumber) {
            this.displayFragmentNumber = displayFragmentNumber;
        }

        @Override
        public final Builder displayFragmentNumber(String displayFragmentNumber) {
            this.displayFragmentNumber = displayFragmentNumber;
            return this;
        }

        @Override
        public final Builder displayFragmentNumber(DASHDisplayFragmentNumber displayFragmentNumber) {
            this.displayFragmentNumber(displayFragmentNumber == null ? null : displayFragmentNumber.toString());
            return this;
        }

        public final DASHFragmentSelector.Builder getDashFragmentSelector() {
            return this.dashFragmentSelector != null ? this.dashFragmentSelector.toBuilder() : null;
        }

        public final void setDashFragmentSelector(DASHFragmentSelector.BuilderImpl dashFragmentSelector) {
            this.dashFragmentSelector = dashFragmentSelector != null ? dashFragmentSelector.build() : null;
        }

        @Override
        public final Builder dashFragmentSelector(DASHFragmentSelector dashFragmentSelector) {
            this.dashFragmentSelector = dashFragmentSelector;
            return this;
        }

        public final Integer getExpires() {
            return this.expires;
        }

        public final void setExpires(Integer expires) {
            this.expires = expires;
        }

        @Override
        public final Builder expires(Integer expires) {
            this.expires = expires;
            return this;
        }

        public final Long getMaxManifestFragmentResults() {
            return this.maxManifestFragmentResults;
        }

        public final void setMaxManifestFragmentResults(Long maxManifestFragmentResults) {
            this.maxManifestFragmentResults = maxManifestFragmentResults;
        }

        @Override
        public final Builder maxManifestFragmentResults(Long maxManifestFragmentResults) {
            this.maxManifestFragmentResults = maxManifestFragmentResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDashStreamingSessionUrlRequest build() {
            return new GetDashStreamingSessionUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisVideoArchivedMediaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDashStreamingSessionUrlRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder playbackMode(String var1);

        public Builder playbackMode(DASHPlaybackMode var1);

        public Builder displayFragmentTimestamp(String var1);

        public Builder displayFragmentTimestamp(DASHDisplayFragmentTimestamp var1);

        public Builder displayFragmentNumber(String var1);

        public Builder displayFragmentNumber(DASHDisplayFragmentNumber var1);

        public Builder dashFragmentSelector(DASHFragmentSelector var1);

        default public Builder dashFragmentSelector(Consumer<DASHFragmentSelector.Builder> dashFragmentSelector) {
            return this.dashFragmentSelector((DASHFragmentSelector)((DASHFragmentSelector.Builder)DASHFragmentSelector.builder().applyMutation(dashFragmentSelector)).build());
        }

        public Builder expires(Integer var1);

        public Builder maxManifestFragmentResults(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

