/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoClient;
import software.amazon.awssdk.services.kinesisvideo.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisvideo.model.ChannelInfo;
import software.amazon.awssdk.services.kinesisvideo.model.ListSignalingChannelsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListSignalingChannelsResponse;

public class ListSignalingChannelsIterable
implements SdkIterable<ListSignalingChannelsResponse> {
    private final KinesisVideoClient client;
    private final ListSignalingChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSignalingChannelsIterable(KinesisVideoClient client, ListSignalingChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSignalingChannelsResponseFetcher();
    }

    public Iterator<ListSignalingChannelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ChannelInfo> channelInfoList() {
        Function<ListSignalingChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channelInfoList() != null) {
                return response.channelInfoList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSignalingChannelsResponseFetcher
    implements SyncPageFetcher<ListSignalingChannelsResponse> {
        private ListSignalingChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListSignalingChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSignalingChannelsResponse nextPage(ListSignalingChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListSignalingChannelsIterable.this.client.listSignalingChannels(ListSignalingChannelsIterable.this.firstRequest);
            }
            return ListSignalingChannelsIterable.this.client.listSignalingChannels((ListSignalingChannelsRequest)((Object)ListSignalingChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

