/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2Client;
import software.amazon.awssdk.services.kinesisanalyticsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotDetails;

public class ListApplicationSnapshotsIterable
implements SdkIterable<ListApplicationSnapshotsResponse> {
    private final KinesisAnalyticsV2Client client;
    private final ListApplicationSnapshotsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationSnapshotsIterable(KinesisAnalyticsV2Client client, ListApplicationSnapshotsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationSnapshotsResponseFetcher();
    }

    public Iterator<ListApplicationSnapshotsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SnapshotDetails> snapshotSummaries() {
        Function<ListApplicationSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshotSummaries() != null) {
                return response.snapshotSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationSnapshotsResponseFetcher
    implements SyncPageFetcher<ListApplicationSnapshotsResponse> {
        private ListApplicationSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationSnapshotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApplicationSnapshotsResponse nextPage(ListApplicationSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationSnapshotsIterable.this.client.listApplicationSnapshots(ListApplicationSnapshotsIterable.this.firstRequest);
            }
            return ListApplicationSnapshotsIterable.this.client.listApplicationSnapshots((ListApplicationSnapshotsRequest)((Object)ListApplicationSnapshotsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

