/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateApplicationMaintenanceConfigurationResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, UpdateApplicationMaintenanceConfigurationResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationARN").getter(UpdateApplicationMaintenanceConfigurationResponse.getter(UpdateApplicationMaintenanceConfigurationResponse::applicationARN)).setter(UpdateApplicationMaintenanceConfigurationResponse.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<ApplicationMaintenanceConfigurationDescription> APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ApplicationMaintenanceConfigurationDescription").getter(UpdateApplicationMaintenanceConfigurationResponse.getter(UpdateApplicationMaintenanceConfigurationResponse::applicationMaintenanceConfigurationDescription)).setter(UpdateApplicationMaintenanceConfigurationResponse.setter(Builder::applicationMaintenanceConfigurationDescription)).constructor(ApplicationMaintenanceConfigurationDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationMaintenanceConfigurationDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateApplicationMaintenanceConfigurationResponse.memberNameToFieldInitializer();
    private final String applicationARN;
    private final ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription;

    private UpdateApplicationMaintenanceConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationMaintenanceConfigurationDescription = builder.applicationMaintenanceConfigurationDescription;
    }

    public final String applicationARN() {
        return this.applicationARN;
    }

    public final ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription() {
        return this.applicationMaintenanceConfigurationDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationMaintenanceConfigurationDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationMaintenanceConfigurationResponse)) {
            return false;
        }
        UpdateApplicationMaintenanceConfigurationResponse other = (UpdateApplicationMaintenanceConfigurationResponse)((Object)obj);
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationMaintenanceConfigurationDescription(), other.applicationMaintenanceConfigurationDescription());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateApplicationMaintenanceConfigurationResponse").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationMaintenanceConfigurationDescription", (Object)this.applicationMaintenanceConfigurationDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationMaintenanceConfigurationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationMaintenanceConfigurationDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationARN", APPLICATION_ARN_FIELD);
        map.put("ApplicationMaintenanceConfigurationDescription", APPLICATION_MAINTENANCE_CONFIGURATION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationMaintenanceConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateApplicationMaintenanceConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private String applicationARN;
        private ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationMaintenanceConfigurationResponse model) {
            super(model);
            this.applicationARN(model.applicationARN);
            this.applicationMaintenanceConfigurationDescription(model.applicationMaintenanceConfigurationDescription);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final ApplicationMaintenanceConfigurationDescription.Builder getApplicationMaintenanceConfigurationDescription() {
            return this.applicationMaintenanceConfigurationDescription != null ? this.applicationMaintenanceConfigurationDescription.toBuilder() : null;
        }

        public final void setApplicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription.BuilderImpl applicationMaintenanceConfigurationDescription) {
            this.applicationMaintenanceConfigurationDescription = applicationMaintenanceConfigurationDescription != null ? applicationMaintenanceConfigurationDescription.build() : null;
        }

        @Override
        public final Builder applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription applicationMaintenanceConfigurationDescription) {
            this.applicationMaintenanceConfigurationDescription = applicationMaintenanceConfigurationDescription;
            return this;
        }

        @Override
        public UpdateApplicationMaintenanceConfigurationResponse build() {
            return new UpdateApplicationMaintenanceConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateApplicationMaintenanceConfigurationResponse> {
        public Builder applicationARN(String var1);

        public Builder applicationMaintenanceConfigurationDescription(ApplicationMaintenanceConfigurationDescription var1);

        default public Builder applicationMaintenanceConfigurationDescription(Consumer<ApplicationMaintenanceConfigurationDescription.Builder> applicationMaintenanceConfigurationDescription) {
            return this.applicationMaintenanceConfigurationDescription((ApplicationMaintenanceConfigurationDescription)((ApplicationMaintenanceConfigurationDescription.Builder)ApplicationMaintenanceConfigurationDescription.builder().applyMutation(applicationMaintenanceConfigurationDescription)).build());
        }
    }
}

