/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ReferenceDataSourceUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ReferenceDataSourceUpdate> {
    private static final SdkField<String> BUCKET_ARN_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketARNUpdate").getter(S3ReferenceDataSourceUpdate.getter(S3ReferenceDataSourceUpdate::bucketARNUpdate)).setter(S3ReferenceDataSourceUpdate.setter(Builder::bucketARNUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketARNUpdate").build()}).build();
    private static final SdkField<String> FILE_KEY_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileKeyUpdate").getter(S3ReferenceDataSourceUpdate.getter(S3ReferenceDataSourceUpdate::fileKeyUpdate)).setter(S3ReferenceDataSourceUpdate.setter(Builder::fileKeyUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileKeyUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_UPDATE_FIELD, FILE_KEY_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ReferenceDataSourceUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucketARNUpdate;
    private final String fileKeyUpdate;

    private S3ReferenceDataSourceUpdate(BuilderImpl builder) {
        this.bucketARNUpdate = builder.bucketARNUpdate;
        this.fileKeyUpdate = builder.fileKeyUpdate;
    }

    public final String bucketARNUpdate() {
        return this.bucketARNUpdate;
    }

    public final String fileKeyUpdate() {
        return this.fileKeyUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketARNUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileKeyUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ReferenceDataSourceUpdate)) {
            return false;
        }
        S3ReferenceDataSourceUpdate other = (S3ReferenceDataSourceUpdate)obj;
        return Objects.equals(this.bucketARNUpdate(), other.bucketARNUpdate()) && Objects.equals(this.fileKeyUpdate(), other.fileKeyUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"S3ReferenceDataSourceUpdate").add("BucketARNUpdate", (Object)this.bucketARNUpdate()).add("FileKeyUpdate", (Object)this.fileKeyUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketARNUpdate": {
                return Optional.ofNullable(clazz.cast(this.bucketARNUpdate()));
            }
            case "FileKeyUpdate": {
                return Optional.ofNullable(clazz.cast(this.fileKeyUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BucketARNUpdate", BUCKET_ARN_UPDATE_FIELD);
        map.put("FileKeyUpdate", FILE_KEY_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ReferenceDataSourceUpdate, T> g) {
        return obj -> g.apply((S3ReferenceDataSourceUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketARNUpdate;
        private String fileKeyUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ReferenceDataSourceUpdate model) {
            this.bucketARNUpdate(model.bucketARNUpdate);
            this.fileKeyUpdate(model.fileKeyUpdate);
        }

        public final String getBucketARNUpdate() {
            return this.bucketARNUpdate;
        }

        public final void setBucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
        }

        @Override
        public final Builder bucketARNUpdate(String bucketARNUpdate) {
            this.bucketARNUpdate = bucketARNUpdate;
            return this;
        }

        public final String getFileKeyUpdate() {
            return this.fileKeyUpdate;
        }

        public final void setFileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
        }

        @Override
        public final Builder fileKeyUpdate(String fileKeyUpdate) {
            this.fileKeyUpdate = fileKeyUpdate;
            return this;
        }

        public S3ReferenceDataSourceUpdate build() {
            return new S3ReferenceDataSourceUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ReferenceDataSourceUpdate> {
        public Builder bucketARNUpdate(String var1);

        public Builder fileKeyUpdate(String var1);
    }
}

