/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointParams;
import software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointProvider;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultKinesisEndpointProvider
implements KinesisEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(KinesisEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(KinesisEndpointParams params, String region) {
        RuleResult result = DefaultKinesisEndpointProvider.endpointRule1(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule51(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule83(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule115(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule147(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule151(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(KinesisEndpointParams params, String region) {
        RulePartition partitionResult;
        String streamIdSuffixValue;
        String streamIdPrefixValue;
        String streamIdDelimiterReversedValue;
        String streamIdDelimiterValue;
        if (params.streamId() != null && (streamIdDelimiterValue = RulesFunctions.substring(params.streamId(), 20, 21, false)) != null && "-".equals(streamIdDelimiterValue) && (streamIdDelimiterReversedValue = RulesFunctions.substring(params.streamId(), 3, 4, true)) != null && "-".equals(streamIdDelimiterReversedValue) && (streamIdPrefixValue = RulesFunctions.substring(params.streamId(), 0, 20, false)) != null && (streamIdSuffixValue = RulesFunctions.substring(params.streamId(), 21, 24, false)) != null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && !"aws-iso".equals(partitionResult.name()) && !"aws-iso-b".equals(partitionResult.name())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule2(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule3(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule19(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule35(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule41(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule45(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        String httpsCustomEndpointSuffixValue;
        String httpsEndpointDelimiterValue;
        String httpsCustomEndpointDelimiterValue;
        if (params.endpoint() != null && (httpsCustomEndpointDelimiterValue = RulesFunctions.substring(params.endpoint(), 15, 16, false)) != null && "-".equals(httpsCustomEndpointDelimiterValue) && (httpsEndpointDelimiterValue = RulesFunctions.substring(params.endpoint(), 20, 21, false)) != null && ".".equals(httpsEndpointDelimiterValue) && (httpsCustomEndpointSuffixValue = RulesFunctions.substring(params.endpoint(), 15, 20, false)) != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule4(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, httpsCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule10(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, httpsCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule14(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, httpsCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis" + httpsCustomEndpointSuffixValue + "." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String httpsCustomEndpointSuffixValue, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule5(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, httpsCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String httpsCustomEndpointSuffixValue, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule6(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, httpsCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String httpsCustomEndpointSuffixValue, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis" + httpsCustomEndpointSuffixValue + "-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String httpsCustomEndpointSuffixValue, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule11(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, httpsCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String httpsCustomEndpointSuffixValue, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis" + httpsCustomEndpointSuffixValue + "-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule14(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String httpsCustomEndpointSuffixValue, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule15(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, httpsCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule15(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String httpsCustomEndpointSuffixValue, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis" + httpsCustomEndpointSuffixValue + "." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        String plainCustomEndpointSuffixValue;
        String plainEndpointDelimiterValue;
        String plainCustomEndpointDelimiterValue;
        if (params.endpoint() != null && (plainCustomEndpointDelimiterValue = RulesFunctions.substring(params.endpoint(), 7, 8, false)) != null && "-".equals(plainCustomEndpointDelimiterValue) && (plainEndpointDelimiterValue = RulesFunctions.substring(params.endpoint(), 12, 13, false)) != null && ".".equals(plainEndpointDelimiterValue) && (plainCustomEndpointSuffixValue = RulesFunctions.substring(params.endpoint(), 7, 12, false)) != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule20(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, plainCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule26(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, plainCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule30(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, plainCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis" + plainCustomEndpointSuffixValue + "." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String plainCustomEndpointSuffixValue, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule21(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, plainCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String plainCustomEndpointSuffixValue, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule22(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, plainCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String plainCustomEndpointSuffixValue, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis" + plainCustomEndpointSuffixValue + "-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule26(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String plainCustomEndpointSuffixValue, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule27(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, plainCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String plainCustomEndpointSuffixValue, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis" + plainCustomEndpointSuffixValue + "-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String plainCustomEndpointSuffixValue, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule31(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, plainCustomEndpointSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule31(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String plainCustomEndpointSuffixValue, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis" + plainCustomEndpointSuffixValue + "." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule35(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule36(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule36(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule37(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule37(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule41(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule42(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule42(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule45(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule46(params, partitionResult, streamIdPrefixValue, streamIdSuffixValue, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule46(KinesisEndpointParams params, RulePartition partitionResult, String streamIdPrefixValue, String streamIdSuffixValue, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + streamIdPrefixValue + "." + streamIdSuffixValue + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule51(KinesisEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.streamArn() != null && params.endpoint() == null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && !"aws-iso".equals(partitionResult.name()) && !"aws-iso-b".equals(partitionResult.name())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule52(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Failed to parse ARN.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule52(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        RuleArn arn = RulesFunctions.awsParseArn(params.streamArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule53(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid account id.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule53(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule54(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid region.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule54(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule55(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + arn.service() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule55(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if ("kinesis".equals(arn.service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule56(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule56(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        String arnType = RulesFunctions.listAccess(arn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule57(params, arnType, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + arnType + "` arn types.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule57(KinesisEndpointParams params, String arnType, RulePartition partitionResult, RuleArn arn, String region) {
        if ("stream".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule58(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Partition: " + arn.partition() + " from ARN doesn't match with partition name: " + partitionResult.name() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule58(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (RulesFunctions.stringEquals(partitionResult.name(), arn.partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule59(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule59(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule60(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule66(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule70(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule60(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule61(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule61(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule62(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule62(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule66(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule67(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule67(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule70(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule71(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule71(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule83(KinesisEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.consumerArn() != null && params.endpoint() == null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && !"aws-iso".equals(partitionResult.name()) && !"aws-iso-b".equals(partitionResult.name())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule84(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Failed to parse ARN.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule84(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        RuleArn arn = RulesFunctions.awsParseArn(params.consumerArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule85(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid account id.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule85(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule86(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid region.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule86(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule87(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + arn.service() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule87(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if ("kinesis".equals(arn.service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule88(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule88(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        String arnType = RulesFunctions.listAccess(arn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule89(params, arnType, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + arnType + "` arn types.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule89(KinesisEndpointParams params, String arnType, RulePartition partitionResult, RuleArn arn, String region) {
        if ("stream".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule90(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Partition: " + arn.partition() + " from ARN doesn't match with partition name: " + partitionResult.name() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule90(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (RulesFunctions.stringEquals(partitionResult.name(), arn.partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule91(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule91(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule92(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule98(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule102(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule92(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule93(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule93(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule94(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule94(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule98(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule99(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule99(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule102(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule103(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule103(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule115(KinesisEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.resourceArn() != null && params.endpoint() == null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && !"aws-iso".equals(partitionResult.name()) && !"aws-iso-b".equals(partitionResult.name())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule116(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Failed to parse ARN.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule116(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        RuleArn arn = RulesFunctions.awsParseArn(params.resourceArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule117(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid account id.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule117(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule118(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid region.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule118(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule119(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + arn.service() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule119(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if ("kinesis".equals(arn.service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule120(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule120(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        String arnType = RulesFunctions.listAccess(arn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule121(params, arnType, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + arnType + "` arn types.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule121(KinesisEndpointParams params, String arnType, RulePartition partitionResult, RuleArn arn, String region) {
        if ("stream".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule122(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Partition: " + arn.partition() + " from ARN doesn't match with partition name: " + partitionResult.name() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule122(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (RulesFunctions.stringEquals(partitionResult.name(), arn.partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule123(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule123(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule124(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule130(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule134(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule124(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule125(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule125(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule126(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule126(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule130(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule131(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule131(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule134(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule135(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule135(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule147(KinesisEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule151(KinesisEndpointParams params, String region) {
        if (region != null) {
            return DefaultKinesisEndpointProvider.endpointRule152(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule152(KinesisEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule153(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule157(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule162(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule153(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule154(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule154(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule157(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule158(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule158(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            if ("aws-us-gov".equals(partitionResult.name())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + region + ".amazonaws.com")).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule162(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule163(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule163(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

