/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointParams;
import software.amazon.awssdk.services.kinesis.endpoints.KinesisEndpointProvider;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.kinesis.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultKinesisEndpointProvider
implements KinesisEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(KinesisEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(KinesisEndpointParams params, String region) {
        RuleResult result = DefaultKinesisEndpointProvider.endpointRule1(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule33(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule65(params, region);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule97(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultKinesisEndpointProvider.endpointRule101(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(KinesisEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.streamArn() != null && params.endpoint() == null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && !"aws-iso".equals(partitionResult.name()) && !"aws-iso-b".equals(partitionResult.name())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule2(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Failed to parse ARN.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule2(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        RuleArn arn = RulesFunctions.awsParseArn(params.streamArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule3(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid account id.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule3(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule4(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid region.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule4(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule5(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + arn.service() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if ("kinesis".equals(arn.service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule6(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        String arnType = RulesFunctions.listAccess(arn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule7(params, arnType, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + arnType + "` arn types.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(KinesisEndpointParams params, String arnType, RulePartition partitionResult, RuleArn arn, String region) {
        if ("stream".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule8(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Partition: " + arn.partition() + " from ARN doesn't match with partition name: " + partitionResult.name() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (RulesFunctions.stringEquals(partitionResult.name(), arn.partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule9(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule9(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule10(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule16(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule20(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule10(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule11(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule12(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule16(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule17(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule21(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule21(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule33(KinesisEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.consumerArn() != null && params.endpoint() == null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && !"aws-iso".equals(partitionResult.name()) && !"aws-iso-b".equals(partitionResult.name())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule34(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Failed to parse ARN.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule34(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        RuleArn arn = RulesFunctions.awsParseArn(params.consumerArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule35(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid account id.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule35(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule36(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid region.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule36(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule37(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + arn.service() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule37(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if ("kinesis".equals(arn.service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule38(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule38(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        String arnType = RulesFunctions.listAccess(arn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule39(params, arnType, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + arnType + "` arn types.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule39(KinesisEndpointParams params, String arnType, RulePartition partitionResult, RuleArn arn, String region) {
        if ("stream".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule40(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Partition: " + arn.partition() + " from ARN doesn't match with partition name: " + partitionResult.name() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule40(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (RulesFunctions.stringEquals(partitionResult.name(), arn.partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule41(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule41(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule42(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule48(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule52(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule42(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule43(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule43(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule44(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule44(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule48(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule49(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule49(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule52(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule53(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule53(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule65(KinesisEndpointParams params, String region) {
        RulePartition partitionResult;
        if (params.resourceArn() != null && params.endpoint() == null && region != null && (partitionResult = RulesFunctions.awsPartition(region)) != null && !"aws-iso".equals(partitionResult.name()) && !"aws-iso-b".equals(partitionResult.name())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule66(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Failed to parse ARN.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule66(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        RuleArn arn = RulesFunctions.awsParseArn(params.resourceArn());
        if (arn != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule67(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid account id.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule67(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.accountId(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule68(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Invalid region.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule68(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if (RulesFunctions.isValidHostLabel(arn.region(), false)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule69(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: The ARN was not for the Kinesis service, found: " + arn.service() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule69(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        if ("kinesis".equals(arn.service())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule70(params, arn, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: No ARN type specified");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule70(KinesisEndpointParams params, RuleArn arn, RulePartition partitionResult, String region) {
        String arnType = RulesFunctions.listAccess(arn.resourceId(), 0);
        if (arnType != null && !"".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule71(params, arnType, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid ARN: Kinesis ARNs don't support `" + arnType + "` arn types.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule71(KinesisEndpointParams params, String arnType, RulePartition partitionResult, RuleArn arn, String region) {
        if ("stream".equals(arnType)) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule72(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Partition: " + arn.partition() + " from ARN doesn't match with partition name: " + partitionResult.name() + ".");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule72(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (RulesFunctions.stringEquals(partitionResult.name(), arn.partition())) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule73(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Operation Type is not set. Please contact service team for resolution.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule73(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.operationType() != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule74(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule80(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule84(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule74(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule75(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled, but this partition does not support FIPS.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule75(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule76(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled, but this partition does not support DualStack.");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule76(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule80(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule81(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule81(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsFIPS()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule84(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule85(params, partitionResult, arn, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule85(KinesisEndpointParams params, RulePartition partitionResult, RuleArn arn, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://" + arn.accountId() + "." + params.operationType() + "-kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule97(KinesisEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule101(KinesisEndpointParams params, String region) {
        if (region != null) {
            return DefaultKinesisEndpointProvider.endpointRule102(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule102(KinesisEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule103(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule107(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultKinesisEndpointProvider.endpointRule112(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule103(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule104(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule104(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule107(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule108(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule108(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            if ("aws-us-gov".equals(partitionResult.name())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + region + ".amazonaws.com")).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule112(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultKinesisEndpointProvider.endpointRule113(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule113(KinesisEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://kinesis." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

