/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamRequest;
import software.amazon.awssdk.services.kinesis.model.AddTagsToStreamResponse;
import software.amazon.awssdk.services.kinesis.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesis.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.DecreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DeregisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryRequest;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamSummaryResponse;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.DisableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringRequest;
import software.amazon.awssdk.services.kinesis.model.EnableEnhancedMonitoringResponse;
import software.amazon.awssdk.services.kinesis.model.ExpiredIteratorException;
import software.amazon.awssdk.services.kinesis.model.ExpiredNextTokenException;
import software.amazon.awssdk.services.kinesis.model.GetRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodRequest;
import software.amazon.awssdk.services.kinesis.model.IncreaseStreamRetentionPeriodResponse;
import software.amazon.awssdk.services.kinesis.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.KmsAccessDeniedException;
import software.amazon.awssdk.services.kinesis.model.KmsDisabledException;
import software.amazon.awssdk.services.kinesis.model.KmsInvalidStateException;
import software.amazon.awssdk.services.kinesis.model.KmsNotFoundException;
import software.amazon.awssdk.services.kinesis.model.KmsOptInRequiredException;
import software.amazon.awssdk.services.kinesis.model.KmsThrottlingException;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ListShardsRequest;
import software.amazon.awssdk.services.kinesis.model.ListShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;
import software.amazon.awssdk.services.kinesis.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesis.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesis.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesis.model.MergeShardsRequest;
import software.amazon.awssdk.services.kinesis.model.MergeShardsResponse;
import software.amazon.awssdk.services.kinesis.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;
import software.amazon.awssdk.services.kinesis.model.PutRecordsRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerRequest;
import software.amazon.awssdk.services.kinesis.model.RegisterStreamConsumerResponse;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamRequest;
import software.amazon.awssdk.services.kinesis.model.RemoveTagsFromStreamResponse;
import software.amazon.awssdk.services.kinesis.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesis.model.SplitShardRequest;
import software.amazon.awssdk.services.kinesis.model.SplitShardResponse;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StartStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionRequest;
import software.amazon.awssdk.services.kinesis.model.StopStreamEncryptionResponse;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountRequest;
import software.amazon.awssdk.services.kinesis.model.UpdateShardCountResponse;
import software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable;
import software.amazon.awssdk.services.kinesis.waiters.KinesisWaiter;

/**
 * Service client for accessing Kinesis. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Kinesis Data Streams Service API Reference</fullname>
 * <p>
 * Amazon Kinesis Data Streams is a managed service that scales elastically for real-time processing of streaming big
 * data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface KinesisClient extends SdkClient {
    String SERVICE_NAME = "kinesis";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "kinesis";

    /**
     * Create a {@link KinesisClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static KinesisClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link KinesisClient}.
     */
    static KinesisClientBuilder builder() {
        return new DefaultKinesisClientBuilder();
    }

    /**
     * <p>
     * Adds or updates tags for the specified Kinesis data stream. Each time you invoke this operation, you can specify
     * up to 10 tags. If you want to add more than 10 tags to your stream, you can invoke this operation multiple times.
     * In total, each stream can have up to 50 tags.
     * </p>
     * <p>
     * If tags have already been assigned to the stream, <code>AddTagsToStream</code> overwrites any existing tags that
     * correspond to the specified tag keys.
     * </p>
     * <p>
     * <a>AddTagsToStream</a> has a limit of five transactions per second per account.
     * </p>
     *
     * @param addTagsToStreamRequest
     *        Represents the input for <code>AddTagsToStream</code>.
     * @return Result of the AddTagsToStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.AddTagsToStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStream" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToStreamResponse addTagsToStream(AddTagsToStreamRequest addTagsToStreamRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for the specified Kinesis data stream. Each time you invoke this operation, you can specify
     * up to 10 tags. If you want to add more than 10 tags to your stream, you can invoke this operation multiple times.
     * In total, each stream can have up to 50 tags.
     * </p>
     * <p>
     * If tags have already been assigned to the stream, <code>AddTagsToStream</code> overwrites any existing tags that
     * correspond to the specified tag keys.
     * </p>
     * <p>
     * <a>AddTagsToStream</a> has a limit of five transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToStreamRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToStreamRequest#builder()}
     * </p>
     *
     * @param addTagsToStreamRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToStreamInput.Builder} to create a request.
     *        Represents the input for <code>AddTagsToStream</code>.
     * @return Result of the AddTagsToStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.AddTagsToStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/AddTagsToStream" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToStreamResponse addTagsToStream(Consumer<AddTagsToStreamRequest.Builder> addTagsToStreamRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        return addTagsToStream(AddTagsToStreamRequest.builder().applyMutation(addTagsToStreamRequest).build());
    }

    /**
     * <p>
     * Creates a Kinesis data stream. A stream captures and transports data records that are continuously emitted from
     * different data sources or <i>producers</i>. Scale-out within a stream is explicitly supported by means of shards,
     * which are uniquely identified groups of data records in a stream.
     * </p>
     * <p>
     * You specify and control the number of shards that a stream is composed of. Each shard can support reads up to
     * five transactions per second, up to a maximum data read total of 2 MiB per second. Each shard can support writes
     * up to 1,000 records per second, up to a maximum data write total of 1 MiB per second. If the amount of data input
     * increases or decreases, you can add or remove shards.
     * </p>
     * <p>
     * The stream name identifies the stream. The name is scoped to the AWS account used by the application. It is also
     * scoped by AWS Region. That is, two streams in two different accounts can have the same name, and two streams in
     * the same account, but in two different Regions, can have the same name.
     * </p>
     * <p>
     * <code>CreateStream</code> is an asynchronous operation. Upon receiving a <code>CreateStream</code> request,
     * Kinesis Data Streams immediately returns and sets the stream status to <code>CREATING</code>. After the stream is
     * created, Kinesis Data Streams sets the stream status to <code>ACTIVE</code>. You should perform read and write
     * operations only on an <code>ACTIVE</code> stream.
     * </p>
     * <p>
     * You receive a <code>LimitExceededException</code> when making a <code>CreateStream</code> request when you try to
     * do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Have more than five streams in the <code>CREATING</code> state at any point in time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create more shards than are authorized for your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the default shard limit for an AWS account, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Amazon Kinesis Data Streams
     * Limits</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>. To increase this limit, <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">contact AWS Support</a>.
     * </p>
     * <p>
     * You can use <code>DescribeStream</code> to check the stream status, which is returned in
     * <code>StreamStatus</code>.
     * </p>
     * <p>
     * <a>CreateStream</a> has a limit of five transactions per second per account.
     * </p>
     *
     * @param createStreamRequest
     *        Represents the input for <code>CreateStream</code>.
     * @return Result of the CreateStream operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.CreateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) throws ResourceInUseException,
            LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Kinesis data stream. A stream captures and transports data records that are continuously emitted from
     * different data sources or <i>producers</i>. Scale-out within a stream is explicitly supported by means of shards,
     * which are uniquely identified groups of data records in a stream.
     * </p>
     * <p>
     * You specify and control the number of shards that a stream is composed of. Each shard can support reads up to
     * five transactions per second, up to a maximum data read total of 2 MiB per second. Each shard can support writes
     * up to 1,000 records per second, up to a maximum data write total of 1 MiB per second. If the amount of data input
     * increases or decreases, you can add or remove shards.
     * </p>
     * <p>
     * The stream name identifies the stream. The name is scoped to the AWS account used by the application. It is also
     * scoped by AWS Region. That is, two streams in two different accounts can have the same name, and two streams in
     * the same account, but in two different Regions, can have the same name.
     * </p>
     * <p>
     * <code>CreateStream</code> is an asynchronous operation. Upon receiving a <code>CreateStream</code> request,
     * Kinesis Data Streams immediately returns and sets the stream status to <code>CREATING</code>. After the stream is
     * created, Kinesis Data Streams sets the stream status to <code>ACTIVE</code>. You should perform read and write
     * operations only on an <code>ACTIVE</code> stream.
     * </p>
     * <p>
     * You receive a <code>LimitExceededException</code> when making a <code>CreateStream</code> request when you try to
     * do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Have more than five streams in the <code>CREATING</code> state at any point in time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Create more shards than are authorized for your account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the default shard limit for an AWS account, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Amazon Kinesis Data Streams
     * Limits</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>. To increase this limit, <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">contact AWS Support</a>.
     * </p>
     * <p>
     * You can use <code>DescribeStream</code> to check the stream status, which is returned in
     * <code>StreamStatus</code>.
     * </p>
     * <p>
     * <a>CreateStream</a> has a limit of five transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStreamRequest#builder()}
     * </p>
     *
     * @param createStreamRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamInput.Builder} to create a request.
     *        Represents the input for <code>CreateStream</code>.
     * @return Result of the CreateStream operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.CreateStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/CreateStream" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStreamResponse createStream(Consumer<CreateStreamRequest.Builder> createStreamRequest)
            throws ResourceInUseException, LimitExceededException, InvalidArgumentException, AwsServiceException,
            SdkClientException, KinesisException {
        return createStream(CreateStreamRequest.builder().applyMutation(createStreamRequest).build());
    }

    /**
     * <p>
     * Decreases the Kinesis data stream's retention period, which is the length of time data records are accessible
     * after they are added to the stream. The minimum value of a stream's retention period is 24 hours.
     * </p>
     * <p>
     * This operation may result in lost data. For example, if the stream's retention period is 48 hours and is
     * decreased to 24 hours, any data already in the stream that is older than 24 hours is inaccessible.
     * </p>
     *
     * @param decreaseStreamRetentionPeriodRequest
     *        Represents the input for <a>DecreaseStreamRetentionPeriod</a>.
     * @return Result of the DecreaseStreamRetentionPeriod operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DecreaseStreamRetentionPeriod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriod"
     *      target="_top">AWS API Documentation</a>
     */
    default DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriod(
            DecreaseStreamRetentionPeriodRequest decreaseStreamRetentionPeriodRequest) throws ResourceInUseException,
            ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException,
            KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Decreases the Kinesis data stream's retention period, which is the length of time data records are accessible
     * after they are added to the stream. The minimum value of a stream's retention period is 24 hours.
     * </p>
     * <p>
     * This operation may result in lost data. For example, if the stream's retention period is 48 hours and is
     * decreased to 24 hours, any data already in the stream that is older than 24 hours is inaccessible.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DecreaseStreamRetentionPeriodRequest.Builder}
     * avoiding the need to create one manually via {@link DecreaseStreamRetentionPeriodRequest#builder()}
     * </p>
     *
     * @param decreaseStreamRetentionPeriodRequest
     *        A {@link Consumer} that will call methods on {@link DecreaseStreamRetentionPeriodInput.Builder} to create
     *        a request. Represents the input for <a>DecreaseStreamRetentionPeriod</a>.
     * @return Result of the DecreaseStreamRetentionPeriod operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DecreaseStreamRetentionPeriod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DecreaseStreamRetentionPeriod"
     *      target="_top">AWS API Documentation</a>
     */
    default DecreaseStreamRetentionPeriodResponse decreaseStreamRetentionPeriod(
            Consumer<DecreaseStreamRetentionPeriodRequest.Builder> decreaseStreamRetentionPeriodRequest)
            throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException,
            AwsServiceException, SdkClientException, KinesisException {
        return decreaseStreamRetentionPeriod(DecreaseStreamRetentionPeriodRequest.builder()
                .applyMutation(decreaseStreamRetentionPeriodRequest).build());
    }

    /**
     * <p>
     * Deletes a Kinesis data stream and all its shards and data. You must shut down any applications that are operating
     * on the stream before you delete the stream. If an application attempts to operate on a deleted stream, it
     * receives the exception <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * If the stream is in the <code>ACTIVE</code> state, you can delete it. After a <code>DeleteStream</code> request,
     * the specified stream is in the <code>DELETING</code> state until Kinesis Data Streams completes the deletion.
     * </p>
     * <p>
     * <b>Note:</b> Kinesis Data Streams might continue to accept data read and write operations, such as
     * <a>PutRecord</a>, <a>PutRecords</a>, and <a>GetRecords</a>, on a stream in the <code>DELETING</code> state until
     * the stream deletion is complete.
     * </p>
     * <p>
     * When you delete a stream, any shards in that stream are also deleted, and any tags are dissociated from the
     * stream.
     * </p>
     * <p>
     * You can use the <a>DescribeStream</a> operation to check the state of the stream, which is returned in
     * <code>StreamStatus</code>.
     * </p>
     * <p>
     * <a>DeleteStream</a> has a limit of five transactions per second per account.
     * </p>
     *
     * @param deleteStreamRequest
     *        Represents the input for <a>DeleteStream</a>.
     * @return Result of the DeleteStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DeleteStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStream" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStreamResponse deleteStream(DeleteStreamRequest deleteStreamRequest) throws ResourceNotFoundException,
            LimitExceededException, ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Kinesis data stream and all its shards and data. You must shut down any applications that are operating
     * on the stream before you delete the stream. If an application attempts to operate on a deleted stream, it
     * receives the exception <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * If the stream is in the <code>ACTIVE</code> state, you can delete it. After a <code>DeleteStream</code> request,
     * the specified stream is in the <code>DELETING</code> state until Kinesis Data Streams completes the deletion.
     * </p>
     * <p>
     * <b>Note:</b> Kinesis Data Streams might continue to accept data read and write operations, such as
     * <a>PutRecord</a>, <a>PutRecords</a>, and <a>GetRecords</a>, on a stream in the <code>DELETING</code> state until
     * the stream deletion is complete.
     * </p>
     * <p>
     * When you delete a stream, any shards in that stream are also deleted, and any tags are dissociated from the
     * stream.
     * </p>
     * <p>
     * You can use the <a>DescribeStream</a> operation to check the state of the stream, which is returned in
     * <code>StreamStatus</code>.
     * </p>
     * <p>
     * <a>DeleteStream</a> has a limit of five transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStreamRequest#builder()}
     * </p>
     *
     * @param deleteStreamRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStreamInput.Builder} to create a request.
     *        Represents the input for <a>DeleteStream</a>.
     * @return Result of the DeleteStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DeleteStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeleteStream" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStreamResponse deleteStream(Consumer<DeleteStreamRequest.Builder> deleteStreamRequest)
            throws ResourceNotFoundException, LimitExceededException, ResourceInUseException, AwsServiceException,
            SdkClientException, KinesisException {
        return deleteStream(DeleteStreamRequest.builder().applyMutation(deleteStreamRequest).build());
    }

    /**
     * <p>
     * To deregister a consumer, provide its ARN. Alternatively, you can provide the ARN of the data stream and the name
     * you gave the consumer when you registered it. You may also provide all three parameters, as long as they don't
     * conflict with each other. If you don't know the name or ARN of the consumer that you want to deregister, you can
     * use the <a>ListStreamConsumers</a> operation to get a list of the descriptions of all the consumers that are
     * currently registered with a given data stream. The description of a consumer contains its name and ARN.
     * </p>
     * <p>
     * This operation has a limit of five transactions per second per stream.
     * </p>
     *
     * @param deregisterStreamConsumerRequest
     * @return Result of the DeregisterStreamConsumer operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DeregisterStreamConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeregisterStreamConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterStreamConsumerResponse deregisterStreamConsumer(
            DeregisterStreamConsumerRequest deregisterStreamConsumerRequest) throws LimitExceededException,
            ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * To deregister a consumer, provide its ARN. Alternatively, you can provide the ARN of the data stream and the name
     * you gave the consumer when you registered it. You may also provide all three parameters, as long as they don't
     * conflict with each other. If you don't know the name or ARN of the consumer that you want to deregister, you can
     * use the <a>ListStreamConsumers</a> operation to get a list of the descriptions of all the consumers that are
     * currently registered with a given data stream. The description of a consumer contains its name and ARN.
     * </p>
     * <p>
     * This operation has a limit of five transactions per second per stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterStreamConsumerRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterStreamConsumerRequest#builder()}
     * </p>
     *
     * @param deregisterStreamConsumerRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterStreamConsumerInput.Builder} to create a
     *        request.
     * @return Result of the DeregisterStreamConsumer operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DeregisterStreamConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DeregisterStreamConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterStreamConsumerResponse deregisterStreamConsumer(
            Consumer<DeregisterStreamConsumerRequest.Builder> deregisterStreamConsumerRequest) throws LimitExceededException,
            ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        return deregisterStreamConsumer(DeregisterStreamConsumerRequest.builder().applyMutation(deregisterStreamConsumerRequest)
                .build());
    }

    /**
     * <p>
     * Describes the shard limits and usage for the account.
     * </p>
     * <p>
     * If you update your account limits, the old limits might be returned for a few minutes.
     * </p>
     * <p>
     * This operation has a limit of one transaction per second per account.
     * </p>
     *
     * @return Result of the DescribeLimits operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeLimits
     * @see #describeLimits(DescribeLimitsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLimitsResponse describeLimits() throws LimitExceededException, AwsServiceException, SdkClientException,
            KinesisException {
        return describeLimits(DescribeLimitsRequest.builder().build());
    }

    /**
     * <p>
     * Describes the shard limits and usage for the account.
     * </p>
     * <p>
     * If you update your account limits, the old limits might be returned for a few minutes.
     * </p>
     * <p>
     * This operation has a limit of one transaction per second per account.
     * </p>
     *
     * @param describeLimitsRequest
     * @return Result of the DescribeLimits operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLimitsResponse describeLimits(DescribeLimitsRequest describeLimitsRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the shard limits and usage for the account.
     * </p>
     * <p>
     * If you update your account limits, the old limits might be returned for a few minutes.
     * </p>
     * <p>
     * This operation has a limit of one transaction per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeLimitsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeLimitsRequest#builder()}
     * </p>
     *
     * @param describeLimitsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLimitsInput.Builder} to create a request.
     * @return Result of the DescribeLimits operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeLimits" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeLimitsResponse describeLimits(Consumer<DescribeLimitsRequest.Builder> describeLimitsRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        return describeLimits(DescribeLimitsRequest.builder().applyMutation(describeLimitsRequest).build());
    }

    /**
     * <p>
     * Describes the specified Kinesis data stream.
     * </p>
     * <p>
     * The information returned includes the stream name, Amazon Resource Name (ARN), creation time, enhanced metric
     * configuration, and shard map. The shard map is an array of shard objects. For each shard object, there is the
     * hash key and sequence number ranges that the shard spans, and the IDs of any earlier shards that played in a role
     * in creating the shard. Every record ingested in the stream is identified by a sequence number, which is assigned
     * when the record is put into the stream.
     * </p>
     * <p>
     * You can limit the number of shards returned by each call. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-retrieve-shards.html">Retrieving
     * Shards from a Stream</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * There are no guarantees about the chronological order shards returned. To process shards in chronological order,
     * use the ID of the parent shard to track the lineage to the oldest shard.
     * </p>
     * <p>
     * This operation has a limit of 10 transactions per second per account.
     * </p>
     *
     * @param describeStreamRequest
     *        Represents the input for <code>DescribeStream</code>.
     * @return Result of the DescribeStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStream" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Kinesis data stream.
     * </p>
     * <p>
     * The information returned includes the stream name, Amazon Resource Name (ARN), creation time, enhanced metric
     * configuration, and shard map. The shard map is an array of shard objects. For each shard object, there is the
     * hash key and sequence number ranges that the shard spans, and the IDs of any earlier shards that played in a role
     * in creating the shard. Every record ingested in the stream is identified by a sequence number, which is assigned
     * when the record is put into the stream.
     * </p>
     * <p>
     * You can limit the number of shards returned by each call. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-retrieve-shards.html">Retrieving
     * Shards from a Stream</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * There are no guarantees about the chronological order shards returned. To process shards in chronological order,
     * use the ID of the parent shard to track the lineage to the oldest shard.
     * </p>
     * <p>
     * This operation has a limit of 10 transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStreamRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStreamRequest#builder()}
     * </p>
     *
     * @param describeStreamRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStreamInput.Builder} to create a request.
     *        Represents the input for <code>DescribeStream</code>.
     * @return Result of the DescribeStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStream" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStreamResponse describeStream(Consumer<DescribeStreamRequest.Builder> describeStreamRequest)
            throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        return describeStream(DescribeStreamRequest.builder().applyMutation(describeStreamRequest).build());
    }

    /**
     * <p>
     * To get the description of a registered consumer, provide the ARN of the consumer. Alternatively, you can provide
     * the ARN of the data stream and the name you gave the consumer when you registered it. You may also provide all
     * three parameters, as long as they don't conflict with each other. If you don't know the name or ARN of the
     * consumer that you want to describe, you can use the <a>ListStreamConsumers</a> operation to get a list of the
     * descriptions of all the consumers that are currently registered with a given data stream.
     * </p>
     * <p>
     * This operation has a limit of 20 transactions per second per stream.
     * </p>
     *
     * @param describeStreamConsumerRequest
     * @return Result of the DescribeStreamConsumer operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeStreamConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStreamConsumerResponse describeStreamConsumer(DescribeStreamConsumerRequest describeStreamConsumerRequest)
            throws LimitExceededException, ResourceNotFoundException, InvalidArgumentException, AwsServiceException,
            SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * To get the description of a registered consumer, provide the ARN of the consumer. Alternatively, you can provide
     * the ARN of the data stream and the name you gave the consumer when you registered it. You may also provide all
     * three parameters, as long as they don't conflict with each other. If you don't know the name or ARN of the
     * consumer that you want to describe, you can use the <a>ListStreamConsumers</a> operation to get a list of the
     * descriptions of all the consumers that are currently registered with a given data stream.
     * </p>
     * <p>
     * This operation has a limit of 20 transactions per second per stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStreamConsumerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStreamConsumerRequest#builder()}
     * </p>
     *
     * @param describeStreamConsumerRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStreamConsumerInput.Builder} to create a
     *        request.
     * @return Result of the DescribeStreamConsumer operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeStreamConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStreamConsumerResponse describeStreamConsumer(
            Consumer<DescribeStreamConsumerRequest.Builder> describeStreamConsumerRequest) throws LimitExceededException,
            ResourceNotFoundException, InvalidArgumentException, AwsServiceException, SdkClientException, KinesisException {
        return describeStreamConsumer(DescribeStreamConsumerRequest.builder().applyMutation(describeStreamConsumerRequest)
                .build());
    }

    /**
     * <p>
     * Provides a summarized description of the specified Kinesis data stream without the shard list.
     * </p>
     * <p>
     * The information returned includes the stream name, Amazon Resource Name (ARN), status, record retention period,
     * approximate creation time, monitoring, encryption details, and open shard count.
     * </p>
     * <p>
     * <a>DescribeStreamSummary</a> has a limit of 20 transactions per second per account.
     * </p>
     *
     * @param describeStreamSummaryRequest
     * @return Result of the DescribeStreamSummary operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeStreamSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStreamSummaryResponse describeStreamSummary(DescribeStreamSummaryRequest describeStreamSummaryRequest)
            throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a summarized description of the specified Kinesis data stream without the shard list.
     * </p>
     * <p>
     * The information returned includes the stream name, Amazon Resource Name (ARN), status, record retention period,
     * approximate creation time, monitoring, encryption details, and open shard count.
     * </p>
     * <p>
     * <a>DescribeStreamSummary</a> has a limit of 20 transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStreamSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeStreamSummaryRequest#builder()}
     * </p>
     *
     * @param describeStreamSummaryRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStreamSummaryInput.Builder} to create a
     *        request.
     * @return Result of the DescribeStreamSummary operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DescribeStreamSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DescribeStreamSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStreamSummaryResponse describeStreamSummary(
            Consumer<DescribeStreamSummaryRequest.Builder> describeStreamSummaryRequest) throws ResourceNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        return describeStreamSummary(DescribeStreamSummaryRequest.builder().applyMutation(describeStreamSummaryRequest).build());
    }

    /**
     * <p>
     * Disables enhanced monitoring.
     * </p>
     *
     * @param disableEnhancedMonitoringRequest
     *        Represents the input for <a>DisableEnhancedMonitoring</a>.
     * @return Result of the DisableEnhancedMonitoring operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DisableEnhancedMonitoring
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DisableEnhancedMonitoring"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableEnhancedMonitoringResponse disableEnhancedMonitoring(
            DisableEnhancedMonitoringRequest disableEnhancedMonitoringRequest) throws InvalidArgumentException,
            LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables enhanced monitoring.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableEnhancedMonitoringRequest.Builder} avoiding
     * the need to create one manually via {@link DisableEnhancedMonitoringRequest#builder()}
     * </p>
     *
     * @param disableEnhancedMonitoringRequest
     *        A {@link Consumer} that will call methods on {@link DisableEnhancedMonitoringInput.Builder} to create a
     *        request. Represents the input for <a>DisableEnhancedMonitoring</a>.
     * @return Result of the DisableEnhancedMonitoring operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.DisableEnhancedMonitoring
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/DisableEnhancedMonitoring"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableEnhancedMonitoringResponse disableEnhancedMonitoring(
            Consumer<DisableEnhancedMonitoringRequest.Builder> disableEnhancedMonitoringRequest) throws InvalidArgumentException,
            LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            KinesisException {
        return disableEnhancedMonitoring(DisableEnhancedMonitoringRequest.builder()
                .applyMutation(disableEnhancedMonitoringRequest).build());
    }

    /**
     * <p>
     * Enables enhanced Kinesis data stream monitoring for shard-level metrics.
     * </p>
     *
     * @param enableEnhancedMonitoringRequest
     *        Represents the input for <a>EnableEnhancedMonitoring</a>.
     * @return Result of the EnableEnhancedMonitoring operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.EnableEnhancedMonitoring
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnableEnhancedMonitoring"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableEnhancedMonitoringResponse enableEnhancedMonitoring(
            EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) throws InvalidArgumentException,
            LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables enhanced Kinesis data stream monitoring for shard-level metrics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableEnhancedMonitoringRequest.Builder} avoiding
     * the need to create one manually via {@link EnableEnhancedMonitoringRequest#builder()}
     * </p>
     *
     * @param enableEnhancedMonitoringRequest
     *        A {@link Consumer} that will call methods on {@link EnableEnhancedMonitoringInput.Builder} to create a
     *        request. Represents the input for <a>EnableEnhancedMonitoring</a>.
     * @return Result of the EnableEnhancedMonitoring operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.EnableEnhancedMonitoring
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/EnableEnhancedMonitoring"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableEnhancedMonitoringResponse enableEnhancedMonitoring(
            Consumer<EnableEnhancedMonitoringRequest.Builder> enableEnhancedMonitoringRequest) throws InvalidArgumentException,
            LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            KinesisException {
        return enableEnhancedMonitoring(EnableEnhancedMonitoringRequest.builder().applyMutation(enableEnhancedMonitoringRequest)
                .build());
    }

    /**
     * <p>
     * Gets data records from a Kinesis data stream's shard.
     * </p>
     * <p>
     * Specify a shard iterator using the <code>ShardIterator</code> parameter. The shard iterator specifies the
     * position in the shard from which you want to start reading data records sequentially. If there are no records
     * available in the portion of the shard that the iterator points to, <a>GetRecords</a> returns an empty list. It
     * might take multiple calls to get to a portion of the shard that contains records.
     * </p>
     * <p>
     * You can scale by provisioning multiple shards per stream while considering service limits (for more information,
     * see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Amazon Kinesis Data
     * Streams Limits</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>). Your application should have one
     * thread per shard, each reading continuously from its stream. To read from a stream continually, call
     * <a>GetRecords</a> in a loop. Use <a>GetShardIterator</a> to get the shard iterator to specify in the first
     * <a>GetRecords</a> call. <a>GetRecords</a> returns a new shard iterator in <code>NextShardIterator</code>. Specify
     * the shard iterator returned in <code>NextShardIterator</code> in subsequent calls to <a>GetRecords</a>. If the
     * shard has been closed, the shard iterator can't return more data and <a>GetRecords</a> returns <code>null</code>
     * in <code>NextShardIterator</code>. You can terminate the loop when the shard is closed, or when the shard
     * iterator reaches the record with the sequence number or other attribute that marks it as the last record to
     * process.
     * </p>
     * <p>
     * Each data record can be up to 1 MiB in size, and each shard can read up to 2 MiB per second. You can ensure that
     * your calls don't exceed the maximum supported size or throughput by using the <code>Limit</code> parameter to
     * specify the maximum number of records that <a>GetRecords</a> can return. Consider your average record size when
     * determining this limit. The maximum number of records that can be returned per call is 10,000.
     * </p>
     * <p>
     * The size of the data returned by <a>GetRecords</a> varies depending on the utilization of the shard. The maximum
     * size of data that <a>GetRecords</a> can return is 10 MiB. If a call returns this amount of data, subsequent calls
     * made within the next 5 seconds throw <code>ProvisionedThroughputExceededException</code>. If there is
     * insufficient provisioned throughput on the stream, subsequent calls made within the next 1 second throw
     * <code>ProvisionedThroughputExceededException</code>. <a>GetRecords</a> doesn't return any data when it throws an
     * exception. For this reason, we recommend that you wait 1 second between calls to <a>GetRecords</a>. However, it's
     * possible that the application will get exceptions for longer than 1 second.
     * </p>
     * <p>
     * To detect whether the application is falling behind in processing, you can use the
     * <code>MillisBehindLatest</code> response attribute. You can also monitor the stream using CloudWatch metrics and
     * other mechanisms (see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring.html">Monitoring</a> in
     * the <i>Amazon Kinesis Data Streams Developer Guide</i>).
     * </p>
     * <p>
     * Each Amazon Kinesis record includes a value, <code>ApproximateArrivalTimestamp</code>, that is set when a stream
     * successfully receives and stores a record. This is commonly referred to as a server-side time stamp, whereas a
     * client-side time stamp is set when a data producer creates or sends the record to a stream (a data producer is
     * any data source putting data records into a stream, for example with <a>PutRecords</a>). The time stamp has
     * millisecond precision. There are no guarantees about the time stamp accuracy, or that the time stamp is always
     * increasing. For example, records in a shard or across a stream might have time stamps that are out of order.
     * </p>
     * <p>
     * This operation has a limit of five transactions per second per shard.
     * </p>
     *
     * @param getRecordsRequest
     *        Represents the input for <a>GetRecords</a>.
     * @return Result of the GetRecords operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws ProvisionedThroughputExceededException
     *         The request rate for the stream is too high, or the requested data is too large for the available
     *         throughput. Reduce the frequency or size of your requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in
     *         the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential
     *         Backoff in AWS</a> in the <i>AWS General Reference</i>.
     * @throws ExpiredIteratorException
     *         The provided iterator exceeds the maximum age allowed.
     * @throws KmsDisabledException
     *         The request was rejected because the specified customer master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The request was rejected because the state of the specified resource isn't valid for this request. For
     *         more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How
     *         Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that you don't have access to.
     * @throws KmsNotFoundException
     *         The request was rejected because the specified entity or resource can't be found.
     * @throws KmsOptInRequiredException
     *         The AWS access key ID needs a subscription for the service.
     * @throws KmsThrottlingException
     *         The request was denied due to request throttling. For more information about throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.GetRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException,
            InvalidArgumentException, ProvisionedThroughputExceededException, ExpiredIteratorException, KmsDisabledException,
            KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException,
            KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets data records from a Kinesis data stream's shard.
     * </p>
     * <p>
     * Specify a shard iterator using the <code>ShardIterator</code> parameter. The shard iterator specifies the
     * position in the shard from which you want to start reading data records sequentially. If there are no records
     * available in the portion of the shard that the iterator points to, <a>GetRecords</a> returns an empty list. It
     * might take multiple calls to get to a portion of the shard that contains records.
     * </p>
     * <p>
     * You can scale by provisioning multiple shards per stream while considering service limits (for more information,
     * see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Amazon Kinesis Data
     * Streams Limits</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>). Your application should have one
     * thread per shard, each reading continuously from its stream. To read from a stream continually, call
     * <a>GetRecords</a> in a loop. Use <a>GetShardIterator</a> to get the shard iterator to specify in the first
     * <a>GetRecords</a> call. <a>GetRecords</a> returns a new shard iterator in <code>NextShardIterator</code>. Specify
     * the shard iterator returned in <code>NextShardIterator</code> in subsequent calls to <a>GetRecords</a>. If the
     * shard has been closed, the shard iterator can't return more data and <a>GetRecords</a> returns <code>null</code>
     * in <code>NextShardIterator</code>. You can terminate the loop when the shard is closed, or when the shard
     * iterator reaches the record with the sequence number or other attribute that marks it as the last record to
     * process.
     * </p>
     * <p>
     * Each data record can be up to 1 MiB in size, and each shard can read up to 2 MiB per second. You can ensure that
     * your calls don't exceed the maximum supported size or throughput by using the <code>Limit</code> parameter to
     * specify the maximum number of records that <a>GetRecords</a> can return. Consider your average record size when
     * determining this limit. The maximum number of records that can be returned per call is 10,000.
     * </p>
     * <p>
     * The size of the data returned by <a>GetRecords</a> varies depending on the utilization of the shard. The maximum
     * size of data that <a>GetRecords</a> can return is 10 MiB. If a call returns this amount of data, subsequent calls
     * made within the next 5 seconds throw <code>ProvisionedThroughputExceededException</code>. If there is
     * insufficient provisioned throughput on the stream, subsequent calls made within the next 1 second throw
     * <code>ProvisionedThroughputExceededException</code>. <a>GetRecords</a> doesn't return any data when it throws an
     * exception. For this reason, we recommend that you wait 1 second between calls to <a>GetRecords</a>. However, it's
     * possible that the application will get exceptions for longer than 1 second.
     * </p>
     * <p>
     * To detect whether the application is falling behind in processing, you can use the
     * <code>MillisBehindLatest</code> response attribute. You can also monitor the stream using CloudWatch metrics and
     * other mechanisms (see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/monitoring.html">Monitoring</a> in
     * the <i>Amazon Kinesis Data Streams Developer Guide</i>).
     * </p>
     * <p>
     * Each Amazon Kinesis record includes a value, <code>ApproximateArrivalTimestamp</code>, that is set when a stream
     * successfully receives and stores a record. This is commonly referred to as a server-side time stamp, whereas a
     * client-side time stamp is set when a data producer creates or sends the record to a stream (a data producer is
     * any data source putting data records into a stream, for example with <a>PutRecords</a>). The time stamp has
     * millisecond precision. There are no guarantees about the time stamp accuracy, or that the time stamp is always
     * increasing. For example, records in a shard or across a stream might have time stamps that are out of order.
     * </p>
     * <p>
     * This operation has a limit of five transactions per second per shard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecordsRequest.Builder} avoiding the need to
     * create one manually via {@link GetRecordsRequest#builder()}
     * </p>
     *
     * @param getRecordsRequest
     *        A {@link Consumer} that will call methods on {@link GetRecordsInput.Builder} to create a request.
     *        Represents the input for <a>GetRecords</a>.
     * @return Result of the GetRecords operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws ProvisionedThroughputExceededException
     *         The request rate for the stream is too high, or the requested data is too large for the available
     *         throughput. Reduce the frequency or size of your requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in
     *         the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential
     *         Backoff in AWS</a> in the <i>AWS General Reference</i>.
     * @throws ExpiredIteratorException
     *         The provided iterator exceeds the maximum age allowed.
     * @throws KmsDisabledException
     *         The request was rejected because the specified customer master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The request was rejected because the state of the specified resource isn't valid for this request. For
     *         more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How
     *         Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that you don't have access to.
     * @throws KmsNotFoundException
     *         The request was rejected because the specified entity or resource can't be found.
     * @throws KmsOptInRequiredException
     *         The AWS access key ID needs a subscription for the service.
     * @throws KmsThrottlingException
     *         The request was denied due to request throttling. For more information about throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.GetRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRecordsResponse getRecords(Consumer<GetRecordsRequest.Builder> getRecordsRequest)
            throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException,
            ExpiredIteratorException, KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException,
            KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException,
            KinesisException {
        return getRecords(GetRecordsRequest.builder().applyMutation(getRecordsRequest).build());
    }

    /**
     * <p>
     * Gets an Amazon Kinesis shard iterator. A shard iterator expires 5 minutes after it is returned to the requester.
     * </p>
     * <p>
     * A shard iterator specifies the shard position from which to start reading data records sequentially. The position
     * is specified using the sequence number of a data record in a shard. A sequence number is the identifier
     * associated with every record ingested in the stream, and is assigned when a record is put into the stream. Each
     * stream has one or more shards.
     * </p>
     * <p>
     * You must specify the shard iterator type. For example, you can set the <code>ShardIteratorType</code> parameter
     * to read exactly from the position denoted by a specific sequence number by using the
     * <code>AT_SEQUENCE_NUMBER</code> shard iterator type. Alternatively, the parameter can read right after the
     * sequence number by using the <code>AFTER_SEQUENCE_NUMBER</code> shard iterator type, using sequence numbers
     * returned by earlier calls to <a>PutRecord</a>, <a>PutRecords</a>, <a>GetRecords</a>, or <a>DescribeStream</a>. In
     * the request, you can specify the shard iterator type <code>AT_TIMESTAMP</code> to read records from an arbitrary
     * point in time, <code>TRIM_HORIZON</code> to cause <code>ShardIterator</code> to point to the last untrimmed
     * record in the shard in the system (the oldest data record in the shard), or <code>LATEST</code> so that you
     * always read the most recent data in the shard.
     * </p>
     * <p>
     * When you read repeatedly from a stream, use a <a>GetShardIterator</a> request to get the first shard iterator for
     * use in your first <a>GetRecords</a> request and for subsequent reads use the shard iterator returned by the
     * <a>GetRecords</a> request in <code>NextShardIterator</code>. A new shard iterator is returned by every
     * <a>GetRecords</a> request in <code>NextShardIterator</code>, which you use in the <code>ShardIterator</code>
     * parameter of the next <a>GetRecords</a> request.
     * </p>
     * <p>
     * If a <a>GetShardIterator</a> request is made too often, you receive a
     * <code>ProvisionedThroughputExceededException</code>. For more information about throughput limits, see
     * <a>GetRecords</a>, and <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
     * <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * If the shard is closed, <a>GetShardIterator</a> returns a valid iterator for the last sequence number of the
     * shard. A shard can be closed as a result of using <a>SplitShard</a> or <a>MergeShards</a>.
     * </p>
     * <p>
     * <a>GetShardIterator</a> has a limit of five transactions per second per account per open shard.
     * </p>
     *
     * @param getShardIteratorRequest
     *        Represents the input for <code>GetShardIterator</code>.
     * @return Result of the GetShardIterator operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws ProvisionedThroughputExceededException
     *         The request rate for the stream is too high, or the requested data is too large for the available
     *         throughput. Reduce the frequency or size of your requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in
     *         the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential
     *         Backoff in AWS</a> in the <i>AWS General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.GetShardIterator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIterator" target="_top">AWS API
     *      Documentation</a>
     */
    default GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest)
            throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an Amazon Kinesis shard iterator. A shard iterator expires 5 minutes after it is returned to the requester.
     * </p>
     * <p>
     * A shard iterator specifies the shard position from which to start reading data records sequentially. The position
     * is specified using the sequence number of a data record in a shard. A sequence number is the identifier
     * associated with every record ingested in the stream, and is assigned when a record is put into the stream. Each
     * stream has one or more shards.
     * </p>
     * <p>
     * You must specify the shard iterator type. For example, you can set the <code>ShardIteratorType</code> parameter
     * to read exactly from the position denoted by a specific sequence number by using the
     * <code>AT_SEQUENCE_NUMBER</code> shard iterator type. Alternatively, the parameter can read right after the
     * sequence number by using the <code>AFTER_SEQUENCE_NUMBER</code> shard iterator type, using sequence numbers
     * returned by earlier calls to <a>PutRecord</a>, <a>PutRecords</a>, <a>GetRecords</a>, or <a>DescribeStream</a>. In
     * the request, you can specify the shard iterator type <code>AT_TIMESTAMP</code> to read records from an arbitrary
     * point in time, <code>TRIM_HORIZON</code> to cause <code>ShardIterator</code> to point to the last untrimmed
     * record in the shard in the system (the oldest data record in the shard), or <code>LATEST</code> so that you
     * always read the most recent data in the shard.
     * </p>
     * <p>
     * When you read repeatedly from a stream, use a <a>GetShardIterator</a> request to get the first shard iterator for
     * use in your first <a>GetRecords</a> request and for subsequent reads use the shard iterator returned by the
     * <a>GetRecords</a> request in <code>NextShardIterator</code>. A new shard iterator is returned by every
     * <a>GetRecords</a> request in <code>NextShardIterator</code>, which you use in the <code>ShardIterator</code>
     * parameter of the next <a>GetRecords</a> request.
     * </p>
     * <p>
     * If a <a>GetShardIterator</a> request is made too often, you receive a
     * <code>ProvisionedThroughputExceededException</code>. For more information about throughput limits, see
     * <a>GetRecords</a>, and <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
     * <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * If the shard is closed, <a>GetShardIterator</a> returns a valid iterator for the last sequence number of the
     * shard. A shard can be closed as a result of using <a>SplitShard</a> or <a>MergeShards</a>.
     * </p>
     * <p>
     * <a>GetShardIterator</a> has a limit of five transactions per second per account per open shard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetShardIteratorRequest.Builder} avoiding the need
     * to create one manually via {@link GetShardIteratorRequest#builder()}
     * </p>
     *
     * @param getShardIteratorRequest
     *        A {@link Consumer} that will call methods on {@link GetShardIteratorInput.Builder} to create a request.
     *        Represents the input for <code>GetShardIterator</code>.
     * @return Result of the GetShardIterator operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws ProvisionedThroughputExceededException
     *         The request rate for the stream is too high, or the requested data is too large for the available
     *         throughput. Reduce the frequency or size of your requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in
     *         the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential
     *         Backoff in AWS</a> in the <i>AWS General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.GetShardIterator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/GetShardIterator" target="_top">AWS API
     *      Documentation</a>
     */
    default GetShardIteratorResponse getShardIterator(Consumer<GetShardIteratorRequest.Builder> getShardIteratorRequest)
            throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        return getShardIterator(GetShardIteratorRequest.builder().applyMutation(getShardIteratorRequest).build());
    }

    /**
     * <p>
     * Increases the Kinesis data stream's retention period, which is the length of time data records are accessible
     * after they are added to the stream. The maximum value of a stream's retention period is 168 hours (7 days).
     * </p>
     * <p>
     * If you choose a longer stream retention period, this operation increases the time period during which records
     * that have not yet expired are accessible. However, it does not make previous, expired data (older than the
     * stream's previous retention period) accessible after the operation has been called. For example, if a stream's
     * retention period is set to 24 hours and is increased to 168 hours, any data that is older than 24 hours remains
     * inaccessible to consumer applications.
     * </p>
     *
     * @param increaseStreamRetentionPeriodRequest
     *        Represents the input for <a>IncreaseStreamRetentionPeriod</a>.
     * @return Result of the IncreaseStreamRetentionPeriod operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.IncreaseStreamRetentionPeriod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriod"
     *      target="_top">AWS API Documentation</a>
     */
    default IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriod(
            IncreaseStreamRetentionPeriodRequest increaseStreamRetentionPeriodRequest) throws ResourceInUseException,
            ResourceNotFoundException, LimitExceededException, InvalidArgumentException, AwsServiceException, SdkClientException,
            KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Increases the Kinesis data stream's retention period, which is the length of time data records are accessible
     * after they are added to the stream. The maximum value of a stream's retention period is 168 hours (7 days).
     * </p>
     * <p>
     * If you choose a longer stream retention period, this operation increases the time period during which records
     * that have not yet expired are accessible. However, it does not make previous, expired data (older than the
     * stream's previous retention period) accessible after the operation has been called. For example, if a stream's
     * retention period is set to 24 hours and is increased to 168 hours, any data that is older than 24 hours remains
     * inaccessible to consumer applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link IncreaseStreamRetentionPeriodRequest.Builder}
     * avoiding the need to create one manually via {@link IncreaseStreamRetentionPeriodRequest#builder()}
     * </p>
     *
     * @param increaseStreamRetentionPeriodRequest
     *        A {@link Consumer} that will call methods on {@link IncreaseStreamRetentionPeriodInput.Builder} to create
     *        a request. Represents the input for <a>IncreaseStreamRetentionPeriod</a>.
     * @return Result of the IncreaseStreamRetentionPeriod operation returned by the service.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.IncreaseStreamRetentionPeriod
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/IncreaseStreamRetentionPeriod"
     *      target="_top">AWS API Documentation</a>
     */
    default IncreaseStreamRetentionPeriodResponse increaseStreamRetentionPeriod(
            Consumer<IncreaseStreamRetentionPeriodRequest.Builder> increaseStreamRetentionPeriodRequest)
            throws ResourceInUseException, ResourceNotFoundException, LimitExceededException, InvalidArgumentException,
            AwsServiceException, SdkClientException, KinesisException {
        return increaseStreamRetentionPeriod(IncreaseStreamRetentionPeriodRequest.builder()
                .applyMutation(increaseStreamRetentionPeriodRequest).build());
    }

    /**
     * <p>
     * Lists the shards in a stream and provides information about each shard. This operation has a limit of 100
     * transactions per second per data stream.
     * </p>
     * <important>
     * <p>
     * This API is a new operation that is used by the Amazon Kinesis Client Library (KCL). If you have a fine-grained
     * IAM policy that only allows specific operations, you must update your policy to allow calls to this API. For more
     * information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/controlling-access.html">Controlling
     * Access to Amazon Kinesis Data Streams Resources Using IAM</a>.
     * </p>
     * </important>
     *
     * @param listShardsRequest
     * @return Result of the ListShards operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ExpiredNextTokenException
     *         The pagination token passed to the operation is expired.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListShards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListShards" target="_top">AWS API
     *      Documentation</a>
     */
    default ListShardsResponse listShards(ListShardsRequest listShardsRequest) throws ResourceNotFoundException,
            InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the shards in a stream and provides information about each shard. This operation has a limit of 100
     * transactions per second per data stream.
     * </p>
     * <important>
     * <p>
     * This API is a new operation that is used by the Amazon Kinesis Client Library (KCL). If you have a fine-grained
     * IAM policy that only allows specific operations, you must update your policy to allow calls to this API. For more
     * information, see <a href="https://docs.aws.amazon.com/streams/latest/dev/controlling-access.html">Controlling
     * Access to Amazon Kinesis Data Streams Resources Using IAM</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListShardsRequest.Builder} avoiding the need to
     * create one manually via {@link ListShardsRequest#builder()}
     * </p>
     *
     * @param listShardsRequest
     *        A {@link Consumer} that will call methods on {@link ListShardsInput.Builder} to create a request.
     * @return Result of the ListShards operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ExpiredNextTokenException
     *         The pagination token passed to the operation is expired.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListShards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListShards" target="_top">AWS API
     *      Documentation</a>
     */
    default ListShardsResponse listShards(Consumer<ListShardsRequest.Builder> listShardsRequest)
            throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException,
            ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        return listShards(ListShardsRequest.builder().applyMutation(listShardsRequest).build());
    }

    /**
     * <p>
     * Lists the consumers registered to receive data from a stream using enhanced fan-out, and provides information
     * about each consumer.
     * </p>
     * <p>
     * This operation has a limit of 5 transactions per second per stream.
     * </p>
     *
     * @param listStreamConsumersRequest
     * @return Result of the ListStreamConsumers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ExpiredNextTokenException
     *         The pagination token passed to the operation is expired.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListStreamConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStreamConsumersResponse listStreamConsumers(ListStreamConsumersRequest listStreamConsumersRequest)
            throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException,
            ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the consumers registered to receive data from a stream using enhanced fan-out, and provides information
     * about each consumer.
     * </p>
     * <p>
     * This operation has a limit of 5 transactions per second per stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamConsumersRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamConsumersRequest#builder()}
     * </p>
     *
     * @param listStreamConsumersRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamConsumersInput.Builder} to create a request.
     * @return Result of the ListStreamConsumers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ExpiredNextTokenException
     *         The pagination token passed to the operation is expired.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListStreamConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStreamConsumersResponse listStreamConsumers(
            Consumer<ListStreamConsumersRequest.Builder> listStreamConsumersRequest) throws ResourceNotFoundException,
            InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException,
            AwsServiceException, SdkClientException, KinesisException {
        return listStreamConsumers(ListStreamConsumersRequest.builder().applyMutation(listStreamConsumersRequest).build());
    }

    /**
     * <p>
     * Lists the consumers registered to receive data from a stream using enhanced fan-out, and provides information
     * about each consumer.
     * </p>
     * <p>
     * This operation has a limit of 5 transactions per second per stream.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamConsumers(software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable responses = client.listStreamConsumersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable responses = client
     *             .listStreamConsumersPaginator(request);
     *     for (software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable responses = client.listStreamConsumersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamConsumers(software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStreamConsumersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ExpiredNextTokenException
     *         The pagination token passed to the operation is expired.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListStreamConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStreamConsumersIterable listStreamConsumersPaginator(ListStreamConsumersRequest listStreamConsumersRequest)
            throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, ExpiredNextTokenException,
            ResourceInUseException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the consumers registered to receive data from a stream using enhanced fan-out, and provides information
     * about each consumer.
     * </p>
     * <p>
     * This operation has a limit of 5 transactions per second per stream.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStreamConsumers(software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable responses = client.listStreamConsumersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable responses = client
     *             .listStreamConsumersPaginator(request);
     *     for (software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.kinesis.paginators.ListStreamConsumersIterable responses = client.listStreamConsumersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStreamConsumers(software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamConsumersRequest.Builder} avoiding the
     * need to create one manually via {@link ListStreamConsumersRequest#builder()}
     * </p>
     *
     * @param listStreamConsumersRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamConsumersInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ExpiredNextTokenException
     *         The pagination token passed to the operation is expired.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListStreamConsumers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreamConsumers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStreamConsumersIterable listStreamConsumersPaginator(
            Consumer<ListStreamConsumersRequest.Builder> listStreamConsumersRequest) throws ResourceNotFoundException,
            InvalidArgumentException, LimitExceededException, ExpiredNextTokenException, ResourceInUseException,
            AwsServiceException, SdkClientException, KinesisException {
        return listStreamConsumersPaginator(ListStreamConsumersRequest.builder().applyMutation(listStreamConsumersRequest)
                .build());
    }

    /**
     * <p>
     * Lists your Kinesis data streams.
     * </p>
     * <p>
     * The number of streams may be too large to return from a single call to <code>ListStreams</code>. You can limit
     * the number of returned streams using the <code>Limit</code> parameter. If you do not specify a value for the
     * <code>Limit</code> parameter, Kinesis Data Streams uses the default limit, which is currently 10.
     * </p>
     * <p>
     * You can detect if there are more streams available to list by using the <code>HasMoreStreams</code> flag from the
     * returned output. If there are more streams available, you can request more streams by using the name of the last
     * stream returned by the <code>ListStreams</code> request in the <code>ExclusiveStartStreamName</code> parameter in
     * a subsequent request to <code>ListStreams</code>. The group of stream names returned by the subsequent request is
     * then added to the list. You can continue this process until all the stream names have been collected in the list.
     * </p>
     * <p>
     * <a>ListStreams</a> has a limit of five transactions per second per account.
     * </p>
     *
     * @return Result of the ListStreams operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListStreams
     * @see #listStreams(ListStreamsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamsResponse listStreams() throws LimitExceededException, AwsServiceException, SdkClientException,
            KinesisException {
        return listStreams(ListStreamsRequest.builder().build());
    }

    /**
     * <p>
     * Lists your Kinesis data streams.
     * </p>
     * <p>
     * The number of streams may be too large to return from a single call to <code>ListStreams</code>. You can limit
     * the number of returned streams using the <code>Limit</code> parameter. If you do not specify a value for the
     * <code>Limit</code> parameter, Kinesis Data Streams uses the default limit, which is currently 10.
     * </p>
     * <p>
     * You can detect if there are more streams available to list by using the <code>HasMoreStreams</code> flag from the
     * returned output. If there are more streams available, you can request more streams by using the name of the last
     * stream returned by the <code>ListStreams</code> request in the <code>ExclusiveStartStreamName</code> parameter in
     * a subsequent request to <code>ListStreams</code>. The group of stream names returned by the subsequent request is
     * then added to the list. You can continue this process until all the stream names have been collected in the list.
     * </p>
     * <p>
     * <a>ListStreams</a> has a limit of five transactions per second per account.
     * </p>
     *
     * @param listStreamsRequest
     *        Represents the input for <code>ListStreams</code>.
     * @return Result of the ListStreams operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws LimitExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your Kinesis data streams.
     * </p>
     * <p>
     * The number of streams may be too large to return from a single call to <code>ListStreams</code>. You can limit
     * the number of returned streams using the <code>Limit</code> parameter. If you do not specify a value for the
     * <code>Limit</code> parameter, Kinesis Data Streams uses the default limit, which is currently 10.
     * </p>
     * <p>
     * You can detect if there are more streams available to list by using the <code>HasMoreStreams</code> flag from the
     * returned output. If there are more streams available, you can request more streams by using the name of the last
     * stream returned by the <code>ListStreams</code> request in the <code>ExclusiveStartStreamName</code> parameter in
     * a subsequent request to <code>ListStreams</code>. The group of stream names returned by the subsequent request is
     * then added to the list. You can continue this process until all the stream names have been collected in the list.
     * </p>
     * <p>
     * <a>ListStreams</a> has a limit of five transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStreamsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStreamsRequest#builder()}
     * </p>
     *
     * @param listStreamsRequest
     *        A {@link Consumer} that will call methods on {@link ListStreamsInput.Builder} to create a request.
     *        Represents the input for <code>ListStreams</code>.
     * @return Result of the ListStreams operation returned by the service.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListStreams" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStreamsResponse listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest)
            throws LimitExceededException, AwsServiceException, SdkClientException, KinesisException {
        return listStreams(ListStreamsRequest.builder().applyMutation(listStreamsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for the specified Kinesis data stream. This operation has a limit of five transactions per second
     * per account.
     * </p>
     *
     * @param listTagsForStreamRequest
     *        Represents the input for <code>ListTagsForStream</code>.
     * @return Result of the ListTagsForStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListTagsForStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStream" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForStreamResponse listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest)
            throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, AwsServiceException,
            SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for the specified Kinesis data stream. This operation has a limit of five transactions per second
     * per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForStreamRequest.Builder} avoiding the need
     * to create one manually via {@link ListTagsForStreamRequest#builder()}
     * </p>
     *
     * @param listTagsForStreamRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForStreamInput.Builder} to create a request.
     *        Represents the input for <code>ListTagsForStream</code>.
     * @return Result of the ListTagsForStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.ListTagsForStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/ListTagsForStream" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForStreamResponse listTagsForStream(Consumer<ListTagsForStreamRequest.Builder> listTagsForStreamRequest)
            throws ResourceNotFoundException, InvalidArgumentException, LimitExceededException, AwsServiceException,
            SdkClientException, KinesisException {
        return listTagsForStream(ListTagsForStreamRequest.builder().applyMutation(listTagsForStreamRequest).build());
    }

    /**
     * <p>
     * Merges two adjacent shards in a Kinesis data stream and combines them into a single shard to reduce the stream's
     * capacity to ingest and transport data. Two shards are considered adjacent if the union of the hash key ranges for
     * the two shards form a contiguous set with no gaps. For example, if you have two shards, one with a hash key range
     * of 276...381 and the other with a hash key range of 382...454, then you could merge these two shards into a
     * single shard that would have a hash key range of 276...454. After the merge, the single child shard receives data
     * for all hash key values covered by the two parent shards.
     * </p>
     * <p>
     * <code>MergeShards</code> is called when there is a need to reduce the overall capacity of a stream because of
     * excess capacity that is not being used. You must specify the shard to be merged and the adjacent shard for a
     * stream. For more information about merging shards, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-merge.html">Merge Two
     * Shards</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * If the stream is in the <code>ACTIVE</code> state, you can call <code>MergeShards</code>. If a stream is in the
     * <code>CREATING</code>, <code>UPDATING</code>, or <code>DELETING</code> state, <code>MergeShards</code> returns a
     * <code>ResourceInUseException</code>. If the specified stream does not exist, <code>MergeShards</code> returns a
     * <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * You can use <a>DescribeStream</a> to check the state of the stream, which is returned in
     * <code>StreamStatus</code>.
     * </p>
     * <p>
     * <code>MergeShards</code> is an asynchronous operation. Upon receiving a <code>MergeShards</code> request, Amazon
     * Kinesis Data Streams immediately returns a response and sets the <code>StreamStatus</code> to
     * <code>UPDATING</code>. After the operation is completed, Kinesis Data Streams sets the <code>StreamStatus</code>
     * to <code>ACTIVE</code>. Read and write operations continue to work while the stream is in the
     * <code>UPDATING</code> state.
     * </p>
     * <p>
     * You use <a>DescribeStream</a> to determine the shard IDs that are specified in the <code>MergeShards</code>
     * request.
     * </p>
     * <p>
     * If you try to operate on too many streams in parallel using <a>CreateStream</a>, <a>DeleteStream</a>,
     * <code>MergeShards</code>, or <a>SplitShard</a>, you receive a <code>LimitExceededException</code>.
     * </p>
     * <p>
     * <code>MergeShards</code> has a limit of five transactions per second per account.
     * </p>
     *
     * @param mergeShardsRequest
     *        Represents the input for <code>MergeShards</code>.
     * @return Result of the MergeShards operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.MergeShards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShards" target="_top">AWS API
     *      Documentation</a>
     */
    default MergeShardsResponse mergeShards(MergeShardsRequest mergeShardsRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException,
            KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Merges two adjacent shards in a Kinesis data stream and combines them into a single shard to reduce the stream's
     * capacity to ingest and transport data. Two shards are considered adjacent if the union of the hash key ranges for
     * the two shards form a contiguous set with no gaps. For example, if you have two shards, one with a hash key range
     * of 276...381 and the other with a hash key range of 382...454, then you could merge these two shards into a
     * single shard that would have a hash key range of 276...454. After the merge, the single child shard receives data
     * for all hash key values covered by the two parent shards.
     * </p>
     * <p>
     * <code>MergeShards</code> is called when there is a need to reduce the overall capacity of a stream because of
     * excess capacity that is not being used. You must specify the shard to be merged and the adjacent shard for a
     * stream. For more information about merging shards, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-merge.html">Merge Two
     * Shards</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * If the stream is in the <code>ACTIVE</code> state, you can call <code>MergeShards</code>. If a stream is in the
     * <code>CREATING</code>, <code>UPDATING</code>, or <code>DELETING</code> state, <code>MergeShards</code> returns a
     * <code>ResourceInUseException</code>. If the specified stream does not exist, <code>MergeShards</code> returns a
     * <code>ResourceNotFoundException</code>.
     * </p>
     * <p>
     * You can use <a>DescribeStream</a> to check the state of the stream, which is returned in
     * <code>StreamStatus</code>.
     * </p>
     * <p>
     * <code>MergeShards</code> is an asynchronous operation. Upon receiving a <code>MergeShards</code> request, Amazon
     * Kinesis Data Streams immediately returns a response and sets the <code>StreamStatus</code> to
     * <code>UPDATING</code>. After the operation is completed, Kinesis Data Streams sets the <code>StreamStatus</code>
     * to <code>ACTIVE</code>. Read and write operations continue to work while the stream is in the
     * <code>UPDATING</code> state.
     * </p>
     * <p>
     * You use <a>DescribeStream</a> to determine the shard IDs that are specified in the <code>MergeShards</code>
     * request.
     * </p>
     * <p>
     * If you try to operate on too many streams in parallel using <a>CreateStream</a>, <a>DeleteStream</a>,
     * <code>MergeShards</code>, or <a>SplitShard</a>, you receive a <code>LimitExceededException</code>.
     * </p>
     * <p>
     * <code>MergeShards</code> has a limit of five transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergeShardsRequest.Builder} avoiding the need to
     * create one manually via {@link MergeShardsRequest#builder()}
     * </p>
     *
     * @param mergeShardsRequest
     *        A {@link Consumer} that will call methods on {@link MergeShardsInput.Builder} to create a request.
     *        Represents the input for <code>MergeShards</code>.
     * @return Result of the MergeShards operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.MergeShards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/MergeShards" target="_top">AWS API
     *      Documentation</a>
     */
    default MergeShardsResponse mergeShards(Consumer<MergeShardsRequest.Builder> mergeShardsRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        return mergeShards(MergeShardsRequest.builder().applyMutation(mergeShardsRequest).build());
    }

    /**
     * <p>
     * Writes a single data record into an Amazon Kinesis data stream. Call <code>PutRecord</code> to send data into the
     * stream for real-time ingestion and subsequent processing, one record at a time. Each shard can support writes up
     * to 1,000 records per second, up to a maximum data write total of 1 MiB per second.
     * </p>
     * <p>
     * You must specify the name of the stream that captures, stores, and transports the data; a partition key; and the
     * data blob itself.
     * </p>
     * <p>
     * The data blob can be any type of data; for example, a segment from a log file, geographic/location data, website
     * clickstream data, and so on.
     * </p>
     * <p>
     * The partition key is used by Kinesis Data Streams to distribute data across shards. Kinesis Data Streams
     * segregates the data records that belong to a stream into multiple shards, using the partition key associated with
     * each data record to determine the shard to which a given data record belongs.
     * </p>
     * <p>
     * Partition keys are Unicode strings, with a maximum length limit of 256 characters for each key. An MD5 hash
     * function is used to map partition keys to 128-bit integer values and to map associated data records to shards
     * using the hash key ranges of the shards. You can override hashing the partition key to determine the shard by
     * explicitly specifying a hash value using the <code>ExplicitHashKey</code> parameter. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream"
     * >Adding Data to a Stream</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * <code>PutRecord</code> returns the shard ID of where the data record was placed and the sequence number that was
     * assigned to the data record.
     * </p>
     * <p>
     * Sequence numbers increase over time and are specific to a shard within a stream, not across all shards within a
     * stream. To guarantee strictly increasing ordering, write serially to a shard and use the
     * <code>SequenceNumberForOrdering</code> parameter. For more information, see <a href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream"
     * >Adding Data to a Stream</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * After you write a record to a stream, you cannot modify that record or its order within the stream.
     * </p>
     * </important>
     * <p>
     * If a <code>PutRecord</code> request cannot be processed because of insufficient provisioned throughput on the
     * shard involved in the request, <code>PutRecord</code> throws <code>ProvisionedThroughputExceededException</code>.
     * </p>
     * <p>
     * By default, data records are accessible for 24 hours from the time that they are added to a stream. You can use
     * <a>IncreaseStreamRetentionPeriod</a> or <a>DecreaseStreamRetentionPeriod</a> to modify this retention period.
     * </p>
     *
     * @param putRecordRequest
     *        Represents the input for <code>PutRecord</code>.
     * @return Result of the PutRecord operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws ProvisionedThroughputExceededException
     *         The request rate for the stream is too high, or the requested data is too large for the available
     *         throughput. Reduce the frequency or size of your requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in
     *         the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential
     *         Backoff in AWS</a> in the <i>AWS General Reference</i>.
     * @throws KmsDisabledException
     *         The request was rejected because the specified customer master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The request was rejected because the state of the specified resource isn't valid for this request. For
     *         more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How
     *         Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that you don't have access to.
     * @throws KmsNotFoundException
     *         The request was rejected because the specified entity or resource can't be found.
     * @throws KmsOptInRequiredException
     *         The AWS access key ID needs a subscription for the service.
     * @throws KmsThrottlingException
     *         The request was denied due to request throttling. For more information about throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.PutRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecord" target="_top">AWS API
     *      Documentation</a>
     */
    default PutRecordResponse putRecord(PutRecordRequest putRecordRequest) throws ResourceNotFoundException,
            InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException,
            KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Writes a single data record into an Amazon Kinesis data stream. Call <code>PutRecord</code> to send data into the
     * stream for real-time ingestion and subsequent processing, one record at a time. Each shard can support writes up
     * to 1,000 records per second, up to a maximum data write total of 1 MiB per second.
     * </p>
     * <p>
     * You must specify the name of the stream that captures, stores, and transports the data; a partition key; and the
     * data blob itself.
     * </p>
     * <p>
     * The data blob can be any type of data; for example, a segment from a log file, geographic/location data, website
     * clickstream data, and so on.
     * </p>
     * <p>
     * The partition key is used by Kinesis Data Streams to distribute data across shards. Kinesis Data Streams
     * segregates the data records that belong to a stream into multiple shards, using the partition key associated with
     * each data record to determine the shard to which a given data record belongs.
     * </p>
     * <p>
     * Partition keys are Unicode strings, with a maximum length limit of 256 characters for each key. An MD5 hash
     * function is used to map partition keys to 128-bit integer values and to map associated data records to shards
     * using the hash key ranges of the shards. You can override hashing the partition key to determine the shard by
     * explicitly specifying a hash value using the <code>ExplicitHashKey</code> parameter. For more information, see <a
     * href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream"
     * >Adding Data to a Stream</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * <code>PutRecord</code> returns the shard ID of where the data record was placed and the sequence number that was
     * assigned to the data record.
     * </p>
     * <p>
     * Sequence numbers increase over time and are specific to a shard within a stream, not across all shards within a
     * stream. To guarantee strictly increasing ordering, write serially to a shard and use the
     * <code>SequenceNumberForOrdering</code> parameter. For more information, see <a href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream"
     * >Adding Data to a Stream</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * After you write a record to a stream, you cannot modify that record or its order within the stream.
     * </p>
     * </important>
     * <p>
     * If a <code>PutRecord</code> request cannot be processed because of insufficient provisioned throughput on the
     * shard involved in the request, <code>PutRecord</code> throws <code>ProvisionedThroughputExceededException</code>.
     * </p>
     * <p>
     * By default, data records are accessible for 24 hours from the time that they are added to a stream. You can use
     * <a>IncreaseStreamRetentionPeriod</a> or <a>DecreaseStreamRetentionPeriod</a> to modify this retention period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRecordRequest.Builder} avoiding the need to
     * create one manually via {@link PutRecordRequest#builder()}
     * </p>
     *
     * @param putRecordRequest
     *        A {@link Consumer} that will call methods on {@link PutRecordInput.Builder} to create a request.
     *        Represents the input for <code>PutRecord</code>.
     * @return Result of the PutRecord operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws ProvisionedThroughputExceededException
     *         The request rate for the stream is too high, or the requested data is too large for the available
     *         throughput. Reduce the frequency or size of your requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in
     *         the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential
     *         Backoff in AWS</a> in the <i>AWS General Reference</i>.
     * @throws KmsDisabledException
     *         The request was rejected because the specified customer master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The request was rejected because the state of the specified resource isn't valid for this request. For
     *         more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How
     *         Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that you don't have access to.
     * @throws KmsNotFoundException
     *         The request was rejected because the specified entity or resource can't be found.
     * @throws KmsOptInRequiredException
     *         The AWS access key ID needs a subscription for the service.
     * @throws KmsThrottlingException
     *         The request was denied due to request throttling. For more information about throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.PutRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecord" target="_top">AWS API
     *      Documentation</a>
     */
    default PutRecordResponse putRecord(Consumer<PutRecordRequest.Builder> putRecordRequest) throws ResourceNotFoundException,
            InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException,
            KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException,
            AwsServiceException, SdkClientException, KinesisException {
        return putRecord(PutRecordRequest.builder().applyMutation(putRecordRequest).build());
    }

    /**
     * <p>
     * Writes multiple data records into a Kinesis data stream in a single call (also referred to as a
     * <code>PutRecords</code> request). Use this operation to send data into the stream for data ingestion and
     * processing.
     * </p>
     * <p>
     * Each <code>PutRecords</code> request can support up to 500 records. Each record in the request can be as large as
     * 1 MiB, up to a limit of 5 MiB for the entire request, including partition keys. Each shard can support writes up
     * to 1,000 records per second, up to a maximum data write total of 1 MiB per second.
     * </p>
     * <p>
     * You must specify the name of the stream that captures, stores, and transports the data; and an array of request
     * <code>Records</code>, with each record in the array requiring a partition key and data blob. The record size
     * limit applies to the total size of the partition key and data blob.
     * </p>
     * <p>
     * The data blob can be any type of data; for example, a segment from a log file, geographic/location data, website
     * clickstream data, and so on.
     * </p>
     * <p>
     * The partition key is used by Kinesis Data Streams as input to a hash function that maps the partition key and
     * associated data to a specific shard. An MD5 hash function is used to map partition keys to 128-bit integer values
     * and to map associated data records to shards. As a result of this hashing mechanism, all data records with the
     * same partition key map to the same shard within the stream. For more information, see <a href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream"
     * >Adding Data to a Stream</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * Each record in the <code>Records</code> array may include an optional parameter, <code>ExplicitHashKey</code>,
     * which overrides the partition key to shard mapping. This parameter allows a data producer to determine explicitly
     * the shard where the record is stored. For more information, see <a href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-putrecords"
     * >Adding Multiple Records with PutRecords</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * The <code>PutRecords</code> response includes an array of response <code>Records</code>. Each record in the
     * response array directly correlates with a record in the request array using natural ordering, from the top to the
     * bottom of the request and response. The response <code>Records</code> array always includes the same number of
     * records as the request array.
     * </p>
     * <p>
     * The response <code>Records</code> array includes both successfully and unsuccessfully processed records. Kinesis
     * Data Streams attempts to process all records in each <code>PutRecords</code> request. A single record failure
     * does not stop the processing of subsequent records. As a result, PutRecords doesn't guarantee the ordering of
     * records. If you need to read records in the same order they are written to the stream, use <a>PutRecord</a>
     * instead of <code>PutRecords</code>, and write to the same shard.
     * </p>
     * <p>
     * A successfully processed record includes <code>ShardId</code> and <code>SequenceNumber</code> values. The
     * <code>ShardId</code> parameter identifies the shard in the stream where the record is stored. The
     * <code>SequenceNumber</code> parameter is an identifier assigned to the put record, unique to all records in the
     * stream.
     * </p>
     * <p>
     * An unsuccessfully processed record includes <code>ErrorCode</code> and <code>ErrorMessage</code> values.
     * <code>ErrorCode</code> reflects the type of error and can be one of the following values:
     * <code>ProvisionedThroughputExceededException</code> or <code>InternalFailure</code>. <code>ErrorMessage</code>
     * provides more detailed information about the <code>ProvisionedThroughputExceededException</code> exception
     * including the account ID, stream name, and shard ID of the record that was throttled. For more information about
     * partially successful responses, see <a href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-add-data-to-stream.html#kinesis-using-sdk-java-putrecords"
     * >Adding Multiple Records with PutRecords</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * After you write a record to a stream, you cannot modify that record or its order within the stream.
     * </p>
     * </important>
     * <p>
     * By default, data records are accessible for 24 hours from the time that they are added to a stream. You can use
     * <a>IncreaseStreamRetentionPeriod</a> or <a>DecreaseStreamRetentionPeriod</a> to modify this retention period.
     * </p>
     *
     * @param putRecordsRequest
     *        A <code>PutRecords</code> request.
     * @return Result of the PutRecords operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws ProvisionedThroughputExceededException
     *         The request rate for the stream is too high, or the requested data is too large for the available
     *         throughput. Reduce the frequency or size of your requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in
     *         the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential
     *         Backoff in AWS</a> in the <i>AWS General Reference</i>.
     * @throws KmsDisabledException
     *         The request was rejected because the specified customer master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The request was rejected because the state of the specified resource isn't valid for this request. For
     *         more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How
     *         Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that you don't have access to.
     * @throws KmsNotFoundException
     *         The request was rejected because the specified entity or resource can't be found.
     * @throws KmsOptInRequiredException
     *         The AWS access key ID needs a subscription for the service.
     * @throws KmsThrottlingException
     *         The request was denied due to request throttling. For more information about throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.PutRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default PutRecordsResponse putRecords(PutRecordsRequest putRecordsRequest) throws ResourceNotFoundException,
            InvalidArgumentException, ProvisionedThroughputExceededException, KmsDisabledException, KmsInvalidStateException,
            KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException, KmsThrottlingException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Writes multiple data records into a Kinesis data stream in a single call (also referred to as a
     * <code>PutRecords</code> request). Use this operation to send data into the stream for data ingestion and
     * processing.
     * </p>
     * <p>
     * Each <code>PutRecords</code> request can support up to 500 records. Each record in the request can be as large as
     * 1 MiB, up to a limit of 5 MiB for the entire request, including partition keys. Each shard can support writes up
     * to 1,000 records per second, up to a maximum data write total of 1 MiB per second.
     * </p>
     * <p>
     * You must specify the name of the stream that captures, stores, and transports the data; and an array of request
     * <code>Records</code>, with each record in the array requiring a partition key and data blob. The record size
     * limit applies to the total size of the partition key and data blob.
     * </p>
     * <p>
     * The data blob can be any type of data; for example, a segment from a log file, geographic/location data, website
     * clickstream data, and so on.
     * </p>
     * <p>
     * The partition key is used by Kinesis Data Streams as input to a hash function that maps the partition key and
     * associated data to a specific shard. An MD5 hash function is used to map partition keys to 128-bit integer values
     * and to map associated data records to shards. As a result of this hashing mechanism, all data records with the
     * same partition key map to the same shard within the stream. For more information, see <a href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-add-data-to-stream"
     * >Adding Data to a Stream</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * Each record in the <code>Records</code> array may include an optional parameter, <code>ExplicitHashKey</code>,
     * which overrides the partition key to shard mapping. This parameter allows a data producer to determine explicitly
     * the shard where the record is stored. For more information, see <a href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/developing-producers-with-sdk.html#kinesis-using-sdk-java-putrecords"
     * >Adding Multiple Records with PutRecords</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * The <code>PutRecords</code> response includes an array of response <code>Records</code>. Each record in the
     * response array directly correlates with a record in the request array using natural ordering, from the top to the
     * bottom of the request and response. The response <code>Records</code> array always includes the same number of
     * records as the request array.
     * </p>
     * <p>
     * The response <code>Records</code> array includes both successfully and unsuccessfully processed records. Kinesis
     * Data Streams attempts to process all records in each <code>PutRecords</code> request. A single record failure
     * does not stop the processing of subsequent records. As a result, PutRecords doesn't guarantee the ordering of
     * records. If you need to read records in the same order they are written to the stream, use <a>PutRecord</a>
     * instead of <code>PutRecords</code>, and write to the same shard.
     * </p>
     * <p>
     * A successfully processed record includes <code>ShardId</code> and <code>SequenceNumber</code> values. The
     * <code>ShardId</code> parameter identifies the shard in the stream where the record is stored. The
     * <code>SequenceNumber</code> parameter is an identifier assigned to the put record, unique to all records in the
     * stream.
     * </p>
     * <p>
     * An unsuccessfully processed record includes <code>ErrorCode</code> and <code>ErrorMessage</code> values.
     * <code>ErrorCode</code> reflects the type of error and can be one of the following values:
     * <code>ProvisionedThroughputExceededException</code> or <code>InternalFailure</code>. <code>ErrorMessage</code>
     * provides more detailed information about the <code>ProvisionedThroughputExceededException</code> exception
     * including the account ID, stream name, and shard ID of the record that was throttled. For more information about
     * partially successful responses, see <a href=
     * "https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-add-data-to-stream.html#kinesis-using-sdk-java-putrecords"
     * >Adding Multiple Records with PutRecords</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <important>
     * <p>
     * After you write a record to a stream, you cannot modify that record or its order within the stream.
     * </p>
     * </important>
     * <p>
     * By default, data records are accessible for 24 hours from the time that they are added to a stream. You can use
     * <a>IncreaseStreamRetentionPeriod</a> or <a>DecreaseStreamRetentionPeriod</a> to modify this retention period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutRecordsRequest.Builder} avoiding the need to
     * create one manually via {@link PutRecordsRequest#builder()}
     * </p>
     *
     * @param putRecordsRequest
     *        A {@link Consumer} that will call methods on {@link PutRecordsInput.Builder} to create a request. A
     *        <code>PutRecords</code> request.
     * @return Result of the PutRecords operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws ProvisionedThroughputExceededException
     *         The request rate for the stream is too high, or the requested data is too large for the available
     *         throughput. Reduce the frequency or size of your requests. For more information, see <a
     *         href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in
     *         the <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and Exponential
     *         Backoff in AWS</a> in the <i>AWS General Reference</i>.
     * @throws KmsDisabledException
     *         The request was rejected because the specified customer master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The request was rejected because the state of the specified resource isn't valid for this request. For
     *         more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How
     *         Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that you don't have access to.
     * @throws KmsNotFoundException
     *         The request was rejected because the specified entity or resource can't be found.
     * @throws KmsOptInRequiredException
     *         The AWS access key ID needs a subscription for the service.
     * @throws KmsThrottlingException
     *         The request was denied due to request throttling. For more information about throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.PutRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/PutRecords" target="_top">AWS API
     *      Documentation</a>
     */
    default PutRecordsResponse putRecords(Consumer<PutRecordsRequest.Builder> putRecordsRequest)
            throws ResourceNotFoundException, InvalidArgumentException, ProvisionedThroughputExceededException,
            KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException,
            KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        return putRecords(PutRecordsRequest.builder().applyMutation(putRecordsRequest).build());
    }

    /**
     * <p>
     * Registers a consumer with a Kinesis data stream. When you use this operation, the consumer you register can then
     * call <a>SubscribeToShard</a> to receive data from the stream using enhanced fan-out, at a rate of up to 2 MiB per
     * second for every shard you subscribe to. This rate is unaffected by the total number of consumers that read from
     * the same stream.
     * </p>
     * <p>
     * You can register up to 20 consumers per stream. A given consumer can only be registered with one stream at a
     * time.
     * </p>
     * <p>
     * For an example of how to use this operations, see <a
     * href="/streams/latest/dev/building-enhanced-consumers-api.html">Enhanced Fan-Out Using the Kinesis Data Streams
     * API</a>.
     * </p>
     * <p>
     * The use of this operation has a limit of five transactions per second per account. Also, only 5 consumers can be
     * created simultaneously. In other words, you cannot have more than 5 consumers in a <code>CREATING</code> status
     * at the same time. Registering a 6th consumer while there are 5 in a <code>CREATING</code> status results in a
     * <code>LimitExceededException</code>.
     * </p>
     *
     * @param registerStreamConsumerRequest
     * @return Result of the RegisterStreamConsumer operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.RegisterStreamConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RegisterStreamConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterStreamConsumerResponse registerStreamConsumer(RegisterStreamConsumerRequest registerStreamConsumerRequest)
            throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a consumer with a Kinesis data stream. When you use this operation, the consumer you register can then
     * call <a>SubscribeToShard</a> to receive data from the stream using enhanced fan-out, at a rate of up to 2 MiB per
     * second for every shard you subscribe to. This rate is unaffected by the total number of consumers that read from
     * the same stream.
     * </p>
     * <p>
     * You can register up to 20 consumers per stream. A given consumer can only be registered with one stream at a
     * time.
     * </p>
     * <p>
     * For an example of how to use this operations, see <a
     * href="/streams/latest/dev/building-enhanced-consumers-api.html">Enhanced Fan-Out Using the Kinesis Data Streams
     * API</a>.
     * </p>
     * <p>
     * The use of this operation has a limit of five transactions per second per account. Also, only 5 consumers can be
     * created simultaneously. In other words, you cannot have more than 5 consumers in a <code>CREATING</code> status
     * at the same time. Registering a 6th consumer while there are 5 in a <code>CREATING</code> status results in a
     * <code>LimitExceededException</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterStreamConsumerRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterStreamConsumerRequest#builder()}
     * </p>
     *
     * @param registerStreamConsumerRequest
     *        A {@link Consumer} that will call methods on {@link RegisterStreamConsumerInput.Builder} to create a
     *        request.
     * @return Result of the RegisterStreamConsumer operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.RegisterStreamConsumer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RegisterStreamConsumer"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterStreamConsumerResponse registerStreamConsumer(
            Consumer<RegisterStreamConsumerRequest.Builder> registerStreamConsumerRequest) throws InvalidArgumentException,
            LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            KinesisException {
        return registerStreamConsumer(RegisterStreamConsumerRequest.builder().applyMutation(registerStreamConsumerRequest)
                .build());
    }

    /**
     * <p>
     * Removes tags from the specified Kinesis data stream. Removed tags are deleted and cannot be recovered after this
     * operation successfully completes.
     * </p>
     * <p>
     * If you specify a tag that does not exist, it is ignored.
     * </p>
     * <p>
     * <a>RemoveTagsFromStream</a> has a limit of five transactions per second per account.
     * </p>
     *
     * @param removeTagsFromStreamRequest
     *        Represents the input for <code>RemoveTagsFromStream</code>.
     * @return Result of the RemoveTagsFromStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.RemoveTagsFromStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStream" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsFromStreamResponse removeTagsFromStream(RemoveTagsFromStreamRequest removeTagsFromStreamRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified Kinesis data stream. Removed tags are deleted and cannot be recovered after this
     * operation successfully completes.
     * </p>
     * <p>
     * If you specify a tag that does not exist, it is ignored.
     * </p>
     * <p>
     * <a>RemoveTagsFromStream</a> has a limit of five transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTagsFromStreamRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTagsFromStreamRequest#builder()}
     * </p>
     *
     * @param removeTagsFromStreamRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTagsFromStreamInput.Builder} to create a
     *        request. Represents the input for <code>RemoveTagsFromStream</code>.
     * @return Result of the RemoveTagsFromStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.RemoveTagsFromStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/RemoveTagsFromStream" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveTagsFromStreamResponse removeTagsFromStream(
            Consumer<RemoveTagsFromStreamRequest.Builder> removeTagsFromStreamRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException,
            KinesisException {
        return removeTagsFromStream(RemoveTagsFromStreamRequest.builder().applyMutation(removeTagsFromStreamRequest).build());
    }

    /**
     * <p>
     * Splits a shard into two new shards in the Kinesis data stream, to increase the stream's capacity to ingest and
     * transport data. <code>SplitShard</code> is called when there is a need to increase the overall capacity of a
     * stream because of an expected increase in the volume of data records being ingested.
     * </p>
     * <p>
     * You can also use <code>SplitShard</code> when a shard appears to be approaching its maximum utilization; for
     * example, the producers sending data into the specific shard are suddenly sending more than previously
     * anticipated. You can also call <code>SplitShard</code> to increase stream capacity, so that more Kinesis Data
     * Streams applications can simultaneously read data from the stream for real-time processing.
     * </p>
     * <p>
     * You must specify the shard to be split and the new hash key, which is the position in the shard where the shard
     * gets split in two. In many cases, the new hash key might be the average of the beginning and ending hash key, but
     * it can be any hash key value in the range being mapped into the shard. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-split.html">Split a
     * Shard</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * You can use <a>DescribeStream</a> to determine the shard ID and hash key values for the <code>ShardToSplit</code>
     * and <code>NewStartingHashKey</code> parameters that are specified in the <code>SplitShard</code> request.
     * </p>
     * <p>
     * <code>SplitShard</code> is an asynchronous operation. Upon receiving a <code>SplitShard</code> request, Kinesis
     * Data Streams immediately returns a response and sets the stream status to <code>UPDATING</code>. After the
     * operation is completed, Kinesis Data Streams sets the stream status to <code>ACTIVE</code>. Read and write
     * operations continue to work while the stream is in the <code>UPDATING</code> state.
     * </p>
     * <p>
     * You can use <code>DescribeStream</code> to check the status of the stream, which is returned in
     * <code>StreamStatus</code>. If the stream is in the <code>ACTIVE</code> state, you can call
     * <code>SplitShard</code>. If a stream is in <code>CREATING</code> or <code>UPDATING</code> or
     * <code>DELETING</code> states, <code>DescribeStream</code> returns a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * If the specified stream does not exist, <code>DescribeStream</code> returns a
     * <code>ResourceNotFoundException</code>. If you try to create more shards than are authorized for your account,
     * you receive a <code>LimitExceededException</code>.
     * </p>
     * <p>
     * For the default shard limit for an AWS account, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams
     * Limits</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>. To increase this limit, <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">contact AWS Support</a>.
     * </p>
     * <p>
     * If you try to operate on too many streams simultaneously using <a>CreateStream</a>, <a>DeleteStream</a>,
     * <a>MergeShards</a>, and/or <a>SplitShard</a>, you receive a <code>LimitExceededException</code>.
     * </p>
     * <p>
     * <code>SplitShard</code> has a limit of five transactions per second per account.
     * </p>
     *
     * @param splitShardRequest
     *        Represents the input for <code>SplitShard</code>.
     * @return Result of the SplitShard operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.SplitShard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShard" target="_top">AWS API
     *      Documentation</a>
     */
    default SplitShardResponse splitShard(SplitShardRequest splitShardRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidArgumentException, LimitExceededException, AwsServiceException, SdkClientException,
            KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Splits a shard into two new shards in the Kinesis data stream, to increase the stream's capacity to ingest and
     * transport data. <code>SplitShard</code> is called when there is a need to increase the overall capacity of a
     * stream because of an expected increase in the volume of data records being ingested.
     * </p>
     * <p>
     * You can also use <code>SplitShard</code> when a shard appears to be approaching its maximum utilization; for
     * example, the producers sending data into the specific shard are suddenly sending more than previously
     * anticipated. You can also call <code>SplitShard</code> to increase stream capacity, so that more Kinesis Data
     * Streams applications can simultaneously read data from the stream for real-time processing.
     * </p>
     * <p>
     * You must specify the shard to be split and the new hash key, which is the position in the shard where the shard
     * gets split in two. In many cases, the new hash key might be the average of the beginning and ending hash key, but
     * it can be any hash key value in the range being mapped into the shard. For more information, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/kinesis-using-sdk-java-resharding-split.html">Split a
     * Shard</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>.
     * </p>
     * <p>
     * You can use <a>DescribeStream</a> to determine the shard ID and hash key values for the <code>ShardToSplit</code>
     * and <code>NewStartingHashKey</code> parameters that are specified in the <code>SplitShard</code> request.
     * </p>
     * <p>
     * <code>SplitShard</code> is an asynchronous operation. Upon receiving a <code>SplitShard</code> request, Kinesis
     * Data Streams immediately returns a response and sets the stream status to <code>UPDATING</code>. After the
     * operation is completed, Kinesis Data Streams sets the stream status to <code>ACTIVE</code>. Read and write
     * operations continue to work while the stream is in the <code>UPDATING</code> state.
     * </p>
     * <p>
     * You can use <code>DescribeStream</code> to check the status of the stream, which is returned in
     * <code>StreamStatus</code>. If the stream is in the <code>ACTIVE</code> state, you can call
     * <code>SplitShard</code>. If a stream is in <code>CREATING</code> or <code>UPDATING</code> or
     * <code>DELETING</code> states, <code>DescribeStream</code> returns a <code>ResourceInUseException</code>.
     * </p>
     * <p>
     * If the specified stream does not exist, <code>DescribeStream</code> returns a
     * <code>ResourceNotFoundException</code>. If you try to create more shards than are authorized for your account,
     * you receive a <code>LimitExceededException</code>.
     * </p>
     * <p>
     * For the default shard limit for an AWS account, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams
     * Limits</a> in the <i>Amazon Kinesis Data Streams Developer Guide</i>. To increase this limit, <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">contact AWS Support</a>.
     * </p>
     * <p>
     * If you try to operate on too many streams simultaneously using <a>CreateStream</a>, <a>DeleteStream</a>,
     * <a>MergeShards</a>, and/or <a>SplitShard</a>, you receive a <code>LimitExceededException</code>.
     * </p>
     * <p>
     * <code>SplitShard</code> has a limit of five transactions per second per account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SplitShardRequest.Builder} avoiding the need to
     * create one manually via {@link SplitShardRequest#builder()}
     * </p>
     *
     * @param splitShardRequest
     *        A {@link Consumer} that will call methods on {@link SplitShardInput.Builder} to create a request.
     *        Represents the input for <code>SplitShard</code>.
     * @return Result of the SplitShard operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.SplitShard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/SplitShard" target="_top">AWS API
     *      Documentation</a>
     */
    default SplitShardResponse splitShard(Consumer<SplitShardRequest.Builder> splitShardRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidArgumentException, LimitExceededException,
            AwsServiceException, SdkClientException, KinesisException {
        return splitShard(SplitShardRequest.builder().applyMutation(splitShardRequest).build());
    }

    /**
     * <p>
     * Enables or updates server-side encryption using an AWS KMS key for a specified stream.
     * </p>
     * <p>
     * Starting encryption is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns
     * immediately and sets the status of the stream to <code>UPDATING</code>. After the update is complete, Kinesis
     * Data Streams sets the status of the stream back to <code>ACTIVE</code>. Updating or applying encryption normally
     * takes a few seconds to complete, but it can take minutes. You can continue to read and write data to your stream
     * while its status is <code>UPDATING</code>. Once the status of the stream is <code>ACTIVE</code>, encryption
     * begins for records written to the stream.
     * </p>
     * <p>
     * API Limits: You can successfully apply a new AWS KMS key for server-side encryption 25 times in a rolling 24-hour
     * period.
     * </p>
     * <p>
     * Note: It can take up to 5 seconds after the stream is in an <code>ACTIVE</code> status before all records written
     * to the stream are encrypted. After you enable encryption, you can verify that encryption is applied by inspecting
     * the API response from <code>PutRecord</code> or <code>PutRecords</code>.
     * </p>
     *
     * @param startStreamEncryptionRequest
     * @return Result of the StartStreamEncryption operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws KmsDisabledException
     *         The request was rejected because the specified customer master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The request was rejected because the state of the specified resource isn't valid for this request. For
     *         more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How
     *         Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that you don't have access to.
     * @throws KmsNotFoundException
     *         The request was rejected because the specified entity or resource can't be found.
     * @throws KmsOptInRequiredException
     *         The AWS access key ID needs a subscription for the service.
     * @throws KmsThrottlingException
     *         The request was denied due to request throttling. For more information about throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.StartStreamEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StartStreamEncryption" target="_top">AWS
     *      API Documentation</a>
     */
    default StartStreamEncryptionResponse startStreamEncryption(StartStreamEncryptionRequest startStreamEncryptionRequest)
            throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException,
            KmsDisabledException, KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException,
            KmsOptInRequiredException, KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables or updates server-side encryption using an AWS KMS key for a specified stream.
     * </p>
     * <p>
     * Starting encryption is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns
     * immediately and sets the status of the stream to <code>UPDATING</code>. After the update is complete, Kinesis
     * Data Streams sets the status of the stream back to <code>ACTIVE</code>. Updating or applying encryption normally
     * takes a few seconds to complete, but it can take minutes. You can continue to read and write data to your stream
     * while its status is <code>UPDATING</code>. Once the status of the stream is <code>ACTIVE</code>, encryption
     * begins for records written to the stream.
     * </p>
     * <p>
     * API Limits: You can successfully apply a new AWS KMS key for server-side encryption 25 times in a rolling 24-hour
     * period.
     * </p>
     * <p>
     * Note: It can take up to 5 seconds after the stream is in an <code>ACTIVE</code> status before all records written
     * to the stream are encrypted. After you enable encryption, you can verify that encryption is applied by inspecting
     * the API response from <code>PutRecord</code> or <code>PutRecords</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartStreamEncryptionRequest.Builder} avoiding the
     * need to create one manually via {@link StartStreamEncryptionRequest#builder()}
     * </p>
     *
     * @param startStreamEncryptionRequest
     *        A {@link Consumer} that will call methods on {@link StartStreamEncryptionInput.Builder} to create a
     *        request.
     * @return Result of the StartStreamEncryption operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws KmsDisabledException
     *         The request was rejected because the specified customer master key (CMK) isn't enabled.
     * @throws KmsInvalidStateException
     *         The request was rejected because the state of the specified resource isn't valid for this request. For
     *         more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How
     *         Key State Affects Use of a Customer Master Key</a> in the <i>AWS Key Management Service Developer
     *         Guide</i>.
     * @throws KmsAccessDeniedException
     *         The ciphertext references a key that doesn't exist or that you don't have access to.
     * @throws KmsNotFoundException
     *         The request was rejected because the specified entity or resource can't be found.
     * @throws KmsOptInRequiredException
     *         The AWS access key ID needs a subscription for the service.
     * @throws KmsThrottlingException
     *         The request was denied due to request throttling. For more information about throttling, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a>
     *         in the <i>AWS Key Management Service Developer Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.StartStreamEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StartStreamEncryption" target="_top">AWS
     *      API Documentation</a>
     */
    default StartStreamEncryptionResponse startStreamEncryption(
            Consumer<StartStreamEncryptionRequest.Builder> startStreamEncryptionRequest) throws InvalidArgumentException,
            LimitExceededException, ResourceInUseException, ResourceNotFoundException, KmsDisabledException,
            KmsInvalidStateException, KmsAccessDeniedException, KmsNotFoundException, KmsOptInRequiredException,
            KmsThrottlingException, AwsServiceException, SdkClientException, KinesisException {
        return startStreamEncryption(StartStreamEncryptionRequest.builder().applyMutation(startStreamEncryptionRequest).build());
    }

    /**
     * <p>
     * Disables server-side encryption for a specified stream.
     * </p>
     * <p>
     * Stopping encryption is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns
     * immediately and sets the status of the stream to <code>UPDATING</code>. After the update is complete, Kinesis
     * Data Streams sets the status of the stream back to <code>ACTIVE</code>. Stopping encryption normally takes a few
     * seconds to complete, but it can take minutes. You can continue to read and write data to your stream while its
     * status is <code>UPDATING</code>. Once the status of the stream is <code>ACTIVE</code>, records written to the
     * stream are no longer encrypted by Kinesis Data Streams.
     * </p>
     * <p>
     * API Limits: You can successfully disable server-side encryption 25 times in a rolling 24-hour period.
     * </p>
     * <p>
     * Note: It can take up to 5 seconds after the stream is in an <code>ACTIVE</code> status before all records written
     * to the stream are no longer subject to encryption. After you disabled encryption, you can verify that encryption
     * is not applied by inspecting the API response from <code>PutRecord</code> or <code>PutRecords</code>.
     * </p>
     *
     * @param stopStreamEncryptionRequest
     * @return Result of the StopStreamEncryption operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.StopStreamEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StopStreamEncryption" target="_top">AWS
     *      API Documentation</a>
     */
    default StopStreamEncryptionResponse stopStreamEncryption(StopStreamEncryptionRequest stopStreamEncryptionRequest)
            throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables server-side encryption for a specified stream.
     * </p>
     * <p>
     * Stopping encryption is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns
     * immediately and sets the status of the stream to <code>UPDATING</code>. After the update is complete, Kinesis
     * Data Streams sets the status of the stream back to <code>ACTIVE</code>. Stopping encryption normally takes a few
     * seconds to complete, but it can take minutes. You can continue to read and write data to your stream while its
     * status is <code>UPDATING</code>. Once the status of the stream is <code>ACTIVE</code>, records written to the
     * stream are no longer encrypted by Kinesis Data Streams.
     * </p>
     * <p>
     * API Limits: You can successfully disable server-side encryption 25 times in a rolling 24-hour period.
     * </p>
     * <p>
     * Note: It can take up to 5 seconds after the stream is in an <code>ACTIVE</code> status before all records written
     * to the stream are no longer subject to encryption. After you disabled encryption, you can verify that encryption
     * is not applied by inspecting the API response from <code>PutRecord</code> or <code>PutRecords</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopStreamEncryptionRequest.Builder} avoiding the
     * need to create one manually via {@link StopStreamEncryptionRequest#builder()}
     * </p>
     *
     * @param stopStreamEncryptionRequest
     *        A {@link Consumer} that will call methods on {@link StopStreamEncryptionInput.Builder} to create a
     *        request.
     * @return Result of the StopStreamEncryption operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.StopStreamEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/StopStreamEncryption" target="_top">AWS
     *      API Documentation</a>
     */
    default StopStreamEncryptionResponse stopStreamEncryption(
            Consumer<StopStreamEncryptionRequest.Builder> stopStreamEncryptionRequest) throws InvalidArgumentException,
            LimitExceededException, ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            KinesisException {
        return stopStreamEncryption(StopStreamEncryptionRequest.builder().applyMutation(stopStreamEncryptionRequest).build());
    }

    /**
     * <p>
     * Updates the shard count of the specified stream to the specified number of shards.
     * </p>
     * <p>
     * Updating the shard count is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns
     * immediately and sets the status of the stream to <code>UPDATING</code>. After the update is complete, Kinesis
     * Data Streams sets the status of the stream back to <code>ACTIVE</code>. Depending on the size of the stream, the
     * scaling action could take a few minutes to complete. You can continue to read and write data to your stream while
     * its status is <code>UPDATING</code>.
     * </p>
     * <p>
     * To update the shard count, Kinesis Data Streams performs splits or merges on individual shards. This can cause
     * short-lived shards to be created, in addition to the final shards. These short-lived shards count towards your
     * total shard limit for your account in the Region.
     * </p>
     * <p>
     * When using this operation, we recommend that you specify a target shard count that is a multiple of 25% (25%,
     * 50%, 75%, 100%). You can specify any target value within your shard limit. However, if you specify a target that
     * isn't a multiple of 25%, the scaling action might take longer to complete.
     * </p>
     * <p>
     * This operation has the following default limits. By default, you cannot do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Scale more than ten times per rolling 24-hour period per stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale up to more than double your current shard count for a stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale down below half your current shard count for a stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale up to more than 500 shards in a stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale a stream with more than 500 shards down unless the result is less than 500 shards
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale up to more than the shard limit for your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the default limits for an AWS account, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
     * <i>Amazon Kinesis Data Streams Developer Guide</i>. To request an increase in the call rate limit, the shard
     * limit for this API, or your overall shard limit, use the <a href=
     * "https://console.aws.amazon.com/support/v1#/case/create?issueType=service-limit-increase&amp;limitType=service-code-kinesis"
     * >limits form</a>.
     * </p>
     *
     * @param updateShardCountRequest
     * @return Result of the UpdateShardCount operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.UpdateShardCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCount" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateShardCountResponse updateShardCount(UpdateShardCountRequest updateShardCountRequest)
            throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, KinesisException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the shard count of the specified stream to the specified number of shards.
     * </p>
     * <p>
     * Updating the shard count is an asynchronous operation. Upon receiving the request, Kinesis Data Streams returns
     * immediately and sets the status of the stream to <code>UPDATING</code>. After the update is complete, Kinesis
     * Data Streams sets the status of the stream back to <code>ACTIVE</code>. Depending on the size of the stream, the
     * scaling action could take a few minutes to complete. You can continue to read and write data to your stream while
     * its status is <code>UPDATING</code>.
     * </p>
     * <p>
     * To update the shard count, Kinesis Data Streams performs splits or merges on individual shards. This can cause
     * short-lived shards to be created, in addition to the final shards. These short-lived shards count towards your
     * total shard limit for your account in the Region.
     * </p>
     * <p>
     * When using this operation, we recommend that you specify a target shard count that is a multiple of 25% (25%,
     * 50%, 75%, 100%). You can specify any target value within your shard limit. However, if you specify a target that
     * isn't a multiple of 25%, the scaling action might take longer to complete.
     * </p>
     * <p>
     * This operation has the following default limits. By default, you cannot do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Scale more than ten times per rolling 24-hour period per stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale up to more than double your current shard count for a stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale down below half your current shard count for a stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale up to more than 500 shards in a stream
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale a stream with more than 500 shards down unless the result is less than 500 shards
     * </p>
     * </li>
     * <li>
     * <p>
     * Scale up to more than the shard limit for your account
     * </p>
     * </li>
     * </ul>
     * <p>
     * For the default limits for an AWS account, see <a
     * href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
     * <i>Amazon Kinesis Data Streams Developer Guide</i>. To request an increase in the call rate limit, the shard
     * limit for this API, or your overall shard limit, use the <a href=
     * "https://console.aws.amazon.com/support/v1#/case/create?issueType=service-limit-increase&amp;limitType=service-code-kinesis"
     * >limits form</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateShardCountRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateShardCountRequest#builder()}
     * </p>
     *
     * @param updateShardCountRequest
     *        A {@link Consumer} that will call methods on {@link UpdateShardCountInput.Builder} to create a request.
     * @return Result of the UpdateShardCount operation returned by the service.
     * @throws InvalidArgumentException
     *         A specified parameter exceeds its restrictions, is not supported, or can't be used. For more information,
     *         see the returned message.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceInUseException
     *         The resource is not available for this operation. For successful operation, the resource must be in the
     *         <code>ACTIVE</code> state.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found. The stream might not be specified correctly.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws KinesisException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample KinesisClient.UpdateShardCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/kinesis-2013-12-02/UpdateShardCount" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateShardCountResponse updateShardCount(Consumer<UpdateShardCountRequest.Builder> updateShardCountRequest)
            throws InvalidArgumentException, LimitExceededException, ResourceInUseException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, KinesisException {
        return updateShardCount(UpdateShardCountRequest.builder().applyMutation(updateShardCountRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    /**
     * Create an instance of {@link KinesisWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link KinesisWaiter}
     */
    default KinesisWaiter waiter() {
        throw new UnsupportedOperationException();
    }
}
