/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspacesstreams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.keyspacesstreams.KeyspacesStreamsAsyncClient;
import software.amazon.awssdk.services.keyspacesstreams.internal.UserAgentUtils;
import software.amazon.awssdk.services.keyspacesstreams.model.GetStreamRequest;
import software.amazon.awssdk.services.keyspacesstreams.model.GetStreamResponse;
import software.amazon.awssdk.services.keyspacesstreams.model.Shard;

public class GetStreamPublisher
implements SdkPublisher<GetStreamResponse> {
    private final KeyspacesStreamsAsyncClient client;
    private final GetStreamRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetStreamPublisher(KeyspacesStreamsAsyncClient client, GetStreamRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetStreamPublisher(KeyspacesStreamsAsyncClient client, GetStreamRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetStreamResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetStreamResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Shard> shards() {
        Function<GetStreamResponse, Iterator> getIterator = response -> {
            if (response != null && response.shards() != null) {
                return response.shards().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetStreamResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetStreamResponseFetcher
    implements AsyncPageFetcher<GetStreamResponse> {
        private GetStreamResponseFetcher() {
        }

        public boolean hasNextPage(GetStreamResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetStreamResponse> nextPage(GetStreamResponse previousPage) {
            if (previousPage == null) {
                return GetStreamPublisher.this.client.getStream(GetStreamPublisher.this.firstRequest);
            }
            return GetStreamPublisher.this.client.getStream((GetStreamRequest)((Object)GetStreamPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

