/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TypeStatus {
    ACTIVE("ACTIVE"),
    CREATING("CREATING"),
    DELETING("DELETING"),
    RESTORING("RESTORING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TypeStatus> VALUE_MAP;
    private final String value;

    private TypeStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TypeStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TypeStatus> knownValues() {
        EnumSet<TypeStatus> knownValues = EnumSet.allOf(TypeStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TypeStatus.class, TypeStatus::toString);
    }
}

