/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyspaceStatus {
    ACTIVE("ACTIVE"),
    CREATING("CREATING"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyspaceStatus> VALUE_MAP;
    private final String value;

    private KeyspaceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyspaceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyspaceStatus> knownValues() {
        EnumSet<KeyspaceStatus> knownValues = EnumSet.allOf(KeyspaceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyspaceStatus.class, KeyspaceStatus::toString);
    }
}

