/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTypeResponse
extends KeyspacesResponse
implements ToCopyableBuilder<Builder, CreateTypeResponse> {
    private static final SdkField<String> KEYSPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceArn").getter(CreateTypeResponse.getter(CreateTypeResponse::keyspaceArn)).setter(CreateTypeResponse.setter(Builder::keyspaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceArn").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeName").getter(CreateTypeResponse.getter(CreateTypeResponse::typeName)).setter(CreateTypeResponse.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_ARN_FIELD, TYPE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTypeResponse.memberNameToFieldInitializer();
    private final String keyspaceArn;
    private final String typeName;

    private CreateTypeResponse(BuilderImpl builder) {
        super(builder);
        this.keyspaceArn = builder.keyspaceArn;
        this.typeName = builder.typeName;
    }

    public final String keyspaceArn() {
        return this.keyspaceArn;
    }

    public final String typeName() {
        return this.typeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTypeResponse)) {
            return false;
        }
        CreateTypeResponse other = (CreateTypeResponse)((Object)obj);
        return Objects.equals(this.keyspaceArn(), other.keyspaceArn()) && Objects.equals(this.typeName(), other.typeName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTypeResponse").add("KeyspaceArn", (Object)this.keyspaceArn()).add("TypeName", (Object)this.typeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceArn": {
                return Optional.ofNullable(clazz.cast(this.keyspaceArn()));
            }
            case "typeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("keyspaceArn", KEYSPACE_ARN_FIELD);
        map.put("typeName", TYPE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTypeResponse, T> g) {
        return obj -> g.apply((CreateTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesResponse.BuilderImpl
    implements Builder {
        private String keyspaceArn;
        private String typeName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTypeResponse model) {
            super(model);
            this.keyspaceArn(model.keyspaceArn);
            this.typeName(model.typeName);
        }

        public final String getKeyspaceArn() {
            return this.keyspaceArn;
        }

        public final void setKeyspaceArn(String keyspaceArn) {
            this.keyspaceArn = keyspaceArn;
        }

        @Override
        public final Builder keyspaceArn(String keyspaceArn) {
            this.keyspaceArn = keyspaceArn;
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        @Override
        public CreateTypeResponse build() {
            return new CreateTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KeyspacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTypeResponse> {
        public Builder keyspaceArn(String var1);

        public Builder typeName(String var1);
    }
}

