/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.kendra.model.GitHubDocumentCrawlProperties;
import software.amazon.awssdk.services.kendra.model.OnPremiseConfiguration;
import software.amazon.awssdk.services.kendra.model.RepositoryNamesCopier;
import software.amazon.awssdk.services.kendra.model.SaaSConfiguration;
import software.amazon.awssdk.services.kendra.model.StringListCopier;
import software.amazon.awssdk.services.kendra.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GitHubConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GitHubConfiguration> {
    private static final SdkField<SaaSConfiguration> SAA_S_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SaaSConfiguration").getter(GitHubConfiguration.getter(GitHubConfiguration::saaSConfiguration)).setter(GitHubConfiguration.setter(Builder::saaSConfiguration)).constructor(SaaSConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SaaSConfiguration").build()}).build();
    private static final SdkField<OnPremiseConfiguration> ON_PREMISE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OnPremiseConfiguration").getter(GitHubConfiguration.getter(GitHubConfiguration::onPremiseConfiguration)).setter(GitHubConfiguration.setter(Builder::onPremiseConfiguration)).constructor(OnPremiseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnPremiseConfiguration").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GitHubConfiguration.getter(GitHubConfiguration::typeAsString)).setter(GitHubConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(GitHubConfiguration.getter(GitHubConfiguration::secretArn)).setter(GitHubConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseChangeLog").getter(GitHubConfiguration.getter(GitHubConfiguration::useChangeLog)).setter(GitHubConfiguration.setter(Builder::useChangeLog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()}).build();
    private static final SdkField<GitHubDocumentCrawlProperties> GIT_HUB_DOCUMENT_CRAWL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GitHubDocumentCrawlProperties").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubDocumentCrawlProperties)).setter(GitHubConfiguration.setter(Builder::gitHubDocumentCrawlProperties)).constructor(GitHubDocumentCrawlProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubDocumentCrawlProperties").build()}).build();
    private static final SdkField<List<String>> REPOSITORY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RepositoryFilter").getter(GitHubConfiguration.getter(GitHubConfiguration::repositoryFilter)).setter(GitHubConfiguration.setter(Builder::repositoryFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_FOLDER_NAME_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionFolderNamePatterns").getter(GitHubConfiguration.getter(GitHubConfiguration::inclusionFolderNamePatterns)).setter(GitHubConfiguration.setter(Builder::inclusionFolderNamePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFolderNamePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_FILE_TYPE_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionFileTypePatterns").getter(GitHubConfiguration.getter(GitHubConfiguration::inclusionFileTypePatterns)).setter(GitHubConfiguration.setter(Builder::inclusionFileTypePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFileTypePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_FILE_NAME_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionFileNamePatterns").getter(GitHubConfiguration.getter(GitHubConfiguration::inclusionFileNamePatterns)).setter(GitHubConfiguration.setter(Builder::inclusionFileNamePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionFileNamePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_FOLDER_NAME_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionFolderNamePatterns").getter(GitHubConfiguration.getter(GitHubConfiguration::exclusionFolderNamePatterns)).setter(GitHubConfiguration.setter(Builder::exclusionFolderNamePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFolderNamePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_FILE_TYPE_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionFileTypePatterns").getter(GitHubConfiguration.getter(GitHubConfiguration::exclusionFileTypePatterns)).setter(GitHubConfiguration.setter(Builder::exclusionFileTypePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFileTypePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_FILE_NAME_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionFileNamePatterns").getter(GitHubConfiguration.getter(GitHubConfiguration::exclusionFileNamePatterns)).setter(GitHubConfiguration.setter(Builder::exclusionFileNamePatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionFileNamePatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(GitHubConfiguration.getter(GitHubConfiguration::vpcConfiguration)).setter(GitHubConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_REPOSITORY_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GitHubRepositoryConfigurationFieldMappings").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubRepositoryConfigurationFieldMappings)).setter(GitHubConfiguration.setter(Builder::gitHubRepositoryConfigurationFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubRepositoryConfigurationFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_COMMIT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GitHubCommitConfigurationFieldMappings").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubCommitConfigurationFieldMappings)).setter(GitHubConfiguration.setter(Builder::gitHubCommitConfigurationFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubCommitConfigurationFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_ISSUE_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GitHubIssueDocumentConfigurationFieldMappings").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubIssueDocumentConfigurationFieldMappings)).setter(GitHubConfiguration.setter(Builder::gitHubIssueDocumentConfigurationFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubIssueDocumentConfigurationFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_ISSUE_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GitHubIssueCommentConfigurationFieldMappings").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubIssueCommentConfigurationFieldMappings)).setter(GitHubConfiguration.setter(Builder::gitHubIssueCommentConfigurationFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubIssueCommentConfigurationFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_ISSUE_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GitHubIssueAttachmentConfigurationFieldMappings").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubIssueAttachmentConfigurationFieldMappings)).setter(GitHubConfiguration.setter(Builder::gitHubIssueAttachmentConfigurationFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubIssueAttachmentConfigurationFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_PULL_REQUEST_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GitHubPullRequestCommentConfigurationFieldMappings").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubPullRequestCommentConfigurationFieldMappings)).setter(GitHubConfiguration.setter(Builder::gitHubPullRequestCommentConfigurationFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubPullRequestCommentConfigurationFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_PULL_REQUEST_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GitHubPullRequestDocumentConfigurationFieldMappings").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubPullRequestDocumentConfigurationFieldMappings)).setter(GitHubConfiguration.setter(Builder::gitHubPullRequestDocumentConfigurationFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubPullRequestDocumentConfigurationFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> GIT_HUB_PULL_REQUEST_DOCUMENT_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GitHubPullRequestDocumentAttachmentConfigurationFieldMappings").getter(GitHubConfiguration.getter(GitHubConfiguration::gitHubPullRequestDocumentAttachmentConfigurationFieldMappings)).setter(GitHubConfiguration.setter(Builder::gitHubPullRequestDocumentAttachmentConfigurationFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GitHubPullRequestDocumentAttachmentConfigurationFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAA_S_CONFIGURATION_FIELD, ON_PREMISE_CONFIGURATION_FIELD, TYPE_FIELD, SECRET_ARN_FIELD, USE_CHANGE_LOG_FIELD, GIT_HUB_DOCUMENT_CRAWL_PROPERTIES_FIELD, REPOSITORY_FILTER_FIELD, INCLUSION_FOLDER_NAME_PATTERNS_FIELD, INCLUSION_FILE_TYPE_PATTERNS_FIELD, INCLUSION_FILE_NAME_PATTERNS_FIELD, EXCLUSION_FOLDER_NAME_PATTERNS_FIELD, EXCLUSION_FILE_TYPE_PATTERNS_FIELD, EXCLUSION_FILE_NAME_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD, GIT_HUB_REPOSITORY_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_COMMIT_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_ISSUE_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_ISSUE_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_ISSUE_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_PULL_REQUEST_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_PULL_REQUEST_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD, GIT_HUB_PULL_REQUEST_DOCUMENT_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GitHubConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SaaSConfiguration saaSConfiguration;
    private final OnPremiseConfiguration onPremiseConfiguration;
    private final String type;
    private final String secretArn;
    private final Boolean useChangeLog;
    private final GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties;
    private final List<String> repositoryFilter;
    private final List<String> inclusionFolderNamePatterns;
    private final List<String> inclusionFileTypePatterns;
    private final List<String> inclusionFileNamePatterns;
    private final List<String> exclusionFolderNamePatterns;
    private final List<String> exclusionFileTypePatterns;
    private final List<String> exclusionFileNamePatterns;
    private final DataSourceVpcConfiguration vpcConfiguration;
    private final List<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings;
    private final List<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings;
    private final List<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings;
    private final List<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings;
    private final List<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings;
    private final List<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings;
    private final List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings;
    private final List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings;

    private GitHubConfiguration(BuilderImpl builder) {
        this.saaSConfiguration = builder.saaSConfiguration;
        this.onPremiseConfiguration = builder.onPremiseConfiguration;
        this.type = builder.type;
        this.secretArn = builder.secretArn;
        this.useChangeLog = builder.useChangeLog;
        this.gitHubDocumentCrawlProperties = builder.gitHubDocumentCrawlProperties;
        this.repositoryFilter = builder.repositoryFilter;
        this.inclusionFolderNamePatterns = builder.inclusionFolderNamePatterns;
        this.inclusionFileTypePatterns = builder.inclusionFileTypePatterns;
        this.inclusionFileNamePatterns = builder.inclusionFileNamePatterns;
        this.exclusionFolderNamePatterns = builder.exclusionFolderNamePatterns;
        this.exclusionFileTypePatterns = builder.exclusionFileTypePatterns;
        this.exclusionFileNamePatterns = builder.exclusionFileNamePatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.gitHubRepositoryConfigurationFieldMappings = builder.gitHubRepositoryConfigurationFieldMappings;
        this.gitHubCommitConfigurationFieldMappings = builder.gitHubCommitConfigurationFieldMappings;
        this.gitHubIssueDocumentConfigurationFieldMappings = builder.gitHubIssueDocumentConfigurationFieldMappings;
        this.gitHubIssueCommentConfigurationFieldMappings = builder.gitHubIssueCommentConfigurationFieldMappings;
        this.gitHubIssueAttachmentConfigurationFieldMappings = builder.gitHubIssueAttachmentConfigurationFieldMappings;
        this.gitHubPullRequestCommentConfigurationFieldMappings = builder.gitHubPullRequestCommentConfigurationFieldMappings;
        this.gitHubPullRequestDocumentConfigurationFieldMappings = builder.gitHubPullRequestDocumentConfigurationFieldMappings;
        this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = builder.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings;
    }

    public final SaaSConfiguration saaSConfiguration() {
        return this.saaSConfiguration;
    }

    public final OnPremiseConfiguration onPremiseConfiguration() {
        return this.onPremiseConfiguration;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final Boolean useChangeLog() {
        return this.useChangeLog;
    }

    public final GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties() {
        return this.gitHubDocumentCrawlProperties;
    }

    public final boolean hasRepositoryFilter() {
        return this.repositoryFilter != null && !(this.repositoryFilter instanceof SdkAutoConstructList);
    }

    public final List<String> repositoryFilter() {
        return this.repositoryFilter;
    }

    public final boolean hasInclusionFolderNamePatterns() {
        return this.inclusionFolderNamePatterns != null && !(this.inclusionFolderNamePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionFolderNamePatterns() {
        return this.inclusionFolderNamePatterns;
    }

    public final boolean hasInclusionFileTypePatterns() {
        return this.inclusionFileTypePatterns != null && !(this.inclusionFileTypePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionFileTypePatterns() {
        return this.inclusionFileTypePatterns;
    }

    public final boolean hasInclusionFileNamePatterns() {
        return this.inclusionFileNamePatterns != null && !(this.inclusionFileNamePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionFileNamePatterns() {
        return this.inclusionFileNamePatterns;
    }

    public final boolean hasExclusionFolderNamePatterns() {
        return this.exclusionFolderNamePatterns != null && !(this.exclusionFolderNamePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionFolderNamePatterns() {
        return this.exclusionFolderNamePatterns;
    }

    public final boolean hasExclusionFileTypePatterns() {
        return this.exclusionFileTypePatterns != null && !(this.exclusionFileTypePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionFileTypePatterns() {
        return this.exclusionFileTypePatterns;
    }

    public final boolean hasExclusionFileNamePatterns() {
        return this.exclusionFileNamePatterns != null && !(this.exclusionFileNamePatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionFileNamePatterns() {
        return this.exclusionFileNamePatterns;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public final boolean hasGitHubRepositoryConfigurationFieldMappings() {
        return this.gitHubRepositoryConfigurationFieldMappings != null && !(this.gitHubRepositoryConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings() {
        return this.gitHubRepositoryConfigurationFieldMappings;
    }

    public final boolean hasGitHubCommitConfigurationFieldMappings() {
        return this.gitHubCommitConfigurationFieldMappings != null && !(this.gitHubCommitConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings() {
        return this.gitHubCommitConfigurationFieldMappings;
    }

    public final boolean hasGitHubIssueDocumentConfigurationFieldMappings() {
        return this.gitHubIssueDocumentConfigurationFieldMappings != null && !(this.gitHubIssueDocumentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings() {
        return this.gitHubIssueDocumentConfigurationFieldMappings;
    }

    public final boolean hasGitHubIssueCommentConfigurationFieldMappings() {
        return this.gitHubIssueCommentConfigurationFieldMappings != null && !(this.gitHubIssueCommentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings() {
        return this.gitHubIssueCommentConfigurationFieldMappings;
    }

    public final boolean hasGitHubIssueAttachmentConfigurationFieldMappings() {
        return this.gitHubIssueAttachmentConfigurationFieldMappings != null && !(this.gitHubIssueAttachmentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings() {
        return this.gitHubIssueAttachmentConfigurationFieldMappings;
    }

    public final boolean hasGitHubPullRequestCommentConfigurationFieldMappings() {
        return this.gitHubPullRequestCommentConfigurationFieldMappings != null && !(this.gitHubPullRequestCommentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings() {
        return this.gitHubPullRequestCommentConfigurationFieldMappings;
    }

    public final boolean hasGitHubPullRequestDocumentConfigurationFieldMappings() {
        return this.gitHubPullRequestDocumentConfigurationFieldMappings != null && !(this.gitHubPullRequestDocumentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings() {
        return this.gitHubPullRequestDocumentConfigurationFieldMappings;
    }

    public final boolean hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() {
        return this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings != null && !(this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings() {
        return this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.saaSConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremiseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.gitHubDocumentCrawlProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRepositoryFilter() ? this.repositoryFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionFolderNamePatterns() ? this.inclusionFolderNamePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionFileTypePatterns() ? this.inclusionFileTypePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionFileNamePatterns() ? this.inclusionFileNamePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionFolderNamePatterns() ? this.exclusionFolderNamePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionFileTypePatterns() ? this.exclusionFileTypePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionFileNamePatterns() ? this.exclusionFileNamePatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGitHubRepositoryConfigurationFieldMappings() ? this.gitHubRepositoryConfigurationFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGitHubCommitConfigurationFieldMappings() ? this.gitHubCommitConfigurationFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGitHubIssueDocumentConfigurationFieldMappings() ? this.gitHubIssueDocumentConfigurationFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGitHubIssueCommentConfigurationFieldMappings() ? this.gitHubIssueCommentConfigurationFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGitHubIssueAttachmentConfigurationFieldMappings() ? this.gitHubIssueAttachmentConfigurationFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGitHubPullRequestCommentConfigurationFieldMappings() ? this.gitHubPullRequestCommentConfigurationFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGitHubPullRequestDocumentConfigurationFieldMappings() ? this.gitHubPullRequestDocumentConfigurationFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() ? this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GitHubConfiguration)) {
            return false;
        }
        GitHubConfiguration other = (GitHubConfiguration)obj;
        return Objects.equals(this.saaSConfiguration(), other.saaSConfiguration()) && Objects.equals(this.onPremiseConfiguration(), other.onPremiseConfiguration()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.useChangeLog(), other.useChangeLog()) && Objects.equals(this.gitHubDocumentCrawlProperties(), other.gitHubDocumentCrawlProperties()) && this.hasRepositoryFilter() == other.hasRepositoryFilter() && Objects.equals(this.repositoryFilter(), other.repositoryFilter()) && this.hasInclusionFolderNamePatterns() == other.hasInclusionFolderNamePatterns() && Objects.equals(this.inclusionFolderNamePatterns(), other.inclusionFolderNamePatterns()) && this.hasInclusionFileTypePatterns() == other.hasInclusionFileTypePatterns() && Objects.equals(this.inclusionFileTypePatterns(), other.inclusionFileTypePatterns()) && this.hasInclusionFileNamePatterns() == other.hasInclusionFileNamePatterns() && Objects.equals(this.inclusionFileNamePatterns(), other.inclusionFileNamePatterns()) && this.hasExclusionFolderNamePatterns() == other.hasExclusionFolderNamePatterns() && Objects.equals(this.exclusionFolderNamePatterns(), other.exclusionFolderNamePatterns()) && this.hasExclusionFileTypePatterns() == other.hasExclusionFileTypePatterns() && Objects.equals(this.exclusionFileTypePatterns(), other.exclusionFileTypePatterns()) && this.hasExclusionFileNamePatterns() == other.hasExclusionFileNamePatterns() && Objects.equals(this.exclusionFileNamePatterns(), other.exclusionFileNamePatterns()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration()) && this.hasGitHubRepositoryConfigurationFieldMappings() == other.hasGitHubRepositoryConfigurationFieldMappings() && Objects.equals(this.gitHubRepositoryConfigurationFieldMappings(), other.gitHubRepositoryConfigurationFieldMappings()) && this.hasGitHubCommitConfigurationFieldMappings() == other.hasGitHubCommitConfigurationFieldMappings() && Objects.equals(this.gitHubCommitConfigurationFieldMappings(), other.gitHubCommitConfigurationFieldMappings()) && this.hasGitHubIssueDocumentConfigurationFieldMappings() == other.hasGitHubIssueDocumentConfigurationFieldMappings() && Objects.equals(this.gitHubIssueDocumentConfigurationFieldMappings(), other.gitHubIssueDocumentConfigurationFieldMappings()) && this.hasGitHubIssueCommentConfigurationFieldMappings() == other.hasGitHubIssueCommentConfigurationFieldMappings() && Objects.equals(this.gitHubIssueCommentConfigurationFieldMappings(), other.gitHubIssueCommentConfigurationFieldMappings()) && this.hasGitHubIssueAttachmentConfigurationFieldMappings() == other.hasGitHubIssueAttachmentConfigurationFieldMappings() && Objects.equals(this.gitHubIssueAttachmentConfigurationFieldMappings(), other.gitHubIssueAttachmentConfigurationFieldMappings()) && this.hasGitHubPullRequestCommentConfigurationFieldMappings() == other.hasGitHubPullRequestCommentConfigurationFieldMappings() && Objects.equals(this.gitHubPullRequestCommentConfigurationFieldMappings(), other.gitHubPullRequestCommentConfigurationFieldMappings()) && this.hasGitHubPullRequestDocumentConfigurationFieldMappings() == other.hasGitHubPullRequestDocumentConfigurationFieldMappings() && Objects.equals(this.gitHubPullRequestDocumentConfigurationFieldMappings(), other.gitHubPullRequestDocumentConfigurationFieldMappings()) && this.hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() == other.hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() && Objects.equals(this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(), other.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings());
    }

    public final String toString() {
        return ToString.builder((String)"GitHubConfiguration").add("SaaSConfiguration", (Object)this.saaSConfiguration()).add("OnPremiseConfiguration", (Object)this.onPremiseConfiguration()).add("Type", (Object)this.typeAsString()).add("SecretArn", (Object)this.secretArn()).add("UseChangeLog", (Object)this.useChangeLog()).add("GitHubDocumentCrawlProperties", (Object)this.gitHubDocumentCrawlProperties()).add("RepositoryFilter", this.hasRepositoryFilter() ? this.repositoryFilter() : null).add("InclusionFolderNamePatterns", this.hasInclusionFolderNamePatterns() ? this.inclusionFolderNamePatterns() : null).add("InclusionFileTypePatterns", this.hasInclusionFileTypePatterns() ? this.inclusionFileTypePatterns() : null).add("InclusionFileNamePatterns", this.hasInclusionFileNamePatterns() ? this.inclusionFileNamePatterns() : null).add("ExclusionFolderNamePatterns", this.hasExclusionFolderNamePatterns() ? this.exclusionFolderNamePatterns() : null).add("ExclusionFileTypePatterns", this.hasExclusionFileTypePatterns() ? this.exclusionFileTypePatterns() : null).add("ExclusionFileNamePatterns", this.hasExclusionFileNamePatterns() ? this.exclusionFileNamePatterns() : null).add("VpcConfiguration", (Object)this.vpcConfiguration()).add("GitHubRepositoryConfigurationFieldMappings", this.hasGitHubRepositoryConfigurationFieldMappings() ? this.gitHubRepositoryConfigurationFieldMappings() : null).add("GitHubCommitConfigurationFieldMappings", this.hasGitHubCommitConfigurationFieldMappings() ? this.gitHubCommitConfigurationFieldMappings() : null).add("GitHubIssueDocumentConfigurationFieldMappings", this.hasGitHubIssueDocumentConfigurationFieldMappings() ? this.gitHubIssueDocumentConfigurationFieldMappings() : null).add("GitHubIssueCommentConfigurationFieldMappings", this.hasGitHubIssueCommentConfigurationFieldMappings() ? this.gitHubIssueCommentConfigurationFieldMappings() : null).add("GitHubIssueAttachmentConfigurationFieldMappings", this.hasGitHubIssueAttachmentConfigurationFieldMappings() ? this.gitHubIssueAttachmentConfigurationFieldMappings() : null).add("GitHubPullRequestCommentConfigurationFieldMappings", this.hasGitHubPullRequestCommentConfigurationFieldMappings() ? this.gitHubPullRequestCommentConfigurationFieldMappings() : null).add("GitHubPullRequestDocumentConfigurationFieldMappings", this.hasGitHubPullRequestDocumentConfigurationFieldMappings() ? this.gitHubPullRequestDocumentConfigurationFieldMappings() : null).add("GitHubPullRequestDocumentAttachmentConfigurationFieldMappings", this.hasGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() ? this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SaaSConfiguration": {
                return Optional.ofNullable(clazz.cast(this.saaSConfiguration()));
            }
            case "OnPremiseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.onPremiseConfiguration()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "UseChangeLog": {
                return Optional.ofNullable(clazz.cast(this.useChangeLog()));
            }
            case "GitHubDocumentCrawlProperties": {
                return Optional.ofNullable(clazz.cast(this.gitHubDocumentCrawlProperties()));
            }
            case "RepositoryFilter": {
                return Optional.ofNullable(clazz.cast(this.repositoryFilter()));
            }
            case "InclusionFolderNamePatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionFolderNamePatterns()));
            }
            case "InclusionFileTypePatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionFileTypePatterns()));
            }
            case "InclusionFileNamePatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionFileNamePatterns()));
            }
            case "ExclusionFolderNamePatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionFolderNamePatterns()));
            }
            case "ExclusionFileTypePatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionFileTypePatterns()));
            }
            case "ExclusionFileNamePatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionFileNamePatterns()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
            case "GitHubRepositoryConfigurationFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.gitHubRepositoryConfigurationFieldMappings()));
            }
            case "GitHubCommitConfigurationFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.gitHubCommitConfigurationFieldMappings()));
            }
            case "GitHubIssueDocumentConfigurationFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.gitHubIssueDocumentConfigurationFieldMappings()));
            }
            case "GitHubIssueCommentConfigurationFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.gitHubIssueCommentConfigurationFieldMappings()));
            }
            case "GitHubIssueAttachmentConfigurationFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.gitHubIssueAttachmentConfigurationFieldMappings()));
            }
            case "GitHubPullRequestCommentConfigurationFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.gitHubPullRequestCommentConfigurationFieldMappings()));
            }
            case "GitHubPullRequestDocumentConfigurationFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.gitHubPullRequestDocumentConfigurationFieldMappings()));
            }
            case "GitHubPullRequestDocumentAttachmentConfigurationFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SaaSConfiguration", SAA_S_CONFIGURATION_FIELD);
        map.put("OnPremiseConfiguration", ON_PREMISE_CONFIGURATION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("UseChangeLog", USE_CHANGE_LOG_FIELD);
        map.put("GitHubDocumentCrawlProperties", GIT_HUB_DOCUMENT_CRAWL_PROPERTIES_FIELD);
        map.put("RepositoryFilter", REPOSITORY_FILTER_FIELD);
        map.put("InclusionFolderNamePatterns", INCLUSION_FOLDER_NAME_PATTERNS_FIELD);
        map.put("InclusionFileTypePatterns", INCLUSION_FILE_TYPE_PATTERNS_FIELD);
        map.put("InclusionFileNamePatterns", INCLUSION_FILE_NAME_PATTERNS_FIELD);
        map.put("ExclusionFolderNamePatterns", EXCLUSION_FOLDER_NAME_PATTERNS_FIELD);
        map.put("ExclusionFileTypePatterns", EXCLUSION_FILE_TYPE_PATTERNS_FIELD);
        map.put("ExclusionFileNamePatterns", EXCLUSION_FILE_NAME_PATTERNS_FIELD);
        map.put("VpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("GitHubRepositoryConfigurationFieldMappings", GIT_HUB_REPOSITORY_CONFIGURATION_FIELD_MAPPINGS_FIELD);
        map.put("GitHubCommitConfigurationFieldMappings", GIT_HUB_COMMIT_CONFIGURATION_FIELD_MAPPINGS_FIELD);
        map.put("GitHubIssueDocumentConfigurationFieldMappings", GIT_HUB_ISSUE_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD);
        map.put("GitHubIssueCommentConfigurationFieldMappings", GIT_HUB_ISSUE_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD);
        map.put("GitHubIssueAttachmentConfigurationFieldMappings", GIT_HUB_ISSUE_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD);
        map.put("GitHubPullRequestCommentConfigurationFieldMappings", GIT_HUB_PULL_REQUEST_COMMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD);
        map.put("GitHubPullRequestDocumentConfigurationFieldMappings", GIT_HUB_PULL_REQUEST_DOCUMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD);
        map.put("GitHubPullRequestDocumentAttachmentConfigurationFieldMappings", GIT_HUB_PULL_REQUEST_DOCUMENT_ATTACHMENT_CONFIGURATION_FIELD_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GitHubConfiguration, T> g) {
        return obj -> g.apply((GitHubConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SaaSConfiguration saaSConfiguration;
        private OnPremiseConfiguration onPremiseConfiguration;
        private String type;
        private String secretArn;
        private Boolean useChangeLog;
        private GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties;
        private List<String> repositoryFilter = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionFolderNamePatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionFileTypePatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionFileNamePatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionFolderNamePatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionFileTypePatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionFileNamePatterns = DefaultSdkAutoConstructList.getInstance();
        private DataSourceVpcConfiguration vpcConfiguration;
        private List<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GitHubConfiguration model) {
            this.saaSConfiguration(model.saaSConfiguration);
            this.onPremiseConfiguration(model.onPremiseConfiguration);
            this.type(model.type);
            this.secretArn(model.secretArn);
            this.useChangeLog(model.useChangeLog);
            this.gitHubDocumentCrawlProperties(model.gitHubDocumentCrawlProperties);
            this.repositoryFilter(model.repositoryFilter);
            this.inclusionFolderNamePatterns(model.inclusionFolderNamePatterns);
            this.inclusionFileTypePatterns(model.inclusionFileTypePatterns);
            this.inclusionFileNamePatterns(model.inclusionFileNamePatterns);
            this.exclusionFolderNamePatterns(model.exclusionFolderNamePatterns);
            this.exclusionFileTypePatterns(model.exclusionFileTypePatterns);
            this.exclusionFileNamePatterns(model.exclusionFileNamePatterns);
            this.vpcConfiguration(model.vpcConfiguration);
            this.gitHubRepositoryConfigurationFieldMappings(model.gitHubRepositoryConfigurationFieldMappings);
            this.gitHubCommitConfigurationFieldMappings(model.gitHubCommitConfigurationFieldMappings);
            this.gitHubIssueDocumentConfigurationFieldMappings(model.gitHubIssueDocumentConfigurationFieldMappings);
            this.gitHubIssueCommentConfigurationFieldMappings(model.gitHubIssueCommentConfigurationFieldMappings);
            this.gitHubIssueAttachmentConfigurationFieldMappings(model.gitHubIssueAttachmentConfigurationFieldMappings);
            this.gitHubPullRequestCommentConfigurationFieldMappings(model.gitHubPullRequestCommentConfigurationFieldMappings);
            this.gitHubPullRequestDocumentConfigurationFieldMappings(model.gitHubPullRequestDocumentConfigurationFieldMappings);
            this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(model.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
        }

        public final SaaSConfiguration.Builder getSaaSConfiguration() {
            return this.saaSConfiguration != null ? this.saaSConfiguration.toBuilder() : null;
        }

        public final void setSaaSConfiguration(SaaSConfiguration.BuilderImpl saaSConfiguration) {
            this.saaSConfiguration = saaSConfiguration != null ? saaSConfiguration.build() : null;
        }

        @Override
        public final Builder saaSConfiguration(SaaSConfiguration saaSConfiguration) {
            this.saaSConfiguration = saaSConfiguration;
            return this;
        }

        public final OnPremiseConfiguration.Builder getOnPremiseConfiguration() {
            return this.onPremiseConfiguration != null ? this.onPremiseConfiguration.toBuilder() : null;
        }

        public final void setOnPremiseConfiguration(OnPremiseConfiguration.BuilderImpl onPremiseConfiguration) {
            this.onPremiseConfiguration = onPremiseConfiguration != null ? onPremiseConfiguration.build() : null;
        }

        @Override
        public final Builder onPremiseConfiguration(OnPremiseConfiguration onPremiseConfiguration) {
            this.onPremiseConfiguration = onPremiseConfiguration;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Boolean getUseChangeLog() {
            return this.useChangeLog;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final GitHubDocumentCrawlProperties.Builder getGitHubDocumentCrawlProperties() {
            return this.gitHubDocumentCrawlProperties != null ? this.gitHubDocumentCrawlProperties.toBuilder() : null;
        }

        public final void setGitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties.BuilderImpl gitHubDocumentCrawlProperties) {
            this.gitHubDocumentCrawlProperties = gitHubDocumentCrawlProperties != null ? gitHubDocumentCrawlProperties.build() : null;
        }

        @Override
        public final Builder gitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties gitHubDocumentCrawlProperties) {
            this.gitHubDocumentCrawlProperties = gitHubDocumentCrawlProperties;
            return this;
        }

        public final Collection<String> getRepositoryFilter() {
            if (this.repositoryFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.repositoryFilter;
        }

        public final void setRepositoryFilter(Collection<String> repositoryFilter) {
            this.repositoryFilter = RepositoryNamesCopier.copy(repositoryFilter);
        }

        @Override
        public final Builder repositoryFilter(Collection<String> repositoryFilter) {
            this.repositoryFilter = RepositoryNamesCopier.copy(repositoryFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryFilter(String ... repositoryFilter) {
            this.repositoryFilter(Arrays.asList(repositoryFilter));
            return this;
        }

        public final Collection<String> getInclusionFolderNamePatterns() {
            if (this.inclusionFolderNamePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionFolderNamePatterns;
        }

        public final void setInclusionFolderNamePatterns(Collection<String> inclusionFolderNamePatterns) {
            this.inclusionFolderNamePatterns = StringListCopier.copy(inclusionFolderNamePatterns);
        }

        @Override
        public final Builder inclusionFolderNamePatterns(Collection<String> inclusionFolderNamePatterns) {
            this.inclusionFolderNamePatterns = StringListCopier.copy(inclusionFolderNamePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFolderNamePatterns(String ... inclusionFolderNamePatterns) {
            this.inclusionFolderNamePatterns(Arrays.asList(inclusionFolderNamePatterns));
            return this;
        }

        public final Collection<String> getInclusionFileTypePatterns() {
            if (this.inclusionFileTypePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionFileTypePatterns;
        }

        public final void setInclusionFileTypePatterns(Collection<String> inclusionFileTypePatterns) {
            this.inclusionFileTypePatterns = StringListCopier.copy(inclusionFileTypePatterns);
        }

        @Override
        public final Builder inclusionFileTypePatterns(Collection<String> inclusionFileTypePatterns) {
            this.inclusionFileTypePatterns = StringListCopier.copy(inclusionFileTypePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFileTypePatterns(String ... inclusionFileTypePatterns) {
            this.inclusionFileTypePatterns(Arrays.asList(inclusionFileTypePatterns));
            return this;
        }

        public final Collection<String> getInclusionFileNamePatterns() {
            if (this.inclusionFileNamePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionFileNamePatterns;
        }

        public final void setInclusionFileNamePatterns(Collection<String> inclusionFileNamePatterns) {
            this.inclusionFileNamePatterns = StringListCopier.copy(inclusionFileNamePatterns);
        }

        @Override
        public final Builder inclusionFileNamePatterns(Collection<String> inclusionFileNamePatterns) {
            this.inclusionFileNamePatterns = StringListCopier.copy(inclusionFileNamePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionFileNamePatterns(String ... inclusionFileNamePatterns) {
            this.inclusionFileNamePatterns(Arrays.asList(inclusionFileNamePatterns));
            return this;
        }

        public final Collection<String> getExclusionFolderNamePatterns() {
            if (this.exclusionFolderNamePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionFolderNamePatterns;
        }

        public final void setExclusionFolderNamePatterns(Collection<String> exclusionFolderNamePatterns) {
            this.exclusionFolderNamePatterns = StringListCopier.copy(exclusionFolderNamePatterns);
        }

        @Override
        public final Builder exclusionFolderNamePatterns(Collection<String> exclusionFolderNamePatterns) {
            this.exclusionFolderNamePatterns = StringListCopier.copy(exclusionFolderNamePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFolderNamePatterns(String ... exclusionFolderNamePatterns) {
            this.exclusionFolderNamePatterns(Arrays.asList(exclusionFolderNamePatterns));
            return this;
        }

        public final Collection<String> getExclusionFileTypePatterns() {
            if (this.exclusionFileTypePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionFileTypePatterns;
        }

        public final void setExclusionFileTypePatterns(Collection<String> exclusionFileTypePatterns) {
            this.exclusionFileTypePatterns = StringListCopier.copy(exclusionFileTypePatterns);
        }

        @Override
        public final Builder exclusionFileTypePatterns(Collection<String> exclusionFileTypePatterns) {
            this.exclusionFileTypePatterns = StringListCopier.copy(exclusionFileTypePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFileTypePatterns(String ... exclusionFileTypePatterns) {
            this.exclusionFileTypePatterns(Arrays.asList(exclusionFileTypePatterns));
            return this;
        }

        public final Collection<String> getExclusionFileNamePatterns() {
            if (this.exclusionFileNamePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionFileNamePatterns;
        }

        public final void setExclusionFileNamePatterns(Collection<String> exclusionFileNamePatterns) {
            this.exclusionFileNamePatterns = StringListCopier.copy(exclusionFileNamePatterns);
        }

        @Override
        public final Builder exclusionFileNamePatterns(Collection<String> exclusionFileNamePatterns) {
            this.exclusionFileNamePatterns = StringListCopier.copy(exclusionFileNamePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionFileNamePatterns(String ... exclusionFileNamePatterns) {
            this.exclusionFileNamePatterns(Arrays.asList(exclusionFileNamePatterns));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubRepositoryConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.gitHubRepositoryConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubRepositoryConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubRepositoryConfigurationFieldMappings) {
            this.gitHubRepositoryConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(gitHubRepositoryConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubRepositoryConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> gitHubRepositoryConfigurationFieldMappings) {
            this.gitHubRepositoryConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(gitHubRepositoryConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubRepositoryConfigurationFieldMappings(DataSourceToIndexFieldMapping ... gitHubRepositoryConfigurationFieldMappings) {
            this.gitHubRepositoryConfigurationFieldMappings(Arrays.asList(gitHubRepositoryConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubRepositoryConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... gitHubRepositoryConfigurationFieldMappings) {
            this.gitHubRepositoryConfigurationFieldMappings(Stream.of(gitHubRepositoryConfigurationFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubCommitConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.gitHubCommitConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubCommitConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubCommitConfigurationFieldMappings) {
            this.gitHubCommitConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(gitHubCommitConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubCommitConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> gitHubCommitConfigurationFieldMappings) {
            this.gitHubCommitConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(gitHubCommitConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubCommitConfigurationFieldMappings(DataSourceToIndexFieldMapping ... gitHubCommitConfigurationFieldMappings) {
            this.gitHubCommitConfigurationFieldMappings(Arrays.asList(gitHubCommitConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubCommitConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... gitHubCommitConfigurationFieldMappings) {
            this.gitHubCommitConfigurationFieldMappings(Stream.of(gitHubCommitConfigurationFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubIssueDocumentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.gitHubIssueDocumentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubIssueDocumentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubIssueDocumentConfigurationFieldMappings) {
            this.gitHubIssueDocumentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(gitHubIssueDocumentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubIssueDocumentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> gitHubIssueDocumentConfigurationFieldMappings) {
            this.gitHubIssueDocumentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(gitHubIssueDocumentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueDocumentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... gitHubIssueDocumentConfigurationFieldMappings) {
            this.gitHubIssueDocumentConfigurationFieldMappings(Arrays.asList(gitHubIssueDocumentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueDocumentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... gitHubIssueDocumentConfigurationFieldMappings) {
            this.gitHubIssueDocumentConfigurationFieldMappings(Stream.of(gitHubIssueDocumentConfigurationFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubIssueCommentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.gitHubIssueCommentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubIssueCommentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubIssueCommentConfigurationFieldMappings) {
            this.gitHubIssueCommentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(gitHubIssueCommentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubIssueCommentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> gitHubIssueCommentConfigurationFieldMappings) {
            this.gitHubIssueCommentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(gitHubIssueCommentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueCommentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... gitHubIssueCommentConfigurationFieldMappings) {
            this.gitHubIssueCommentConfigurationFieldMappings(Arrays.asList(gitHubIssueCommentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueCommentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... gitHubIssueCommentConfigurationFieldMappings) {
            this.gitHubIssueCommentConfigurationFieldMappings(Stream.of(gitHubIssueCommentConfigurationFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubIssueAttachmentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.gitHubIssueAttachmentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubIssueAttachmentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubIssueAttachmentConfigurationFieldMappings) {
            this.gitHubIssueAttachmentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(gitHubIssueAttachmentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubIssueAttachmentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> gitHubIssueAttachmentConfigurationFieldMappings) {
            this.gitHubIssueAttachmentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(gitHubIssueAttachmentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueAttachmentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... gitHubIssueAttachmentConfigurationFieldMappings) {
            this.gitHubIssueAttachmentConfigurationFieldMappings(Arrays.asList(gitHubIssueAttachmentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubIssueAttachmentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... gitHubIssueAttachmentConfigurationFieldMappings) {
            this.gitHubIssueAttachmentConfigurationFieldMappings(Stream.of(gitHubIssueAttachmentConfigurationFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubPullRequestCommentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.gitHubPullRequestCommentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubPullRequestCommentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubPullRequestCommentConfigurationFieldMappings) {
            this.gitHubPullRequestCommentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(gitHubPullRequestCommentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubPullRequestCommentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> gitHubPullRequestCommentConfigurationFieldMappings) {
            this.gitHubPullRequestCommentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(gitHubPullRequestCommentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestCommentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... gitHubPullRequestCommentConfigurationFieldMappings) {
            this.gitHubPullRequestCommentConfigurationFieldMappings(Arrays.asList(gitHubPullRequestCommentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestCommentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... gitHubPullRequestCommentConfigurationFieldMappings) {
            this.gitHubPullRequestCommentConfigurationFieldMappings(Stream.of(gitHubPullRequestCommentConfigurationFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubPullRequestDocumentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.gitHubPullRequestDocumentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubPullRequestDocumentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubPullRequestDocumentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(gitHubPullRequestDocumentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubPullRequestDocumentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(gitHubPullRequestDocumentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestDocumentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... gitHubPullRequestDocumentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentConfigurationFieldMappings(Arrays.asList(gitHubPullRequestDocumentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestDocumentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... gitHubPullRequestDocumentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentConfigurationFieldMappings(Stream.of(gitHubPullRequestDocumentConfigurationFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getGitHubPullRequestDocumentAttachmentConfigurationFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
        }

        @Override
        public final Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Arrays.asList(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... gitHubPullRequestDocumentAttachmentConfigurationFieldMappings) {
            this.gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Stream.of(gitHubPullRequestDocumentAttachmentConfigurationFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GitHubConfiguration build() {
            return new GitHubConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GitHubConfiguration> {
        public Builder saaSConfiguration(SaaSConfiguration var1);

        default public Builder saaSConfiguration(Consumer<SaaSConfiguration.Builder> saaSConfiguration) {
            return this.saaSConfiguration((SaaSConfiguration)((SaaSConfiguration.Builder)SaaSConfiguration.builder().applyMutation(saaSConfiguration)).build());
        }

        public Builder onPremiseConfiguration(OnPremiseConfiguration var1);

        default public Builder onPremiseConfiguration(Consumer<OnPremiseConfiguration.Builder> onPremiseConfiguration) {
            return this.onPremiseConfiguration((OnPremiseConfiguration)((OnPremiseConfiguration.Builder)OnPremiseConfiguration.builder().applyMutation(onPremiseConfiguration)).build());
        }

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder secretArn(String var1);

        public Builder useChangeLog(Boolean var1);

        public Builder gitHubDocumentCrawlProperties(GitHubDocumentCrawlProperties var1);

        default public Builder gitHubDocumentCrawlProperties(Consumer<GitHubDocumentCrawlProperties.Builder> gitHubDocumentCrawlProperties) {
            return this.gitHubDocumentCrawlProperties((GitHubDocumentCrawlProperties)((GitHubDocumentCrawlProperties.Builder)GitHubDocumentCrawlProperties.builder().applyMutation(gitHubDocumentCrawlProperties)).build());
        }

        public Builder repositoryFilter(Collection<String> var1);

        public Builder repositoryFilter(String ... var1);

        public Builder inclusionFolderNamePatterns(Collection<String> var1);

        public Builder inclusionFolderNamePatterns(String ... var1);

        public Builder inclusionFileTypePatterns(Collection<String> var1);

        public Builder inclusionFileTypePatterns(String ... var1);

        public Builder inclusionFileNamePatterns(Collection<String> var1);

        public Builder inclusionFileNamePatterns(String ... var1);

        public Builder exclusionFolderNamePatterns(Collection<String> var1);

        public Builder exclusionFolderNamePatterns(String ... var1);

        public Builder exclusionFileTypePatterns(Collection<String> var1);

        public Builder exclusionFileTypePatterns(String ... var1);

        public Builder exclusionFileNamePatterns(Collection<String> var1);

        public Builder exclusionFileNamePatterns(String ... var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }

        public Builder gitHubRepositoryConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder gitHubRepositoryConfigurationFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder gitHubRepositoryConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder gitHubCommitConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder gitHubCommitConfigurationFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder gitHubCommitConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder gitHubIssueDocumentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder gitHubIssueDocumentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder gitHubIssueDocumentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder gitHubIssueCommentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder gitHubIssueCommentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder gitHubIssueCommentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder gitHubIssueAttachmentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder gitHubIssueAttachmentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder gitHubIssueAttachmentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder gitHubPullRequestCommentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder gitHubPullRequestCommentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder gitHubPullRequestCommentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder gitHubPullRequestDocumentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder gitHubPullRequestDocumentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder gitHubPullRequestDocumentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder gitHubPullRequestDocumentAttachmentConfigurationFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);
    }
}

