/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeValue;
import software.amazon.awssdk.services.kendra.model.FacetResult;
import software.amazon.awssdk.services.kendra.model.FacetResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentAttributeValueCountPair
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentAttributeValueCountPair> {
    private static final SdkField<DocumentAttributeValue> DOCUMENT_ATTRIBUTE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentAttributeValue").getter(DocumentAttributeValueCountPair.getter(DocumentAttributeValueCountPair::documentAttributeValue)).setter(DocumentAttributeValueCountPair.setter(Builder::documentAttributeValue)).constructor(DocumentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeValue").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(DocumentAttributeValueCountPair.getter(DocumentAttributeValueCountPair::count)).setter(DocumentAttributeValueCountPair.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()}).build();
    private static final SdkField<List<FacetResult>> FACET_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FacetResults").getter(DocumentAttributeValueCountPair.getter(DocumentAttributeValueCountPair::facetResults)).setter(DocumentAttributeValueCountPair.setter(Builder::facetResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FacetResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_VALUE_FIELD, COUNT_FIELD, FACET_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DocumentAttributeValueCountPair.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DocumentAttributeValue documentAttributeValue;
    private final Integer count;
    private final List<FacetResult> facetResults;

    private DocumentAttributeValueCountPair(BuilderImpl builder) {
        this.documentAttributeValue = builder.documentAttributeValue;
        this.count = builder.count;
        this.facetResults = builder.facetResults;
    }

    public final DocumentAttributeValue documentAttributeValue() {
        return this.documentAttributeValue;
    }

    public final Integer count() {
        return this.count;
    }

    public final boolean hasFacetResults() {
        return this.facetResults != null && !(this.facetResults instanceof SdkAutoConstructList);
    }

    public final List<FacetResult> facetResults() {
        return this.facetResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttributeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFacetResults() ? this.facetResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeValueCountPair)) {
            return false;
        }
        DocumentAttributeValueCountPair other = (DocumentAttributeValueCountPair)obj;
        return Objects.equals(this.documentAttributeValue(), other.documentAttributeValue()) && Objects.equals(this.count(), other.count()) && this.hasFacetResults() == other.hasFacetResults() && Objects.equals(this.facetResults(), other.facetResults());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentAttributeValueCountPair").add("DocumentAttributeValue", (Object)this.documentAttributeValue()).add("Count", (Object)this.count()).add("FacetResults", this.hasFacetResults() ? this.facetResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentAttributeValue": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeValue()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "FacetResults": {
                return Optional.ofNullable(clazz.cast(this.facetResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentAttributeValue", DOCUMENT_ATTRIBUTE_VALUE_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("FacetResults", FACET_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeValueCountPair, T> g) {
        return obj -> g.apply((DocumentAttributeValueCountPair)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DocumentAttributeValue documentAttributeValue;
        private Integer count;
        private List<FacetResult> facetResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeValueCountPair model) {
            this.documentAttributeValue(model.documentAttributeValue);
            this.count(model.count);
            this.facetResults(model.facetResults);
        }

        public final DocumentAttributeValue.Builder getDocumentAttributeValue() {
            return this.documentAttributeValue != null ? this.documentAttributeValue.toBuilder() : null;
        }

        public final void setDocumentAttributeValue(DocumentAttributeValue.BuilderImpl documentAttributeValue) {
            this.documentAttributeValue = documentAttributeValue != null ? documentAttributeValue.build() : null;
        }

        @Override
        public final Builder documentAttributeValue(DocumentAttributeValue documentAttributeValue) {
            this.documentAttributeValue = documentAttributeValue;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final List<FacetResult.Builder> getFacetResults() {
            List<FacetResult.Builder> result = FacetResultListCopier.copyToBuilder(this.facetResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFacetResults(Collection<FacetResult.BuilderImpl> facetResults) {
            this.facetResults = FacetResultListCopier.copyFromBuilder(facetResults);
        }

        @Override
        public final Builder facetResults(Collection<FacetResult> facetResults) {
            this.facetResults = FacetResultListCopier.copy(facetResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(FacetResult ... facetResults) {
            this.facetResults(Arrays.asList(facetResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(Consumer<FacetResult.Builder> ... facetResults) {
            this.facetResults(Stream.of(facetResults).map(c -> (FacetResult)((FacetResult.Builder)FacetResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DocumentAttributeValueCountPair build() {
            return new DocumentAttributeValueCountPair(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentAttributeValueCountPair> {
        public Builder documentAttributeValue(DocumentAttributeValue var1);

        default public Builder documentAttributeValue(Consumer<DocumentAttributeValue.Builder> documentAttributeValue) {
            return this.documentAttributeValue((DocumentAttributeValue)((DocumentAttributeValue.Builder)DocumentAttributeValue.builder().applyMutation(documentAttributeValue)).build());
        }

        public Builder count(Integer var1);

        public Builder facetResults(Collection<FacetResult> var1);

        public Builder facetResults(FacetResult ... var1);

        public Builder facetResults(Consumer<FacetResult.Builder> ... var1);
    }
}

