/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.AttributeSuggestionsMode;
import software.amazon.awssdk.services.kendra.model.SuggestableConfig;
import software.amazon.awssdk.services.kendra.model.SuggestableConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AttributeSuggestionsDescribeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AttributeSuggestionsDescribeConfig> {
    private static final SdkField<List<SuggestableConfig>> SUGGESTABLE_CONFIG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuggestableConfigList").getter(AttributeSuggestionsDescribeConfig.getter(AttributeSuggestionsDescribeConfig::suggestableConfigList)).setter(AttributeSuggestionsDescribeConfig.setter(Builder::suggestableConfigList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggestableConfigList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuggestableConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ATTRIBUTE_SUGGESTIONS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeSuggestionsMode").getter(AttributeSuggestionsDescribeConfig.getter(AttributeSuggestionsDescribeConfig::attributeSuggestionsModeAsString)).setter(AttributeSuggestionsDescribeConfig.setter(Builder::attributeSuggestionsMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeSuggestionsMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTABLE_CONFIG_LIST_FIELD, ATTRIBUTE_SUGGESTIONS_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AttributeSuggestionsDescribeConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<SuggestableConfig> suggestableConfigList;
    private final String attributeSuggestionsMode;

    private AttributeSuggestionsDescribeConfig(BuilderImpl builder) {
        this.suggestableConfigList = builder.suggestableConfigList;
        this.attributeSuggestionsMode = builder.attributeSuggestionsMode;
    }

    public final boolean hasSuggestableConfigList() {
        return this.suggestableConfigList != null && !(this.suggestableConfigList instanceof SdkAutoConstructList);
    }

    public final List<SuggestableConfig> suggestableConfigList() {
        return this.suggestableConfigList;
    }

    public final AttributeSuggestionsMode attributeSuggestionsMode() {
        return AttributeSuggestionsMode.fromValue(this.attributeSuggestionsMode);
    }

    public final String attributeSuggestionsModeAsString() {
        return this.attributeSuggestionsMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestableConfigList() ? this.suggestableConfigList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeSuggestionsModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeSuggestionsDescribeConfig)) {
            return false;
        }
        AttributeSuggestionsDescribeConfig other = (AttributeSuggestionsDescribeConfig)obj;
        return this.hasSuggestableConfigList() == other.hasSuggestableConfigList() && Objects.equals(this.suggestableConfigList(), other.suggestableConfigList()) && Objects.equals(this.attributeSuggestionsModeAsString(), other.attributeSuggestionsModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AttributeSuggestionsDescribeConfig").add("SuggestableConfigList", this.hasSuggestableConfigList() ? this.suggestableConfigList() : null).add("AttributeSuggestionsMode", (Object)this.attributeSuggestionsModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SuggestableConfigList": {
                return Optional.ofNullable(clazz.cast(this.suggestableConfigList()));
            }
            case "AttributeSuggestionsMode": {
                return Optional.ofNullable(clazz.cast(this.attributeSuggestionsModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SuggestableConfigList", SUGGESTABLE_CONFIG_LIST_FIELD);
        map.put("AttributeSuggestionsMode", ATTRIBUTE_SUGGESTIONS_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AttributeSuggestionsDescribeConfig, T> g) {
        return obj -> g.apply((AttributeSuggestionsDescribeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SuggestableConfig> suggestableConfigList = DefaultSdkAutoConstructList.getInstance();
        private String attributeSuggestionsMode;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeSuggestionsDescribeConfig model) {
            this.suggestableConfigList(model.suggestableConfigList);
            this.attributeSuggestionsMode(model.attributeSuggestionsMode);
        }

        public final List<SuggestableConfig.Builder> getSuggestableConfigList() {
            List<SuggestableConfig.Builder> result = SuggestableConfigListCopier.copyToBuilder(this.suggestableConfigList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestableConfigList(Collection<SuggestableConfig.BuilderImpl> suggestableConfigList) {
            this.suggestableConfigList = SuggestableConfigListCopier.copyFromBuilder(suggestableConfigList);
        }

        @Override
        public final Builder suggestableConfigList(Collection<SuggestableConfig> suggestableConfigList) {
            this.suggestableConfigList = SuggestableConfigListCopier.copy(suggestableConfigList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestableConfigList(SuggestableConfig ... suggestableConfigList) {
            this.suggestableConfigList(Arrays.asList(suggestableConfigList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestableConfigList(Consumer<SuggestableConfig.Builder> ... suggestableConfigList) {
            this.suggestableConfigList(Stream.of(suggestableConfigList).map(c -> (SuggestableConfig)((SuggestableConfig.Builder)SuggestableConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAttributeSuggestionsMode() {
            return this.attributeSuggestionsMode;
        }

        public final void setAttributeSuggestionsMode(String attributeSuggestionsMode) {
            this.attributeSuggestionsMode = attributeSuggestionsMode;
        }

        @Override
        public final Builder attributeSuggestionsMode(String attributeSuggestionsMode) {
            this.attributeSuggestionsMode = attributeSuggestionsMode;
            return this;
        }

        @Override
        public final Builder attributeSuggestionsMode(AttributeSuggestionsMode attributeSuggestionsMode) {
            this.attributeSuggestionsMode(attributeSuggestionsMode == null ? null : attributeSuggestionsMode.toString());
            return this;
        }

        public AttributeSuggestionsDescribeConfig build() {
            return new AttributeSuggestionsDescribeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AttributeSuggestionsDescribeConfig> {
        public Builder suggestableConfigList(Collection<SuggestableConfig> var1);

        public Builder suggestableConfigList(SuggestableConfig ... var1);

        public Builder suggestableConfigList(Consumer<SuggestableConfig.Builder> ... var1);

        public Builder attributeSuggestionsMode(String var1);

        public Builder attributeSuggestionsMode(AttributeSuggestionsMode var1);
    }
}

