/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.FacetResult;
import software.amazon.awssdk.services.kendra.model.FacetResultListCopier;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsItem;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsItemListCopier;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.QueryResultItem;
import software.amazon.awssdk.services.kendra.model.QueryResultItemListCopier;
import software.amazon.awssdk.services.kendra.model.SpellCorrectedQuery;
import software.amazon.awssdk.services.kendra.model.SpellCorrectedQueryListCopier;
import software.amazon.awssdk.services.kendra.model.Warning;
import software.amazon.awssdk.services.kendra.model.WarningListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, QueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QueryId").getter(QueryResponse.getter(QueryResponse::queryId)).setter(QueryResponse.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()}).build();
    private static final SdkField<List<QueryResultItem>> RESULT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultItems").getter(QueryResponse.getter(QueryResponse::resultItems)).setter(QueryResponse.setter(Builder::resultItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FacetResult>> FACET_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FacetResults").getter(QueryResponse.getter(QueryResponse::facetResults)).setter(QueryResponse.setter(Builder::facetResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FacetResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_NUMBER_OF_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalNumberOfResults").getter(QueryResponse.getter(QueryResponse::totalNumberOfResults)).setter(QueryResponse.setter(Builder::totalNumberOfResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfResults").build()}).build();
    private static final SdkField<List<Warning>> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Warnings").getter(QueryResponse.getter(QueryResponse::warnings)).setter(QueryResponse.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Warning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SpellCorrectedQuery>> SPELL_CORRECTED_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SpellCorrectedQueries").getter(QueryResponse.getter(QueryResponse::spellCorrectedQueries)).setter(QueryResponse.setter(Builder::spellCorrectedQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpellCorrectedQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpellCorrectedQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FeaturedResultsItem>> FEATURED_RESULTS_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeaturedResultsItems").getter(QueryResponse.getter(QueryResponse::featuredResultsItems)).setter(QueryResponse.setter(Builder::featuredResultsItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeaturedResultsItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD, RESULT_ITEMS_FIELD, FACET_RESULTS_FIELD, TOTAL_NUMBER_OF_RESULTS_FIELD, WARNINGS_FIELD, SPELL_CORRECTED_QUERIES_FIELD, FEATURED_RESULTS_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryResponse.memberNameToFieldInitializer();
    private final String queryId;
    private final List<QueryResultItem> resultItems;
    private final List<FacetResult> facetResults;
    private final Integer totalNumberOfResults;
    private final List<Warning> warnings;
    private final List<SpellCorrectedQuery> spellCorrectedQueries;
    private final List<FeaturedResultsItem> featuredResultsItems;

    private QueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.resultItems = builder.resultItems;
        this.facetResults = builder.facetResults;
        this.totalNumberOfResults = builder.totalNumberOfResults;
        this.warnings = builder.warnings;
        this.spellCorrectedQueries = builder.spellCorrectedQueries;
        this.featuredResultsItems = builder.featuredResultsItems;
    }

    public final String queryId() {
        return this.queryId;
    }

    public final boolean hasResultItems() {
        return this.resultItems != null && !(this.resultItems instanceof SdkAutoConstructList);
    }

    public final List<QueryResultItem> resultItems() {
        return this.resultItems;
    }

    public final boolean hasFacetResults() {
        return this.facetResults != null && !(this.facetResults instanceof SdkAutoConstructList);
    }

    public final List<FacetResult> facetResults() {
        return this.facetResults;
    }

    public final Integer totalNumberOfResults() {
        return this.totalNumberOfResults;
    }

    public final boolean hasWarnings() {
        return this.warnings != null && !(this.warnings instanceof SdkAutoConstructList);
    }

    public final List<Warning> warnings() {
        return this.warnings;
    }

    public final boolean hasSpellCorrectedQueries() {
        return this.spellCorrectedQueries != null && !(this.spellCorrectedQueries instanceof SdkAutoConstructList);
    }

    public final List<SpellCorrectedQuery> spellCorrectedQueries() {
        return this.spellCorrectedQueries;
    }

    public final boolean hasFeaturedResultsItems() {
        return this.featuredResultsItems != null && !(this.featuredResultsItems instanceof SdkAutoConstructList);
    }

    public final List<FeaturedResultsItem> featuredResultsItems() {
        return this.featuredResultsItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultItems() ? this.resultItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFacetResults() ? this.facetResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWarnings() ? this.warnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSpellCorrectedQueries() ? this.spellCorrectedQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeaturedResultsItems() ? this.featuredResultsItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResponse)) {
            return false;
        }
        QueryResponse other = (QueryResponse)((Object)obj);
        return Objects.equals(this.queryId(), other.queryId()) && this.hasResultItems() == other.hasResultItems() && Objects.equals(this.resultItems(), other.resultItems()) && this.hasFacetResults() == other.hasFacetResults() && Objects.equals(this.facetResults(), other.facetResults()) && Objects.equals(this.totalNumberOfResults(), other.totalNumberOfResults()) && this.hasWarnings() == other.hasWarnings() && Objects.equals(this.warnings(), other.warnings()) && this.hasSpellCorrectedQueries() == other.hasSpellCorrectedQueries() && Objects.equals(this.spellCorrectedQueries(), other.spellCorrectedQueries()) && this.hasFeaturedResultsItems() == other.hasFeaturedResultsItems() && Objects.equals(this.featuredResultsItems(), other.featuredResultsItems());
    }

    public final String toString() {
        return ToString.builder((String)"QueryResponse").add("QueryId", (Object)this.queryId()).add("ResultItems", this.hasResultItems() ? this.resultItems() : null).add("FacetResults", this.hasFacetResults() ? this.facetResults() : null).add("TotalNumberOfResults", (Object)this.totalNumberOfResults()).add("Warnings", this.hasWarnings() ? this.warnings() : null).add("SpellCorrectedQueries", this.hasSpellCorrectedQueries() ? this.spellCorrectedQueries() : null).add("FeaturedResultsItems", this.hasFeaturedResultsItems() ? this.featuredResultsItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
            case "ResultItems": {
                return Optional.ofNullable(clazz.cast(this.resultItems()));
            }
            case "FacetResults": {
                return Optional.ofNullable(clazz.cast(this.facetResults()));
            }
            case "TotalNumberOfResults": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfResults()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "SpellCorrectedQueries": {
                return Optional.ofNullable(clazz.cast(this.spellCorrectedQueries()));
            }
            case "FeaturedResultsItems": {
                return Optional.ofNullable(clazz.cast(this.featuredResultsItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryId", QUERY_ID_FIELD);
        map.put("ResultItems", RESULT_ITEMS_FIELD);
        map.put("FacetResults", FACET_RESULTS_FIELD);
        map.put("TotalNumberOfResults", TOTAL_NUMBER_OF_RESULTS_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        map.put("SpellCorrectedQueries", SPELL_CORRECTED_QUERIES_FIELD);
        map.put("FeaturedResultsItems", FEATURED_RESULTS_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryResponse, T> g) {
        return obj -> g.apply((QueryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String queryId;
        private List<QueryResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();
        private List<FacetResult> facetResults = DefaultSdkAutoConstructList.getInstance();
        private Integer totalNumberOfResults;
        private List<Warning> warnings = DefaultSdkAutoConstructList.getInstance();
        private List<SpellCorrectedQuery> spellCorrectedQueries = DefaultSdkAutoConstructList.getInstance();
        private List<FeaturedResultsItem> featuredResultsItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResponse model) {
            super(model);
            this.queryId(model.queryId);
            this.resultItems(model.resultItems);
            this.facetResults(model.facetResults);
            this.totalNumberOfResults(model.totalNumberOfResults);
            this.warnings(model.warnings);
            this.spellCorrectedQueries(model.spellCorrectedQueries);
            this.featuredResultsItems(model.featuredResultsItems);
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final List<QueryResultItem.Builder> getResultItems() {
            List<QueryResultItem.Builder> result = QueryResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<QueryResultItem.BuilderImpl> resultItems) {
            this.resultItems = QueryResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<QueryResultItem> resultItems) {
            this.resultItems = QueryResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(QueryResultItem ... resultItems) {
            this.resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<QueryResultItem.Builder> ... resultItems) {
            this.resultItems(Stream.of(resultItems).map(c -> (QueryResultItem)((QueryResultItem.Builder)QueryResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FacetResult.Builder> getFacetResults() {
            List<FacetResult.Builder> result = FacetResultListCopier.copyToBuilder(this.facetResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFacetResults(Collection<FacetResult.BuilderImpl> facetResults) {
            this.facetResults = FacetResultListCopier.copyFromBuilder(facetResults);
        }

        @Override
        public final Builder facetResults(Collection<FacetResult> facetResults) {
            this.facetResults = FacetResultListCopier.copy(facetResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(FacetResult ... facetResults) {
            this.facetResults(Arrays.asList(facetResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder facetResults(Consumer<FacetResult.Builder> ... facetResults) {
            this.facetResults(Stream.of(facetResults).map(c -> (FacetResult)((FacetResult.Builder)FacetResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalNumberOfResults() {
            return this.totalNumberOfResults;
        }

        public final void setTotalNumberOfResults(Integer totalNumberOfResults) {
            this.totalNumberOfResults = totalNumberOfResults;
        }

        @Override
        public final Builder totalNumberOfResults(Integer totalNumberOfResults) {
            this.totalNumberOfResults = totalNumberOfResults;
            return this;
        }

        public final List<Warning.Builder> getWarnings() {
            List<Warning.Builder> result = WarningListCopier.copyToBuilder(this.warnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWarnings(Collection<Warning.BuilderImpl> warnings) {
            this.warnings = WarningListCopier.copyFromBuilder(warnings);
        }

        @Override
        public final Builder warnings(Collection<Warning> warnings) {
            this.warnings = WarningListCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Warning ... warnings) {
            this.warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<Warning.Builder> ... warnings) {
            this.warnings(Stream.of(warnings).map(c -> (Warning)((Warning.Builder)Warning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SpellCorrectedQuery.Builder> getSpellCorrectedQueries() {
            List<SpellCorrectedQuery.Builder> result = SpellCorrectedQueryListCopier.copyToBuilder(this.spellCorrectedQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSpellCorrectedQueries(Collection<SpellCorrectedQuery.BuilderImpl> spellCorrectedQueries) {
            this.spellCorrectedQueries = SpellCorrectedQueryListCopier.copyFromBuilder(spellCorrectedQueries);
        }

        @Override
        public final Builder spellCorrectedQueries(Collection<SpellCorrectedQuery> spellCorrectedQueries) {
            this.spellCorrectedQueries = SpellCorrectedQueryListCopier.copy(spellCorrectedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spellCorrectedQueries(SpellCorrectedQuery ... spellCorrectedQueries) {
            this.spellCorrectedQueries(Arrays.asList(spellCorrectedQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spellCorrectedQueries(Consumer<SpellCorrectedQuery.Builder> ... spellCorrectedQueries) {
            this.spellCorrectedQueries(Stream.of(spellCorrectedQueries).map(c -> (SpellCorrectedQuery)((SpellCorrectedQuery.Builder)SpellCorrectedQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FeaturedResultsItem.Builder> getFeaturedResultsItems() {
            List<FeaturedResultsItem.Builder> result = FeaturedResultsItemListCopier.copyToBuilder(this.featuredResultsItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedResultsItems(Collection<FeaturedResultsItem.BuilderImpl> featuredResultsItems) {
            this.featuredResultsItems = FeaturedResultsItemListCopier.copyFromBuilder(featuredResultsItems);
        }

        @Override
        public final Builder featuredResultsItems(Collection<FeaturedResultsItem> featuredResultsItems) {
            this.featuredResultsItems = FeaturedResultsItemListCopier.copy(featuredResultsItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsItems(FeaturedResultsItem ... featuredResultsItems) {
            this.featuredResultsItems(Arrays.asList(featuredResultsItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredResultsItems(Consumer<FeaturedResultsItem.Builder> ... featuredResultsItems) {
            this.featuredResultsItems(Stream.of(featuredResultsItems).map(c -> (FeaturedResultsItem)((FeaturedResultsItem.Builder)FeaturedResultsItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public QueryResponse build() {
            return new QueryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryResponse> {
        public Builder queryId(String var1);

        public Builder resultItems(Collection<QueryResultItem> var1);

        public Builder resultItems(QueryResultItem ... var1);

        public Builder resultItems(Consumer<QueryResultItem.Builder> ... var1);

        public Builder facetResults(Collection<FacetResult> var1);

        public Builder facetResults(FacetResult ... var1);

        public Builder facetResults(Consumer<FacetResult.Builder> ... var1);

        public Builder totalNumberOfResults(Integer var1);

        public Builder warnings(Collection<Warning> var1);

        public Builder warnings(Warning ... var1);

        public Builder warnings(Consumer<Warning.Builder> ... var1);

        public Builder spellCorrectedQueries(Collection<SpellCorrectedQuery> var1);

        public Builder spellCorrectedQueries(SpellCorrectedQuery ... var1);

        public Builder spellCorrectedQueries(Consumer<SpellCorrectedQuery.Builder> ... var1);

        public Builder featuredResultsItems(Collection<FeaturedResultsItem> var1);

        public Builder featuredResultsItems(FeaturedResultsItem ... var1);

        public Builder featuredResultsItems(Consumer<FeaturedResultsItem.Builder> ... var1);
    }
}

