/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.DataSourceSyncJobStatus;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSourceSyncJobsRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, ListDataSourceSyncJobsRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::id)).setter(ListDataSourceSyncJobsRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::indexId)).setter(ListDataSourceSyncJobsRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::nextToken)).setter(ListDataSourceSyncJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::maxResults)).setter(ListDataSourceSyncJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<TimeRange> START_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StartTimeFilter").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::startTimeFilter)).setter(ListDataSourceSyncJobsRequest.setter(Builder::startTimeFilter)).constructor(TimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimeFilter").build()}).build();
    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusFilter").getter(ListDataSourceSyncJobsRequest.getter(ListDataSourceSyncJobsRequest::statusFilterAsString)).setter(ListDataSourceSyncJobsRequest.setter(Builder::statusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, INDEX_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, START_TIME_FILTER_FIELD, STATUS_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataSourceSyncJobsRequest.memberNameToFieldInitializer();
    private final String id;
    private final String indexId;
    private final String nextToken;
    private final Integer maxResults;
    private final TimeRange startTimeFilter;
    private final String statusFilter;

    private ListDataSourceSyncJobsRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.indexId = builder.indexId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.startTimeFilter = builder.startTimeFilter;
        this.statusFilter = builder.statusFilter;
    }

    public final String id() {
        return this.id;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final TimeRange startTimeFilter() {
        return this.startTimeFilter;
    }

    public final DataSourceSyncJobStatus statusFilter() {
        return DataSourceSyncJobStatus.fromValue(this.statusFilter);
    }

    public final String statusFilterAsString() {
        return this.statusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusFilterAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourceSyncJobsRequest)) {
            return false;
        }
        ListDataSourceSyncJobsRequest other = (ListDataSourceSyncJobsRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.startTimeFilter(), other.startTimeFilter()) && Objects.equals(this.statusFilterAsString(), other.statusFilterAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataSourceSyncJobsRequest").add("Id", (Object)this.id()).add("IndexId", (Object)this.indexId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("StartTimeFilter", (Object)this.startTimeFilter()).add("StatusFilter", (Object)this.statusFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StartTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.startTimeFilter()));
            }
            case "StatusFilter": {
                return Optional.ofNullable(clazz.cast(this.statusFilterAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("StartTimeFilter", START_TIME_FILTER_FIELD);
        map.put("StatusFilter", STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourceSyncJobsRequest, T> g) {
        return obj -> g.apply((ListDataSourceSyncJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String id;
        private String indexId;
        private String nextToken;
        private Integer maxResults;
        private TimeRange startTimeFilter;
        private String statusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourceSyncJobsRequest model) {
            super(model);
            this.id(model.id);
            this.indexId(model.indexId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.startTimeFilter(model.startTimeFilter);
            this.statusFilter(model.statusFilter);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final TimeRange.Builder getStartTimeFilter() {
            return this.startTimeFilter != null ? this.startTimeFilter.toBuilder() : null;
        }

        public final void setStartTimeFilter(TimeRange.BuilderImpl startTimeFilter) {
            this.startTimeFilter = startTimeFilter != null ? startTimeFilter.build() : null;
        }

        @Override
        public final Builder startTimeFilter(TimeRange startTimeFilter) {
            this.startTimeFilter = startTimeFilter;
            return this;
        }

        public final String getStatusFilter() {
            return this.statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(DataSourceSyncJobStatus statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataSourceSyncJobsRequest build() {
            return new ListDataSourceSyncJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSourceSyncJobsRequest> {
        public Builder id(String var1);

        public Builder indexId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder startTimeFilter(TimeRange var1);

        default public Builder startTimeFilter(Consumer<TimeRange.Builder> startTimeFilter) {
            return this.startTimeFilter((TimeRange)((TimeRange.Builder)TimeRange.builder().applyMutation(startTimeFilter)).build());
        }

        public Builder statusFilter(String var1);

        public Builder statusFilter(DataSourceSyncJobStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

