/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.Principal;
import software.amazon.awssdk.services.kendra.model.PrincipalListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HierarchicalPrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HierarchicalPrincipal> {
    private static final SdkField<List<Principal>> PRINCIPAL_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrincipalList").getter(HierarchicalPrincipal.getter(HierarchicalPrincipal::principalList)).setter(HierarchicalPrincipal.setter(Builder::principalList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Principal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HierarchicalPrincipal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Principal> principalList;

    private HierarchicalPrincipal(BuilderImpl builder) {
        this.principalList = builder.principalList;
    }

    public final boolean hasPrincipalList() {
        return this.principalList != null && !(this.principalList instanceof SdkAutoConstructList);
    }

    public final List<Principal> principalList() {
        return this.principalList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrincipalList() ? this.principalList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HierarchicalPrincipal)) {
            return false;
        }
        HierarchicalPrincipal other = (HierarchicalPrincipal)obj;
        return this.hasPrincipalList() == other.hasPrincipalList() && Objects.equals(this.principalList(), other.principalList());
    }

    public final String toString() {
        return ToString.builder((String)"HierarchicalPrincipal").add("PrincipalList", this.hasPrincipalList() ? this.principalList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrincipalList": {
                return Optional.ofNullable(clazz.cast(this.principalList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Principal>>> map = new HashMap<String, SdkField<List<Principal>>>();
        map.put("PrincipalList", PRINCIPAL_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HierarchicalPrincipal, T> g) {
        return obj -> g.apply((HierarchicalPrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Principal> principalList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HierarchicalPrincipal model) {
            this.principalList(model.principalList);
        }

        public final List<Principal.Builder> getPrincipalList() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.principalList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrincipalList(Collection<Principal.BuilderImpl> principalList) {
            this.principalList = PrincipalListCopier.copyFromBuilder(principalList);
        }

        @Override
        public final Builder principalList(Collection<Principal> principalList) {
            this.principalList = PrincipalListCopier.copy(principalList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalList(Principal ... principalList) {
            this.principalList(Arrays.asList(principalList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalList(Consumer<Principal.Builder> ... principalList) {
            this.principalList(Stream.of(principalList).map(c -> (Principal)((Principal.Builder)Principal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public HierarchicalPrincipal build() {
            return new HierarchicalPrincipal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HierarchicalPrincipal> {
        public Builder principalList(Collection<Principal> var1);

        public Builder principalList(Principal ... var1);

        public Builder principalList(Consumer<Principal.Builder> ... var1);
    }
}

