/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.ExpandConfiguration;
import software.amazon.awssdk.services.kendra.model.MissingAttributeKeyStrategy;
import software.amazon.awssdk.services.kendra.model.SortingConfiguration;
import software.amazon.awssdk.services.kendra.model.SortingConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollapseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollapseConfiguration> {
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentAttributeKey").getter(CollapseConfiguration.getter(CollapseConfiguration::documentAttributeKey)).setter(CollapseConfiguration.setter(Builder::documentAttributeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeKey").build()}).build();
    private static final SdkField<List<SortingConfiguration>> SORTING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortingConfigurations").getter(CollapseConfiguration.getter(CollapseConfiguration::sortingConfigurations)).setter(CollapseConfiguration.setter(Builder::sortingConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortingConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SortingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MISSING_ATTRIBUTE_KEY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MissingAttributeKeyStrategy").getter(CollapseConfiguration.getter(CollapseConfiguration::missingAttributeKeyStrategyAsString)).setter(CollapseConfiguration.setter(Builder::missingAttributeKeyStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingAttributeKeyStrategy").build()}).build();
    private static final SdkField<Boolean> EXPAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Expand").getter(CollapseConfiguration.getter(CollapseConfiguration::expand)).setter(CollapseConfiguration.setter(Builder::expand)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expand").build()}).build();
    private static final SdkField<ExpandConfiguration> EXPAND_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExpandConfiguration").getter(CollapseConfiguration.getter(CollapseConfiguration::expandConfiguration)).setter(CollapseConfiguration.setter(Builder::expandConfiguration)).constructor(ExpandConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpandConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_KEY_FIELD, SORTING_CONFIGURATIONS_FIELD, MISSING_ATTRIBUTE_KEY_STRATEGY_FIELD, EXPAND_FIELD, EXPAND_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollapseConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String documentAttributeKey;
    private final List<SortingConfiguration> sortingConfigurations;
    private final String missingAttributeKeyStrategy;
    private final Boolean expand;
    private final ExpandConfiguration expandConfiguration;

    private CollapseConfiguration(BuilderImpl builder) {
        this.documentAttributeKey = builder.documentAttributeKey;
        this.sortingConfigurations = builder.sortingConfigurations;
        this.missingAttributeKeyStrategy = builder.missingAttributeKeyStrategy;
        this.expand = builder.expand;
        this.expandConfiguration = builder.expandConfiguration;
    }

    public final String documentAttributeKey() {
        return this.documentAttributeKey;
    }

    public final boolean hasSortingConfigurations() {
        return this.sortingConfigurations != null && !(this.sortingConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SortingConfiguration> sortingConfigurations() {
        return this.sortingConfigurations;
    }

    public final MissingAttributeKeyStrategy missingAttributeKeyStrategy() {
        return MissingAttributeKeyStrategy.fromValue(this.missingAttributeKeyStrategy);
    }

    public final String missingAttributeKeyStrategyAsString() {
        return this.missingAttributeKeyStrategy;
    }

    public final Boolean expand() {
        return this.expand;
    }

    public final ExpandConfiguration expandConfiguration() {
        return this.expandConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortingConfigurations() ? this.sortingConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.missingAttributeKeyStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expand());
        hashCode = 31 * hashCode + Objects.hashCode(this.expandConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollapseConfiguration)) {
            return false;
        }
        CollapseConfiguration other = (CollapseConfiguration)obj;
        return Objects.equals(this.documentAttributeKey(), other.documentAttributeKey()) && this.hasSortingConfigurations() == other.hasSortingConfigurations() && Objects.equals(this.sortingConfigurations(), other.sortingConfigurations()) && Objects.equals(this.missingAttributeKeyStrategyAsString(), other.missingAttributeKeyStrategyAsString()) && Objects.equals(this.expand(), other.expand()) && Objects.equals(this.expandConfiguration(), other.expandConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CollapseConfiguration").add("DocumentAttributeKey", (Object)this.documentAttributeKey()).add("SortingConfigurations", this.hasSortingConfigurations() ? this.sortingConfigurations() : null).add("MissingAttributeKeyStrategy", (Object)this.missingAttributeKeyStrategyAsString()).add("Expand", (Object)this.expand()).add("ExpandConfiguration", (Object)this.expandConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentAttributeKey": {
                return Optional.ofNullable(clazz.cast(this.documentAttributeKey()));
            }
            case "SortingConfigurations": {
                return Optional.ofNullable(clazz.cast(this.sortingConfigurations()));
            }
            case "MissingAttributeKeyStrategy": {
                return Optional.ofNullable(clazz.cast(this.missingAttributeKeyStrategyAsString()));
            }
            case "Expand": {
                return Optional.ofNullable(clazz.cast(this.expand()));
            }
            case "ExpandConfiguration": {
                return Optional.ofNullable(clazz.cast(this.expandConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentAttributeKey", DOCUMENT_ATTRIBUTE_KEY_FIELD);
        map.put("SortingConfigurations", SORTING_CONFIGURATIONS_FIELD);
        map.put("MissingAttributeKeyStrategy", MISSING_ATTRIBUTE_KEY_STRATEGY_FIELD);
        map.put("Expand", EXPAND_FIELD);
        map.put("ExpandConfiguration", EXPAND_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollapseConfiguration, T> g) {
        return obj -> g.apply((CollapseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentAttributeKey;
        private List<SortingConfiguration> sortingConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String missingAttributeKeyStrategy;
        private Boolean expand;
        private ExpandConfiguration expandConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CollapseConfiguration model) {
            this.documentAttributeKey(model.documentAttributeKey);
            this.sortingConfigurations(model.sortingConfigurations);
            this.missingAttributeKeyStrategy(model.missingAttributeKeyStrategy);
            this.expand(model.expand);
            this.expandConfiguration(model.expandConfiguration);
        }

        public final String getDocumentAttributeKey() {
            return this.documentAttributeKey;
        }

        public final void setDocumentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
        }

        @Override
        public final Builder documentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
            return this;
        }

        public final List<SortingConfiguration.Builder> getSortingConfigurations() {
            List<SortingConfiguration.Builder> result = SortingConfigurationListCopier.copyToBuilder(this.sortingConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortingConfigurations(Collection<SortingConfiguration.BuilderImpl> sortingConfigurations) {
            this.sortingConfigurations = SortingConfigurationListCopier.copyFromBuilder(sortingConfigurations);
        }

        @Override
        public final Builder sortingConfigurations(Collection<SortingConfiguration> sortingConfigurations) {
            this.sortingConfigurations = SortingConfigurationListCopier.copy(sortingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingConfigurations(SortingConfiguration ... sortingConfigurations) {
            this.sortingConfigurations(Arrays.asList(sortingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortingConfigurations(Consumer<SortingConfiguration.Builder> ... sortingConfigurations) {
            this.sortingConfigurations(Stream.of(sortingConfigurations).map(c -> (SortingConfiguration)((SortingConfiguration.Builder)SortingConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMissingAttributeKeyStrategy() {
            return this.missingAttributeKeyStrategy;
        }

        public final void setMissingAttributeKeyStrategy(String missingAttributeKeyStrategy) {
            this.missingAttributeKeyStrategy = missingAttributeKeyStrategy;
        }

        @Override
        public final Builder missingAttributeKeyStrategy(String missingAttributeKeyStrategy) {
            this.missingAttributeKeyStrategy = missingAttributeKeyStrategy;
            return this;
        }

        @Override
        public final Builder missingAttributeKeyStrategy(MissingAttributeKeyStrategy missingAttributeKeyStrategy) {
            this.missingAttributeKeyStrategy(missingAttributeKeyStrategy == null ? null : missingAttributeKeyStrategy.toString());
            return this;
        }

        public final Boolean getExpand() {
            return this.expand;
        }

        public final void setExpand(Boolean expand) {
            this.expand = expand;
        }

        @Override
        public final Builder expand(Boolean expand) {
            this.expand = expand;
            return this;
        }

        public final ExpandConfiguration.Builder getExpandConfiguration() {
            return this.expandConfiguration != null ? this.expandConfiguration.toBuilder() : null;
        }

        public final void setExpandConfiguration(ExpandConfiguration.BuilderImpl expandConfiguration) {
            this.expandConfiguration = expandConfiguration != null ? expandConfiguration.build() : null;
        }

        @Override
        public final Builder expandConfiguration(ExpandConfiguration expandConfiguration) {
            this.expandConfiguration = expandConfiguration;
            return this;
        }

        public CollapseConfiguration build() {
            return new CollapseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollapseConfiguration> {
        public Builder documentAttributeKey(String var1);

        public Builder sortingConfigurations(Collection<SortingConfiguration> var1);

        public Builder sortingConfigurations(SortingConfiguration ... var1);

        public Builder sortingConfigurations(Consumer<SortingConfiguration.Builder> ... var1);

        public Builder missingAttributeKeyStrategy(String var1);

        public Builder missingAttributeKeyStrategy(MissingAttributeKeyStrategy var1);

        public Builder expand(Boolean var1);

        public Builder expandConfiguration(ExpandConfiguration var1);

        default public Builder expandConfiguration(Consumer<ExpandConfiguration.Builder> expandConfiguration) {
            return this.expandConfiguration((ExpandConfiguration)((ExpandConfiguration.Builder)ExpandConfiguration.builder().applyMutation(expandConfiguration)).build());
        }
    }
}

