/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SuggestionType {
    QUERY("QUERY"),
    DOCUMENT_ATTRIBUTES("DOCUMENT_ATTRIBUTES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SuggestionType> VALUE_MAP;
    private final String value;

    private SuggestionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SuggestionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SuggestionType> knownValues() {
        EnumSet<SuggestionType> knownValues = EnumSet.allOf(SuggestionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SuggestionType.class, SuggestionType::toString);
    }
}

