/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceNowAuthenticationType {
    HTTP_BASIC("HTTP_BASIC"),
    OAUTH2("OAUTH2"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceNowAuthenticationType> VALUE_MAP;
    private final String value;

    private ServiceNowAuthenticationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceNowAuthenticationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceNowAuthenticationType> knownValues() {
        EnumSet<ServiceNowAuthenticationType> knownValues = EnumSet.allOf(ServiceNowAuthenticationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceNowAuthenticationType.class, ServiceNowAuthenticationType::toString);
    }
}

