/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceStandardKnowledgeArticleTypeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceStandardKnowledgeArticleTypeConfiguration> {
    private static final SdkField<String> DOCUMENT_DATA_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentDataFieldName").getter(SalesforceStandardKnowledgeArticleTypeConfiguration.getter(SalesforceStandardKnowledgeArticleTypeConfiguration::documentDataFieldName)).setter(SalesforceStandardKnowledgeArticleTypeConfiguration.setter(Builder::documentDataFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentDataFieldName").build()}).build();
    private static final SdkField<String> DOCUMENT_TITLE_FIELD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentTitleFieldName").getter(SalesforceStandardKnowledgeArticleTypeConfiguration.getter(SalesforceStandardKnowledgeArticleTypeConfiguration::documentTitleFieldName)).setter(SalesforceStandardKnowledgeArticleTypeConfiguration.setter(Builder::documentTitleFieldName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitleFieldName").build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FieldMappings").getter(SalesforceStandardKnowledgeArticleTypeConfiguration.getter(SalesforceStandardKnowledgeArticleTypeConfiguration::fieldMappings)).setter(SalesforceStandardKnowledgeArticleTypeConfiguration.setter(Builder::fieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_DATA_FIELD_NAME_FIELD, DOCUMENT_TITLE_FIELD_NAME_FIELD, FIELD_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SalesforceStandardKnowledgeArticleTypeConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String documentDataFieldName;
    private final String documentTitleFieldName;
    private final List<DataSourceToIndexFieldMapping> fieldMappings;

    private SalesforceStandardKnowledgeArticleTypeConfiguration(BuilderImpl builder) {
        this.documentDataFieldName = builder.documentDataFieldName;
        this.documentTitleFieldName = builder.documentTitleFieldName;
        this.fieldMappings = builder.fieldMappings;
    }

    public final String documentDataFieldName() {
        return this.documentDataFieldName;
    }

    public final String documentTitleFieldName() {
        return this.documentTitleFieldName;
    }

    public final boolean hasFieldMappings() {
        return this.fieldMappings != null && !(this.fieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> fieldMappings() {
        return this.fieldMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDataFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentTitleFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFieldMappings() ? this.fieldMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceStandardKnowledgeArticleTypeConfiguration)) {
            return false;
        }
        SalesforceStandardKnowledgeArticleTypeConfiguration other = (SalesforceStandardKnowledgeArticleTypeConfiguration)obj;
        return Objects.equals(this.documentDataFieldName(), other.documentDataFieldName()) && Objects.equals(this.documentTitleFieldName(), other.documentTitleFieldName()) && this.hasFieldMappings() == other.hasFieldMappings() && Objects.equals(this.fieldMappings(), other.fieldMappings());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceStandardKnowledgeArticleTypeConfiguration").add("DocumentDataFieldName", (Object)this.documentDataFieldName()).add("DocumentTitleFieldName", (Object)this.documentTitleFieldName()).add("FieldMappings", this.hasFieldMappings() ? this.fieldMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentDataFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentDataFieldName()));
            }
            case "DocumentTitleFieldName": {
                return Optional.ofNullable(clazz.cast(this.documentTitleFieldName()));
            }
            case "FieldMappings": {
                return Optional.ofNullable(clazz.cast(this.fieldMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentDataFieldName", DOCUMENT_DATA_FIELD_NAME_FIELD);
        map.put("DocumentTitleFieldName", DOCUMENT_TITLE_FIELD_NAME_FIELD);
        map.put("FieldMappings", FIELD_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SalesforceStandardKnowledgeArticleTypeConfiguration, T> g) {
        return obj -> g.apply((SalesforceStandardKnowledgeArticleTypeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String documentDataFieldName;
        private String documentTitleFieldName;
        private List<DataSourceToIndexFieldMapping> fieldMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceStandardKnowledgeArticleTypeConfiguration model) {
            this.documentDataFieldName(model.documentDataFieldName);
            this.documentTitleFieldName(model.documentTitleFieldName);
            this.fieldMappings(model.fieldMappings);
        }

        public final String getDocumentDataFieldName() {
            return this.documentDataFieldName;
        }

        public final void setDocumentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
        }

        @Override
        public final Builder documentDataFieldName(String documentDataFieldName) {
            this.documentDataFieldName = documentDataFieldName;
            return this;
        }

        public final String getDocumentTitleFieldName() {
            return this.documentTitleFieldName;
        }

        public final void setDocumentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
        }

        @Override
        public final Builder documentTitleFieldName(String documentTitleFieldName) {
            this.documentTitleFieldName = documentTitleFieldName;
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.fieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(fieldMappings);
        }

        @Override
        public final Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> fieldMappings) {
            this.fieldMappings = DataSourceToIndexFieldMappingListCopier.copy(fieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(DataSourceToIndexFieldMapping ... fieldMappings) {
            this.fieldMappings(Arrays.asList(fieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... fieldMappings) {
            this.fieldMappings(Stream.of(fieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SalesforceStandardKnowledgeArticleTypeConfiguration build() {
            return new SalesforceStandardKnowledgeArticleTypeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceStandardKnowledgeArticleTypeConfiguration> {
        public Builder documentDataFieldName(String var1);

        public Builder documentTitleFieldName(String var1);

        public Builder fieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder fieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder fieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);
    }
}

