/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissing;
import software.amazon.awssdk.services.kendra.model.FeaturedDocumentMissingListCopier;
import software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadata;
import software.amazon.awssdk.services.kendra.model.FeaturedDocumentWithMetadataListCopier;
import software.amazon.awssdk.services.kendra.model.FeaturedResultsSetStatus;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.QueryTextListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFeaturedResultsSetResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, DescribeFeaturedResultsSetResponse> {
    private static final SdkField<String> FEATURED_RESULTS_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeaturedResultsSetId").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::featuredResultsSetId)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::featuredResultsSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetId").build()}).build();
    private static final SdkField<String> FEATURED_RESULTS_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeaturedResultsSetName").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::featuredResultsSetName)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::featuredResultsSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedResultsSetName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::description)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::statusAsString)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> QUERY_TEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryTexts").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::queryTexts)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::queryTexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryTexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FeaturedDocumentWithMetadata>> FEATURED_DOCUMENTS_WITH_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeaturedDocumentsWithMetadata").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::featuredDocumentsWithMetadata)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::featuredDocumentsWithMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedDocumentsWithMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeaturedDocumentWithMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FeaturedDocumentMissing>> FEATURED_DOCUMENTS_MISSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeaturedDocumentsMissing").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::featuredDocumentsMissing)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::featuredDocumentsMissing)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturedDocumentsMissing").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FeaturedDocumentMissing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> LAST_UPDATED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastUpdatedTimestamp").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::lastUpdatedTimestamp)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::lastUpdatedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTimestamp").build()}).build();
    private static final SdkField<Long> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreationTimestamp").getter(DescribeFeaturedResultsSetResponse.getter(DescribeFeaturedResultsSetResponse::creationTimestamp)).setter(DescribeFeaturedResultsSetResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURED_RESULTS_SET_ID_FIELD, FEATURED_RESULTS_SET_NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, QUERY_TEXTS_FIELD, FEATURED_DOCUMENTS_WITH_METADATA_FIELD, FEATURED_DOCUMENTS_MISSING_FIELD, LAST_UPDATED_TIMESTAMP_FIELD, CREATION_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeFeaturedResultsSetResponse.memberNameToFieldInitializer();
    private final String featuredResultsSetId;
    private final String featuredResultsSetName;
    private final String description;
    private final String status;
    private final List<String> queryTexts;
    private final List<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata;
    private final List<FeaturedDocumentMissing> featuredDocumentsMissing;
    private final Long lastUpdatedTimestamp;
    private final Long creationTimestamp;

    private DescribeFeaturedResultsSetResponse(BuilderImpl builder) {
        super(builder);
        this.featuredResultsSetId = builder.featuredResultsSetId;
        this.featuredResultsSetName = builder.featuredResultsSetName;
        this.description = builder.description;
        this.status = builder.status;
        this.queryTexts = builder.queryTexts;
        this.featuredDocumentsWithMetadata = builder.featuredDocumentsWithMetadata;
        this.featuredDocumentsMissing = builder.featuredDocumentsMissing;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.creationTimestamp = builder.creationTimestamp;
    }

    public final String featuredResultsSetId() {
        return this.featuredResultsSetId;
    }

    public final String featuredResultsSetName() {
        return this.featuredResultsSetName;
    }

    public final String description() {
        return this.description;
    }

    public final FeaturedResultsSetStatus status() {
        return FeaturedResultsSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasQueryTexts() {
        return this.queryTexts != null && !(this.queryTexts instanceof SdkAutoConstructList);
    }

    public final List<String> queryTexts() {
        return this.queryTexts;
    }

    public final boolean hasFeaturedDocumentsWithMetadata() {
        return this.featuredDocumentsWithMetadata != null && !(this.featuredDocumentsWithMetadata instanceof SdkAutoConstructList);
    }

    public final List<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata() {
        return this.featuredDocumentsWithMetadata;
    }

    public final boolean hasFeaturedDocumentsMissing() {
        return this.featuredDocumentsMissing != null && !(this.featuredDocumentsMissing instanceof SdkAutoConstructList);
    }

    public final List<FeaturedDocumentMissing> featuredDocumentsMissing() {
        return this.featuredDocumentsMissing;
    }

    public final Long lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public final Long creationTimestamp() {
        return this.creationTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.featuredResultsSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.featuredResultsSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryTexts() ? this.queryTexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeaturedDocumentsWithMetadata() ? this.featuredDocumentsWithMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeaturedDocumentsMissing() ? this.featuredDocumentsMissing() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFeaturedResultsSetResponse)) {
            return false;
        }
        DescribeFeaturedResultsSetResponse other = (DescribeFeaturedResultsSetResponse)((Object)obj);
        return Objects.equals(this.featuredResultsSetId(), other.featuredResultsSetId()) && Objects.equals(this.featuredResultsSetName(), other.featuredResultsSetName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasQueryTexts() == other.hasQueryTexts() && Objects.equals(this.queryTexts(), other.queryTexts()) && this.hasFeaturedDocumentsWithMetadata() == other.hasFeaturedDocumentsWithMetadata() && Objects.equals(this.featuredDocumentsWithMetadata(), other.featuredDocumentsWithMetadata()) && this.hasFeaturedDocumentsMissing() == other.hasFeaturedDocumentsMissing() && Objects.equals(this.featuredDocumentsMissing(), other.featuredDocumentsMissing()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeFeaturedResultsSetResponse").add("FeaturedResultsSetId", (Object)this.featuredResultsSetId()).add("FeaturedResultsSetName", (Object)this.featuredResultsSetName()).add("Description", (Object)this.description()).add("Status", (Object)this.statusAsString()).add("QueryTexts", this.hasQueryTexts() ? this.queryTexts() : null).add("FeaturedDocumentsWithMetadata", this.hasFeaturedDocumentsWithMetadata() ? this.featuredDocumentsWithMetadata() : null).add("FeaturedDocumentsMissing", this.hasFeaturedDocumentsMissing() ? this.featuredDocumentsMissing() : null).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("CreationTimestamp", (Object)this.creationTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeaturedResultsSetId": {
                return Optional.ofNullable(clazz.cast(this.featuredResultsSetId()));
            }
            case "FeaturedResultsSetName": {
                return Optional.ofNullable(clazz.cast(this.featuredResultsSetName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "QueryTexts": {
                return Optional.ofNullable(clazz.cast(this.queryTexts()));
            }
            case "FeaturedDocumentsWithMetadata": {
                return Optional.ofNullable(clazz.cast(this.featuredDocumentsWithMetadata()));
            }
            case "FeaturedDocumentsMissing": {
                return Optional.ofNullable(clazz.cast(this.featuredDocumentsMissing()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FeaturedResultsSetId", FEATURED_RESULTS_SET_ID_FIELD);
        map.put("FeaturedResultsSetName", FEATURED_RESULTS_SET_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("QueryTexts", QUERY_TEXTS_FIELD);
        map.put("FeaturedDocumentsWithMetadata", FEATURED_DOCUMENTS_WITH_METADATA_FIELD);
        map.put("FeaturedDocumentsMissing", FEATURED_DOCUMENTS_MISSING_FIELD);
        map.put("LastUpdatedTimestamp", LAST_UPDATED_TIMESTAMP_FIELD);
        map.put("CreationTimestamp", CREATION_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFeaturedResultsSetResponse, T> g) {
        return obj -> g.apply((DescribeFeaturedResultsSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String featuredResultsSetId;
        private String featuredResultsSetName;
        private String description;
        private String status;
        private List<String> queryTexts = DefaultSdkAutoConstructList.getInstance();
        private List<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata = DefaultSdkAutoConstructList.getInstance();
        private List<FeaturedDocumentMissing> featuredDocumentsMissing = DefaultSdkAutoConstructList.getInstance();
        private Long lastUpdatedTimestamp;
        private Long creationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFeaturedResultsSetResponse model) {
            super(model);
            this.featuredResultsSetId(model.featuredResultsSetId);
            this.featuredResultsSetName(model.featuredResultsSetName);
            this.description(model.description);
            this.status(model.status);
            this.queryTexts(model.queryTexts);
            this.featuredDocumentsWithMetadata(model.featuredDocumentsWithMetadata);
            this.featuredDocumentsMissing(model.featuredDocumentsMissing);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.creationTimestamp(model.creationTimestamp);
        }

        public final String getFeaturedResultsSetId() {
            return this.featuredResultsSetId;
        }

        public final void setFeaturedResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
        }

        @Override
        public final Builder featuredResultsSetId(String featuredResultsSetId) {
            this.featuredResultsSetId = featuredResultsSetId;
            return this;
        }

        public final String getFeaturedResultsSetName() {
            return this.featuredResultsSetName;
        }

        public final void setFeaturedResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
        }

        @Override
        public final Builder featuredResultsSetName(String featuredResultsSetName) {
            this.featuredResultsSetName = featuredResultsSetName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FeaturedResultsSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getQueryTexts() {
            if (this.queryTexts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.queryTexts;
        }

        public final void setQueryTexts(Collection<String> queryTexts) {
            this.queryTexts = QueryTextListCopier.copy(queryTexts);
        }

        @Override
        public final Builder queryTexts(Collection<String> queryTexts) {
            this.queryTexts = QueryTextListCopier.copy(queryTexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryTexts(String ... queryTexts) {
            this.queryTexts(Arrays.asList(queryTexts));
            return this;
        }

        public final List<FeaturedDocumentWithMetadata.Builder> getFeaturedDocumentsWithMetadata() {
            List<FeaturedDocumentWithMetadata.Builder> result = FeaturedDocumentWithMetadataListCopier.copyToBuilder(this.featuredDocumentsWithMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedDocumentsWithMetadata(Collection<FeaturedDocumentWithMetadata.BuilderImpl> featuredDocumentsWithMetadata) {
            this.featuredDocumentsWithMetadata = FeaturedDocumentWithMetadataListCopier.copyFromBuilder(featuredDocumentsWithMetadata);
        }

        @Override
        public final Builder featuredDocumentsWithMetadata(Collection<FeaturedDocumentWithMetadata> featuredDocumentsWithMetadata) {
            this.featuredDocumentsWithMetadata = FeaturedDocumentWithMetadataListCopier.copy(featuredDocumentsWithMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocumentsWithMetadata(FeaturedDocumentWithMetadata ... featuredDocumentsWithMetadata) {
            this.featuredDocumentsWithMetadata(Arrays.asList(featuredDocumentsWithMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocumentsWithMetadata(Consumer<FeaturedDocumentWithMetadata.Builder> ... featuredDocumentsWithMetadata) {
            this.featuredDocumentsWithMetadata(Stream.of(featuredDocumentsWithMetadata).map(c -> (FeaturedDocumentWithMetadata)((FeaturedDocumentWithMetadata.Builder)FeaturedDocumentWithMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FeaturedDocumentMissing.Builder> getFeaturedDocumentsMissing() {
            List<FeaturedDocumentMissing.Builder> result = FeaturedDocumentMissingListCopier.copyToBuilder(this.featuredDocumentsMissing);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturedDocumentsMissing(Collection<FeaturedDocumentMissing.BuilderImpl> featuredDocumentsMissing) {
            this.featuredDocumentsMissing = FeaturedDocumentMissingListCopier.copyFromBuilder(featuredDocumentsMissing);
        }

        @Override
        public final Builder featuredDocumentsMissing(Collection<FeaturedDocumentMissing> featuredDocumentsMissing) {
            this.featuredDocumentsMissing = FeaturedDocumentMissingListCopier.copy(featuredDocumentsMissing);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocumentsMissing(FeaturedDocumentMissing ... featuredDocumentsMissing) {
            this.featuredDocumentsMissing(Arrays.asList(featuredDocumentsMissing));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featuredDocumentsMissing(Consumer<FeaturedDocumentMissing.Builder> ... featuredDocumentsMissing) {
            this.featuredDocumentsMissing(Stream.of(featuredDocumentsMissing).map(c -> (FeaturedDocumentMissing)((FeaturedDocumentMissing.Builder)FeaturedDocumentMissing.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        public final void setLastUpdatedTimestamp(Long lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Long lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final Long getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        @Override
        public DescribeFeaturedResultsSetResponse build() {
            return new DescribeFeaturedResultsSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFeaturedResultsSetResponse> {
        public Builder featuredResultsSetId(String var1);

        public Builder featuredResultsSetName(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder status(FeaturedResultsSetStatus var1);

        public Builder queryTexts(Collection<String> var1);

        public Builder queryTexts(String ... var1);

        public Builder featuredDocumentsWithMetadata(Collection<FeaturedDocumentWithMetadata> var1);

        public Builder featuredDocumentsWithMetadata(FeaturedDocumentWithMetadata ... var1);

        public Builder featuredDocumentsWithMetadata(Consumer<FeaturedDocumentWithMetadata.Builder> ... var1);

        public Builder featuredDocumentsMissing(Collection<FeaturedDocumentMissing> var1);

        public Builder featuredDocumentsMissing(FeaturedDocumentMissing ... var1);

        public Builder featuredDocumentsMissing(Consumer<FeaturedDocumentMissing.Builder> ... var1);

        public Builder lastUpdatedTimestamp(Long var1);

        public Builder creationTimestamp(Long var1);
    }
}

