/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.IndexEdition;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.services.kendra.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.kendra.model.Tag;
import software.amazon.awssdk.services.kendra.model.TagListCopier;
import software.amazon.awssdk.services.kendra.model.UserContextPolicy;
import software.amazon.awssdk.services.kendra.model.UserGroupResolutionConfiguration;
import software.amazon.awssdk.services.kendra.model.UserTokenConfiguration;
import software.amazon.awssdk.services.kendra.model.UserTokenConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIndexRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, CreateIndexRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateIndexRequest.getter(CreateIndexRequest::name)).setter(CreateIndexRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Edition").getter(CreateIndexRequest.getter(CreateIndexRequest::editionAsString)).setter(CreateIndexRequest.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateIndexRequest.getter(CreateIndexRequest::roleArn)).setter(CreateIndexRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerSideEncryptionConfiguration").getter(CreateIndexRequest.getter(CreateIndexRequest::serverSideEncryptionConfiguration)).setter(CreateIndexRequest.setter(Builder::serverSideEncryptionConfiguration)).constructor(ServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideEncryptionConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateIndexRequest.getter(CreateIndexRequest::description)).setter(CreateIndexRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateIndexRequest.getter(CreateIndexRequest::clientToken)).setter(CreateIndexRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateIndexRequest.getter(CreateIndexRequest::tags)).setter(CreateIndexRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UserTokenConfiguration>> USER_TOKEN_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserTokenConfigurations").getter(CreateIndexRequest.getter(CreateIndexRequest::userTokenConfigurations)).setter(CreateIndexRequest.setter(Builder::userTokenConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserTokenConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserTokenConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> USER_CONTEXT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserContextPolicy").getter(CreateIndexRequest.getter(CreateIndexRequest::userContextPolicyAsString)).setter(CreateIndexRequest.setter(Builder::userContextPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserContextPolicy").build()}).build();
    private static final SdkField<UserGroupResolutionConfiguration> USER_GROUP_RESOLUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserGroupResolutionConfiguration").getter(CreateIndexRequest.getter(CreateIndexRequest::userGroupResolutionConfiguration)).setter(CreateIndexRequest.setter(Builder::userGroupResolutionConfiguration)).constructor(UserGroupResolutionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroupResolutionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, EDITION_FIELD, ROLE_ARN_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, USER_TOKEN_CONFIGURATIONS_FIELD, USER_CONTEXT_POLICY_FIELD, USER_GROUP_RESOLUTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateIndexRequest.memberNameToFieldInitializer();
    private final String name;
    private final String edition;
    private final String roleArn;
    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final String description;
    private final String clientToken;
    private final List<Tag> tags;
    private final List<UserTokenConfiguration> userTokenConfigurations;
    private final String userContextPolicy;
    private final UserGroupResolutionConfiguration userGroupResolutionConfiguration;

    private CreateIndexRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.edition = builder.edition;
        this.roleArn = builder.roleArn;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.userTokenConfigurations = builder.userTokenConfigurations;
        this.userContextPolicy = builder.userContextPolicy;
        this.userGroupResolutionConfiguration = builder.userGroupResolutionConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final IndexEdition edition() {
        return IndexEdition.fromValue(this.edition);
    }

    public final String editionAsString() {
        return this.edition;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasUserTokenConfigurations() {
        return this.userTokenConfigurations != null && !(this.userTokenConfigurations instanceof SdkAutoConstructList);
    }

    public final List<UserTokenConfiguration> userTokenConfigurations() {
        return this.userTokenConfigurations;
    }

    public final UserContextPolicy userContextPolicy() {
        return UserContextPolicy.fromValue(this.userContextPolicy);
    }

    public final String userContextPolicyAsString() {
        return this.userContextPolicy;
    }

    public final UserGroupResolutionConfiguration userGroupResolutionConfiguration() {
        return this.userGroupResolutionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserTokenConfigurations() ? this.userTokenConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.userContextPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupResolutionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIndexRequest)) {
            return false;
        }
        CreateIndexRequest other = (CreateIndexRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.editionAsString(), other.editionAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasUserTokenConfigurations() == other.hasUserTokenConfigurations() && Objects.equals(this.userTokenConfigurations(), other.userTokenConfigurations()) && Objects.equals(this.userContextPolicyAsString(), other.userContextPolicyAsString()) && Objects.equals(this.userGroupResolutionConfiguration(), other.userGroupResolutionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIndexRequest").add("Name", (Object)this.name()).add("Edition", (Object)this.editionAsString()).add("RoleArn", (Object)this.roleArn()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("Description", (Object)this.description()).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("UserTokenConfigurations", this.hasUserTokenConfigurations() ? this.userTokenConfigurations() : null).add("UserContextPolicy", (Object)this.userContextPolicyAsString()).add("UserGroupResolutionConfiguration", (Object)this.userGroupResolutionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ServerSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UserTokenConfigurations": {
                return Optional.ofNullable(clazz.cast(this.userTokenConfigurations()));
            }
            case "UserContextPolicy": {
                return Optional.ofNullable(clazz.cast(this.userContextPolicyAsString()));
            }
            case "UserGroupResolutionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.userGroupResolutionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Edition", EDITION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ServerSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("UserTokenConfigurations", USER_TOKEN_CONFIGURATIONS_FIELD);
        map.put("UserContextPolicy", USER_CONTEXT_POLICY_FIELD);
        map.put("UserGroupResolutionConfiguration", USER_GROUP_RESOLUTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIndexRequest, T> g) {
        return obj -> g.apply((CreateIndexRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String name;
        private String edition;
        private String roleArn;
        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private String description;
        private String clientToken;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<UserTokenConfiguration> userTokenConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String userContextPolicy;
        private UserGroupResolutionConfiguration userGroupResolutionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIndexRequest model) {
            super(model);
            this.name(model.name);
            this.edition(model.edition);
            this.roleArn(model.roleArn);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.description(model.description);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.userTokenConfigurations(model.userTokenConfigurations);
            this.userContextPolicy(model.userContextPolicy);
            this.userGroupResolutionConfiguration(model.userGroupResolutionConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEdition() {
            return this.edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(IndexEdition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UserTokenConfiguration.Builder> getUserTokenConfigurations() {
            List<UserTokenConfiguration.Builder> result = UserTokenConfigurationListCopier.copyToBuilder(this.userTokenConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserTokenConfigurations(Collection<UserTokenConfiguration.BuilderImpl> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copyFromBuilder(userTokenConfigurations);
        }

        @Override
        public final Builder userTokenConfigurations(Collection<UserTokenConfiguration> userTokenConfigurations) {
            this.userTokenConfigurations = UserTokenConfigurationListCopier.copy(userTokenConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(UserTokenConfiguration ... userTokenConfigurations) {
            this.userTokenConfigurations(Arrays.asList(userTokenConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder> ... userTokenConfigurations) {
            this.userTokenConfigurations(Stream.of(userTokenConfigurations).map(c -> (UserTokenConfiguration)((UserTokenConfiguration.Builder)UserTokenConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUserContextPolicy() {
            return this.userContextPolicy;
        }

        public final void setUserContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
        }

        @Override
        public final Builder userContextPolicy(String userContextPolicy) {
            this.userContextPolicy = userContextPolicy;
            return this;
        }

        @Override
        public final Builder userContextPolicy(UserContextPolicy userContextPolicy) {
            this.userContextPolicy(userContextPolicy == null ? null : userContextPolicy.toString());
            return this;
        }

        public final UserGroupResolutionConfiguration.Builder getUserGroupResolutionConfiguration() {
            return this.userGroupResolutionConfiguration != null ? this.userGroupResolutionConfiguration.toBuilder() : null;
        }

        public final void setUserGroupResolutionConfiguration(UserGroupResolutionConfiguration.BuilderImpl userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration != null ? userGroupResolutionConfiguration.build() : null;
        }

        @Override
        public final Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration userGroupResolutionConfiguration) {
            this.userGroupResolutionConfiguration = userGroupResolutionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIndexRequest build() {
            return new CreateIndexRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIndexRequest> {
        public Builder name(String var1);

        public Builder edition(String var1);

        public Builder edition(IndexEdition var1);

        public Builder roleArn(String var1);

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)((ServerSideEncryptionConfiguration.Builder)ServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder userTokenConfigurations(Collection<UserTokenConfiguration> var1);

        public Builder userTokenConfigurations(UserTokenConfiguration ... var1);

        public Builder userTokenConfigurations(Consumer<UserTokenConfiguration.Builder> ... var1);

        public Builder userContextPolicy(String var1);

        public Builder userContextPolicy(UserContextPolicy var1);

        public Builder userGroupResolutionConfiguration(UserGroupResolutionConfiguration var1);

        default public Builder userGroupResolutionConfiguration(Consumer<UserGroupResolutionConfiguration.Builder> userGroupResolutionConfiguration) {
            return this.userGroupResolutionConfiguration((UserGroupResolutionConfiguration)((UserGroupResolutionConfiguration.Builder)UserGroupResolutionConfiguration.builder().applyMutation(userGroupResolutionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

