/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration;
import software.amazon.awssdk.services.kendra.model.Document;
import software.amazon.awssdk.services.kendra.model.DocumentListCopier;
import software.amazon.awssdk.services.kendra.model.KendraRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutDocumentRequest
extends KendraRequest
implements ToCopyableBuilder<Builder, BatchPutDocumentRequest> {
    private static final SdkField<String> INDEX_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexId").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::indexId)).setter(BatchPutDocumentRequest.setter(Builder::indexId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::roleArn)).setter(BatchPutDocumentRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Document>> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Documents").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::documents)).setter(BatchPutDocumentRequest.setter(Builder::documents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Document::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CustomDocumentEnrichmentConfiguration> CUSTOM_DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CustomDocumentEnrichmentConfiguration").getter(BatchPutDocumentRequest.getter(BatchPutDocumentRequest::customDocumentEnrichmentConfiguration)).setter(BatchPutDocumentRequest.setter(Builder::customDocumentEnrichmentConfiguration)).constructor(CustomDocumentEnrichmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDocumentEnrichmentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_ID_FIELD, ROLE_ARN_FIELD, DOCUMENTS_FIELD, CUSTOM_DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchPutDocumentRequest.memberNameToFieldInitializer();
    private final String indexId;
    private final String roleArn;
    private final List<Document> documents;
    private final CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration;

    private BatchPutDocumentRequest(BuilderImpl builder) {
        super(builder);
        this.indexId = builder.indexId;
        this.roleArn = builder.roleArn;
        this.documents = builder.documents;
        this.customDocumentEnrichmentConfiguration = builder.customDocumentEnrichmentConfiguration;
    }

    public final String indexId() {
        return this.indexId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasDocuments() {
        return this.documents != null && !(this.documents instanceof SdkAutoConstructList);
    }

    public final List<Document> documents() {
        return this.documents;
    }

    public final CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration() {
        return this.customDocumentEnrichmentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocuments() ? this.documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customDocumentEnrichmentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutDocumentRequest)) {
            return false;
        }
        BatchPutDocumentRequest other = (BatchPutDocumentRequest)((Object)obj);
        return Objects.equals(this.indexId(), other.indexId()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasDocuments() == other.hasDocuments() && Objects.equals(this.documents(), other.documents()) && Objects.equals(this.customDocumentEnrichmentConfiguration(), other.customDocumentEnrichmentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutDocumentRequest").add("IndexId", (Object)this.indexId()).add("RoleArn", (Object)this.roleArn()).add("Documents", this.hasDocuments() ? this.documents() : null).add("CustomDocumentEnrichmentConfiguration", (Object)this.customDocumentEnrichmentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexId": {
                return Optional.ofNullable(clazz.cast(this.indexId()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
            case "CustomDocumentEnrichmentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.customDocumentEnrichmentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IndexId", INDEX_ID_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Documents", DOCUMENTS_FIELD);
        map.put("CustomDocumentEnrichmentConfiguration", CUSTOM_DOCUMENT_ENRICHMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutDocumentRequest, T> g) {
        return obj -> g.apply((BatchPutDocumentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraRequest.BuilderImpl
    implements Builder {
        private String indexId;
        private String roleArn;
        private List<Document> documents = DefaultSdkAutoConstructList.getInstance();
        private CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutDocumentRequest model) {
            super(model);
            this.indexId(model.indexId);
            this.roleArn(model.roleArn);
            this.documents(model.documents);
            this.customDocumentEnrichmentConfiguration(model.customDocumentEnrichmentConfiguration);
        }

        public final String getIndexId() {
            return this.indexId;
        }

        public final void setIndexId(String indexId) {
            this.indexId = indexId;
        }

        @Override
        public final Builder indexId(String indexId) {
            this.indexId = indexId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Document.Builder> getDocuments() {
            List<Document.Builder> result = DocumentListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<Document.BuilderImpl> documents) {
            this.documents = DocumentListCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<Document> documents) {
            this.documents = DocumentListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Document ... documents) {
            this.documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<Document.Builder> ... documents) {
            this.documents(Stream.of(documents).map(c -> (Document)((Document.Builder)Document.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CustomDocumentEnrichmentConfiguration.Builder getCustomDocumentEnrichmentConfiguration() {
            return this.customDocumentEnrichmentConfiguration != null ? this.customDocumentEnrichmentConfiguration.toBuilder() : null;
        }

        public final void setCustomDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration.BuilderImpl customDocumentEnrichmentConfiguration) {
            this.customDocumentEnrichmentConfiguration = customDocumentEnrichmentConfiguration != null ? customDocumentEnrichmentConfiguration.build() : null;
        }

        @Override
        public final Builder customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration customDocumentEnrichmentConfiguration) {
            this.customDocumentEnrichmentConfiguration = customDocumentEnrichmentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutDocumentRequest build() {
            return new BatchPutDocumentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutDocumentRequest> {
        public Builder indexId(String var1);

        public Builder roleArn(String var1);

        public Builder documents(Collection<Document> var1);

        public Builder documents(Document ... var1);

        public Builder documents(Consumer<Document.Builder> ... var1);

        public Builder customDocumentEnrichmentConfiguration(CustomDocumentEnrichmentConfiguration var1);

        default public Builder customDocumentEnrichmentConfiguration(Consumer<CustomDocumentEnrichmentConfiguration.Builder> customDocumentEnrichmentConfiguration) {
            return this.customDocumentEnrichmentConfiguration((CustomDocumentEnrichmentConfiguration)((CustomDocumentEnrichmentConfiguration.Builder)CustomDocumentEnrichmentConfiguration.builder().applyMutation(customDocumentEnrichmentConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

