/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.internal.UserAgentUtils;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesRequest;
import software.amazon.awssdk.services.kendra.model.ListExperienceEntitiesResponse;

public class ListExperienceEntitiesIterable
implements SdkIterable<ListExperienceEntitiesResponse> {
    private final KendraClient client;
    private final ListExperienceEntitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExperienceEntitiesIterable(KendraClient client, ListExperienceEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExperienceEntitiesResponseFetcher();
    }

    public Iterator<ListExperienceEntitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListExperienceEntitiesResponseFetcher
    implements SyncPageFetcher<ListExperienceEntitiesResponse> {
        private ListExperienceEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListExperienceEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExperienceEntitiesResponse nextPage(ListExperienceEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListExperienceEntitiesIterable.this.client.listExperienceEntities(ListExperienceEntitiesIterable.this.firstRequest);
            }
            return ListExperienceEntitiesIterable.this.client.listExperienceEntities((ListExperienceEntitiesRequest)((Object)ListExperienceEntitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

