/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.SnapshotsDataHeaderFieldsCopier;
import software.amazon.awssdk.services.kendra.model.SnapshotsDataRecordsCopier;
import software.amazon.awssdk.services.kendra.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSnapshotsResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, GetSnapshotsResponse> {
    private static final SdkField<TimeRange> SNAP_SHOT_TIME_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapShotTimeFilter").getter(GetSnapshotsResponse.getter(GetSnapshotsResponse::snapShotTimeFilter)).setter(GetSnapshotsResponse.setter(Builder::snapShotTimeFilter)).constructor(TimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapShotTimeFilter").build()}).build();
    private static final SdkField<List<String>> SNAPSHOTS_DATA_HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotsDataHeader").getter(GetSnapshotsResponse.getter(GetSnapshotsResponse::snapshotsDataHeader)).setter(GetSnapshotsResponse.setter(Builder::snapshotsDataHeader)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotsDataHeader").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<String>>> SNAPSHOTS_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotsData").getter(GetSnapshotsResponse.getter(GetSnapshotsResponse::snapshotsData)).setter(GetSnapshotsResponse.setter(Builder::snapshotsData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotsData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSnapshotsResponse.getter(GetSnapshotsResponse::nextToken)).setter(GetSnapshotsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAP_SHOT_TIME_FILTER_FIELD, SNAPSHOTS_DATA_HEADER_FIELD, SNAPSHOTS_DATA_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSnapshotsResponse.memberNameToFieldInitializer();
    private final TimeRange snapShotTimeFilter;
    private final List<String> snapshotsDataHeader;
    private final List<List<String>> snapshotsData;
    private final String nextToken;

    private GetSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapShotTimeFilter = builder.snapShotTimeFilter;
        this.snapshotsDataHeader = builder.snapshotsDataHeader;
        this.snapshotsData = builder.snapshotsData;
        this.nextToken = builder.nextToken;
    }

    public final TimeRange snapShotTimeFilter() {
        return this.snapShotTimeFilter;
    }

    public final boolean hasSnapshotsDataHeader() {
        return this.snapshotsDataHeader != null && !(this.snapshotsDataHeader instanceof SdkAutoConstructList);
    }

    public final List<String> snapshotsDataHeader() {
        return this.snapshotsDataHeader;
    }

    public final boolean hasSnapshotsData() {
        return this.snapshotsData != null && !(this.snapshotsData instanceof SdkAutoConstructList);
    }

    public final List<List<String>> snapshotsData() {
        return this.snapshotsData;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapShotTimeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotsDataHeader() ? this.snapshotsDataHeader() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotsData() ? this.snapshotsData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSnapshotsResponse)) {
            return false;
        }
        GetSnapshotsResponse other = (GetSnapshotsResponse)((Object)obj);
        return Objects.equals(this.snapShotTimeFilter(), other.snapShotTimeFilter()) && this.hasSnapshotsDataHeader() == other.hasSnapshotsDataHeader() && Objects.equals(this.snapshotsDataHeader(), other.snapshotsDataHeader()) && this.hasSnapshotsData() == other.hasSnapshotsData() && Objects.equals(this.snapshotsData(), other.snapshotsData()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetSnapshotsResponse").add("SnapShotTimeFilter", (Object)this.snapShotTimeFilter()).add("SnapshotsDataHeader", this.hasSnapshotsDataHeader() ? this.snapshotsDataHeader() : null).add("SnapshotsData", this.hasSnapshotsData() ? this.snapshotsData() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapShotTimeFilter": {
                return Optional.ofNullable(clazz.cast(this.snapShotTimeFilter()));
            }
            case "SnapshotsDataHeader": {
                return Optional.ofNullable(clazz.cast(this.snapshotsDataHeader()));
            }
            case "SnapshotsData": {
                return Optional.ofNullable(clazz.cast(this.snapshotsData()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SnapShotTimeFilter", SNAP_SHOT_TIME_FILTER_FIELD);
        map.put("SnapshotsDataHeader", SNAPSHOTS_DATA_HEADER_FIELD);
        map.put("SnapshotsData", SNAPSHOTS_DATA_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSnapshotsResponse, T> g) {
        return obj -> g.apply((GetSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private TimeRange snapShotTimeFilter;
        private List<String> snapshotsDataHeader = DefaultSdkAutoConstructList.getInstance();
        private List<List<String>> snapshotsData = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSnapshotsResponse model) {
            super(model);
            this.snapShotTimeFilter(model.snapShotTimeFilter);
            this.snapshotsDataHeader(model.snapshotsDataHeader);
            this.snapshotsData(model.snapshotsData);
            this.nextToken(model.nextToken);
        }

        public final TimeRange.Builder getSnapShotTimeFilter() {
            return this.snapShotTimeFilter != null ? this.snapShotTimeFilter.toBuilder() : null;
        }

        public final void setSnapShotTimeFilter(TimeRange.BuilderImpl snapShotTimeFilter) {
            this.snapShotTimeFilter = snapShotTimeFilter != null ? snapShotTimeFilter.build() : null;
        }

        @Override
        public final Builder snapShotTimeFilter(TimeRange snapShotTimeFilter) {
            this.snapShotTimeFilter = snapShotTimeFilter;
            return this;
        }

        public final Collection<String> getSnapshotsDataHeader() {
            if (this.snapshotsDataHeader instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshotsDataHeader;
        }

        public final void setSnapshotsDataHeader(Collection<String> snapshotsDataHeader) {
            this.snapshotsDataHeader = SnapshotsDataHeaderFieldsCopier.copy(snapshotsDataHeader);
        }

        @Override
        public final Builder snapshotsDataHeader(Collection<String> snapshotsDataHeader) {
            this.snapshotsDataHeader = SnapshotsDataHeaderFieldsCopier.copy(snapshotsDataHeader);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotsDataHeader(String ... snapshotsDataHeader) {
            this.snapshotsDataHeader(Arrays.asList(snapshotsDataHeader));
            return this;
        }

        public final Collection<? extends Collection<String>> getSnapshotsData() {
            if (this.snapshotsData instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshotsData;
        }

        public final void setSnapshotsData(Collection<? extends Collection<String>> snapshotsData) {
            this.snapshotsData = SnapshotsDataRecordsCopier.copy(snapshotsData);
        }

        @Override
        public final Builder snapshotsData(Collection<? extends Collection<String>> snapshotsData) {
            this.snapshotsData = SnapshotsDataRecordsCopier.copy(snapshotsData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotsData(Collection<String> ... snapshotsData) {
            this.snapshotsData((Collection<? extends Collection<String>>)Arrays.asList(snapshotsData));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSnapshotsResponse build() {
            return new GetSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSnapshotsResponse> {
        public Builder snapShotTimeFilter(TimeRange var1);

        default public Builder snapShotTimeFilter(Consumer<TimeRange.Builder> snapShotTimeFilter) {
            return this.snapShotTimeFilter((TimeRange)((TimeRange.Builder)TimeRange.builder().applyMutation(snapShotTimeFilter)).build());
        }

        public Builder snapshotsDataHeader(Collection<String> var1);

        public Builder snapshotsDataHeader(String ... var1);

        public Builder snapshotsData(Collection<? extends Collection<String>> var1);

        public Builder snapshotsData(Collection<String> ... var1);

        public Builder nextToken(String var1);
    }
}

